/*
  stores all known streams
  Copyright (C) 1999 Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __DEVICECONFIG_H
#define __DEVICECONFIG_H


#include <deviceConfig/stream/audioStream.h>
#include <deviceConfig/stream/infoStream.h>
#include <deviceConfig/stream/videoStream.h>

/**
   The deviceConfig class is the "holder" of all streams.
   Currently we have audio/video and info streams.
   This class stores them. It wraps all streams an delivers
   them all together. A device has to test
   if some of these streams have invalid data, which then
   means: it has to ignore it.
   Eg: if the deviceConfig class delivers onyl infoData and the
   audio and video data is invalid then the audioDevice must
   test this condition and because the audioData is invalid it
   has to ignore it.
   a connected streamInfoDevice can be happy, because the
   infoStream has valid data.
   Stream should never have dependencies. This means, if the
   infostream has valid data that you can expect
   to have the audioStream has as well valid data. Stream
   are completley seperated!

*/


class DeviceConfig : public Stream {


  AudioStream* audioStream;
  VideoStream* videoStream;
  InfoStream* infoStream;
  
  void* streamProducer;
  
 public:
  DeviceConfig();
  ~DeviceConfig();

  void setAudioStream(AudioStream* audioStream); 
  AudioStream* getAudioStream(); 

  void setVideoStream(VideoStream* videoStream); 
  VideoStream* getVideoStream(); 
  
  void setInfoStream(InfoStream* infoStream);
  InfoStream* getInfoStream();

  void copyTo(Stream* aConfig);
  void print();

  // streamProducer are stored as a void pointer because
  // of a recursive inclusion!
  // you should safley cast it where you need it.
  void* getStreamProducer();
  void setStreamProducer(void* streamProducer);

  void forward();
  int isValid();
  void addLock();
  void removeLock();
  

};

#endif
