/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef __SONG_LOGGER
#define __SONG_LOGGER

#include <kapp.h>
#include <kconfig.h>
#include <ktablistbox.h>
#include <qdatetime.h>
#include <qwidget.h>
#include <fstream.h>
#include <iostream.h>
#include "song.h"
#include "kjukebox.h"

class SongLogger : public QObject{
  Q_OBJECT
 private:
  KTabListBox *table;
  KConfig     *config;

  bool enable;
  
  int saveString();
  int loadLogFile();
  
  void openLogFile();
  void readLogFile();    
  void addLogEntry(const char *);
  
  ofstream logFile;
  
  static int compareString(const char *, const char *);
  static int compareDateTime(const char *, const char *);
  static int compareTime(const char *, const char *);

 public:
  SongLogger(QWidget *parent, const char *name );
  ~SongLogger();

 public slots:
  void appendSong(Song *song);
  void hide();
  void show();
  void toggleVisible();
  void reinitialize();
};


#endif
