/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/


#ifndef SONGLIST_H
#define SONGLIST_H
#include <qwidget.h>
#include <ktable.h> 
#include <kpopmenu.h>
#include <qstring.h>
#include "kjukebox.h"
#include <qgroupbox.h>
#include "lists.h"

class SongList : public KTable{
  Q_OBJECT
 private:
  int          artistWidth;
  int          titleWidth;
  int          timeWidth;
  KTable      *table;
  QSongList    songs;
  QString      titleName;
  QString      songAsString(Song);
  QGroupBox   *box;  
  KPopupMenu   *rightButtonMenu;
  int          lastSelection;
  void refreshDisplay();
  void setupSurface(QString);

 public:
  SongList(QString, QWidget *parent=0, const char *name=0);
  SongList(QWidget *parent=0, const char *name=0);
  Song getFirstSongToPlay();
  Song getRandomSongToPlay();
  Song getSelection();
  QSongList removePlayedSongs();
  void removeAllSongs();
  bool hasReference(Song *song);
  
 protected:
  void resizeEvent(QResizeEvent *);
  
 signals:
  void doubleClick();
  void genreChanged(QString );
  void selectionChanged();
  void playSong(Song);
  void showMP3Info(Song);

  
 private slots:
  void doubleClick(int,int);
  void selectionChanged(int,int);
  void rightButtonPressed(int row, int col);
  
 public slots:
  void clearSelection();
  void addSongs(QSongList songs);
  Song* removeSong();
  void referenceChanged(Song *oldRef, Song *newRef);
  QSongList getAllReferencedSongs();
  void markPlayed();
  void markNotPlayed();
  void markAllPlayed();
  void markAllNotPlayed();
  void moveUp();
  void moveDown();
};
  
#endif
