/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/


#ifndef SONG_H
#define SONG_H

#include <qstring.h>

/* The Format for fromString:  */
/* Titel|Artist|Album|Year|Comment|Genre|Layer|Bitrate|... */
/*     ...Samplarate|Stereo|Time|Filename|Size|Lastplayed| */

#define SAVELOADFORMAT "TI|AR|AL|YE|CO|GE|SE|FS|LS|BI|SA|ST|LA|SI|FN"
#define SAVELOADTRENNZEICHEN "|"


class Song {
private:    
  QString artistAlbumTitleSortString; /* for a fast sorting */
  QString titleArtistAlbumSortString; /* for a fast sorting */
  QString title;
  QString artist;
  QString album;
  QString comment;
  QString genre;
  QString filename;
  QString stereomode;
  QString layer;
  bool   played;
  bool   nullFlag;
  int    genreNumber;
  unsigned int lastplayed;
  unsigned int samplerate;
  unsigned int bitrate;
  unsigned int year;
  unsigned int seconds;
  unsigned int firstSeconds;
  unsigned int lastSeconds;  
  unsigned int size;
  QString asQString(unsigned int );
  void createSortStrings();
  void upcaseFirstLetters(QString *);

public:
  Song();
  QString asString();
  QString asString(QString, QString);
  bool isNull();
  QString getArtistAlbumTitle();
  QString getTitleArtistAlbum();
  void initFromString(QString);
  void initFromString(QString, QString, QString);
  void checkForPlausibility();
  void checkForPlausibility(QString);
  void setTitle(QString, bool refresh=true);
  void setArtist(QString, bool refresh=true);
  void setAlbum(QString, bool refresh=true);
  void setComment(QString, bool refresh=true);
  void setGenre(QString, bool refresh=true);
  void setFilename(QString, bool refresh=true);
  void setStereomode(QString, bool refresh=true);
  void setLayer(QString, bool refresh=true);
  void setPlayed(bool, bool refresh=true);
  void setGenreNum(int genreNum, bool refresh=true );
  void setLastPlayed(unsigned int , bool refresh=true);
  void setSamplerate(unsigned int , bool refresh=true);
  void setBitrate(unsigned int , bool refresh=true);
  void setYear(unsigned int , bool refresh=true);
  void setSeconds(unsigned int , bool refresh=true);
  void setFirstSeconds(unsigned int , bool refresh=true);
  void setLastSeconds(unsigned int , bool refresh=true);
  void setSize(unsigned int , bool refresh=true);
  QString getTitle() const;
  QString getArtist() const;
  QString getAlbum() const;
  QString getComment() const;
  QString getGenre() const;
  QString getFilename() const;
  QString getStereomode() const;
  QString getLayer() const;
  bool    getPlayed() const;
  int     getGenreNum() const;
  unsigned int getLastPlayed() const;
  unsigned int getSamplerate() const;
  unsigned int getBitrate() const;
  unsigned int getYear() const;
  unsigned int getSeconds() const;
  unsigned int getFirstSeconds() const;
  unsigned int getLastSeconds() const;
  unsigned int getSize() const;

  void print();
  void upcaseFirstLetters();

  bool operator== (Song);
  bool operator< (Song);
};


#endif 
