/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef MP3_H
#define MP3_H

#include "kjukebox.h"
#include <stdio.h>
#include <stdlib.h>
#include "mp3layer.h"
#include "mp3tag.h"
#include "kconfig.h"
#include "kapp.h"

#define FILENAME_LEN 2048
/* MPEG Header Definitions - Mode Values */

#define         MPG_MD_STEREO           0
#define         MPG_MD_JOINT_STEREO     1
#define         MPG_MD_DUAL_CHANNEL     2
#define         MPG_MD_MONO             3

#define         MPG_MD_LR_LR             0
#define         MPG_MD_LR_I              1
#define         MPG_MD_MS_LR             2
#define         MPG_MD_MS_I              3


class MP3 {
 private:
  KConfig *config;
  Tag *tag;
  Layer *layer;
  bool hastag;
  bool haslayer;
  char *format;
  FILE *file;
  size_t filelength;
  char filename[FILENAME_LEN];
  bool open(const char *name, bool forSave);
  bool openForSave(const char *name);
 public:
  MP3(); 
  ~MP3();

  bool open(const char *name);
  bool saveTags();
  bool initfile(bool gettag=1);
  Song getSong();
  void close();
  bool saveCommentTag(const char *fname, const char *);
  bool saveTag(const char *fname, Tag mp3tag);
};



#endif //MP3_H
