/*
  a class for LCD digits
  Copyright (C) 1998  Martin Vogt & Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef LCDBITMAP_H
#define LCDBITMAP_H

#include <qpixmap.h> 


/*
  This class defines a few LCD digits as they are on the most 
  cd players.
*/

#define _LCD_DIGIT_0    0
#define _LCD_DIGIT_1    1
#define _LCD_DIGIT_2    2
#define _LCD_DIGIT_3    3
#define _LCD_DIGIT_4    4
#define _LCD_DIGIT_5    5
#define _LCD_DIGIT_6    6
#define _LCD_DIGIT_7    7
#define _LCD_DIGIT_8    8
#define _LCD_DIGIT_9    9

#define _LCD_PANEL      10
#define _LCD_DOTS       11
#define _LCD_BLANK      12
#define _LCD_PAUSE      13
#define _LCD_PLAY       14
#define _LCD_MINUS      15
#define _LCD_STOP       16

#define _LCD_COL_RIGHT  17
#define _LCD_A          18
#define _LCD_B          19
#define _LCD_C          20
#define _LCD_D          21
#define _LCD_E          22
#define _LCD_F          23

#define _LCD_ELEMENTS   24

class LCDBitmap {

 public:
  LCDBitmap();
  ~LCDBitmap();

  QPixmap* getPixmap(int type);

 private:
  QPixmap* pixmapArray[_LCD_ELEMENTS];

};

#endif
