/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef FADEDEVICE_H
#define FADEDEVICE_H

#include <devices/audioStreamInfoDevice.h>
#include <devices/volumeDevice.h>
#include <kapp.h>
#include <kconfig.h>

#define _FADEMODE_FADEIN     0
#define _FADEMODE_FADEOUT    1
#define _FADE_STEPS       25.0
#define _FADE_MAX_VOLUME   100 /* set max volume at fadein  to 100 % */
#define _FADE_MIN_VOLUME     0 /* set min volume at fadeout to   0 % */

class FadeDevice : public QObject{
  Q_OBJECT
 private:
  int   playMode;
  int   fadeMode;
  int   timerId;
  int   fadeDuration;
  int   startVolume;
  int   volumeIntervall;
  float counter;
  AudioStreamInfoDevice *streamInfoDevice;
  VolumeDevice     *volumeDevice;
  KConfig          *config;

  void startFadeTimer(bool hardFade=true);
  void songStopped();
  void songStarted();
  void stopFade();

 private slots:
  void processEvent(char eventId);

 protected:
  void timerEvent( QTimerEvent * );

 public:
  FadeDevice();
  ~FadeDevice();
  void attachTo(AudioStreamInfoDevice* streamInfoDevice);
  void attachTo(VolumeDevice* volumeDevice);
  void detach();

  void setFadeMode(int fadeMode);
  void setFadeDuration(int seconds);
  int  getFadeMode();
  bool isFading();

 signals:
  void fadeInReady();
  void fadeOutReady();
  void fadeInStarted();
  void fadeOutStarted();
  void volumeChanged(int);

 public slots:
  void setVolume(int);
  void fadeIn();
  void fadeOut();
  void fadeOutSoftly();
  void stopFading();
};


#endif /* FadeDevice_H */



