/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef DATABASE_H
#define DATABASE_H


#include "../config.h"
#include "kjukebox.h"
#include <kapp.h>
#include <qstring.h>
#include <qlist.h>
#include <qobject.h>
#include "lists.h"
#include "songList.h"

class DataBase : public QObject{
  Q_OBJECT

 private:
  QSongListByArtist listByArtist;
  QSongListByTitle  listByTitle;
  QSongList         listForPlayList;
  QGenreSet         genreSet;
  QString           currentGenre;
  int               currentOrder;
  bool              modifiedFlag;
  SongList         *playList;

 public:
  DataBase(QObject *parent=0, const char *name=0);
  ~DataBase();
  void modifikationSaved();
  bool isModified();
  void remove(QString artist="", QString album="", 
	      QString title="",  QString genre="",
	      unsigned int seconds=0);
  QSongList find(Song  song);
  QSongList find(Song *song);
  QSongList find(QString artist="", QString album="", 
		 QString title="",  QString genre="",
		 unsigned int seconds=0);
  Song *findInPlayList(Song song);
  QGenreSet* getGenres();
  void clear(bool emitSingals=true);
  void checkGenreSet();
  void attach(SongList *playList);
  void detach(SongList *playList);
  void print();

 public slots:
  void modified();

  void setSortOrder(int order);
  void insert(QSongList newSongs);
  void insert(Song *newSong);
  void insert(Song  newSong);
  void insertPlayList(QSongList  newSong);
  void remove(Song *song);
  void remove(Song song);
  void remove(Song *song, bool checkGenres, bool emitSignal=true);
  void remove(QSongList songs);
  void removeInPlayList(Song *song);
  void clearPlayList();
  void setGenre(QString genre);
  QString   getGenre();
  QSongList getSongList();
  QSongList getCompleteSongList();
  void songChanged(Song *song);
  void checkPlayList();
            
 signals:
  void dBChanged();
  void dBCleared();
  void genreChanged();
  void genreSetChanged();
  void songRemovedWithRef(Song *song);
  void referenceChanged(Song *oldRef, Song* newRef);
};
#endif // MENU_H
