/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include "commandLineParameters.h"

#if defined(HAVE_GETOPT_H)
#include <getopt.h>
#endif       

QStrList CommandLineParameters::fileList;

CommandLineParameters::CommandLineParameters(int nargs,char** args){
  parse(nargs,args);
}

void CommandLineParameters::parse(int nargs,char** args) {
  int c;
  int i=1;
  fileList.clear();
  
  if (nargs <= 1) { return;  }
  while(1) { 
    c = getopt (nargs, args, "hv");
    if (c == -1) break;
    i++;
    switch(c) {
    case 'h': usage();  exit(0);
    case 'v': version(); exit(0);
    default:
      usage();
      exit(-1);
    }
  }

  while(i<nargs) {
    cout << args[i] << endl;
    fileList.append(args[i]);
    i++;
  }
}


void CommandLineParameters::version(){
  cout << "KJukeBox-"<< VERSION << endl;
}

void CommandLineParameters::usage() {
  cout << "KJukeBox-"<< VERSION
       << i18n(" is a MP3 player and database for the K Desktop Environment")<<endl;
  cout << i18n("Usage : kjukebox [-vh] file1 file2 ...")<<endl;
  cout << endl;
  cout << i18n("-v : show version")<<endl;
  cout << i18n("-h : this message")<<endl;
  cout << i18n("<no options> : plays file1 and append the rest to the playlist")<<endl;
  cout << endl;
  cout << i18n("THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY! ") \
       << i18n("USE AT YOUR OWN RISK!")<<endl;
  cout << endl;
}

QStrList* CommandLineParameters::getFileList(){ return &fileList; }
