/***************************************************************************
                          kguitune.cpp  -  description
                             -------------------
    begin                : Sun Jan 16 23:56:00 CET 2000
    copyright            : (C) 2000 by Florian Berger
    email                : florian.berger@jk.uni-linz.ac.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <unistd.h>  // for execlp, fork

// include files for QT
#include <qdir.h>
#include <qstrlist.h>
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kfiledialog.h>

// application specific includes
#include <kguitune.h>
#include "kguituneview.h"
#include "resource.h"


KGuituneApp::KGuituneApp()
{
	config=kapp->getConfig();
	
  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initKeyAccel();
  initView();
  initStatusBar();
	
  readOptions();

  setMinimumSize(490,240+menuBar()->height()
                        +statusBar()->height()
                        +toolBar()->height() );

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
//  disableCommand(ID_FILE_SAVE);
//  disableCommand(ID_FILE_SAVE_AS);
//  disableCommand(ID_FILE_PRINT);
 	
//  disableCommand(ID_EDIT_CUT);
//  disableCommand(ID_EDIT_COPY);
//  disableCommand(ID_EDIT_PASTE);
}

KGuituneApp::~KGuituneApp()
{

}

void KGuituneApp::initKeyAccel()
{
	key_accel = new KAccel( this );
	
	// file_menu accelerators
	key_accel->connectItem( KAccel::Quit, this, SLOT( slotFileQuit() ) );
	// edit_menu accelerators

	key_accel->connectItem( KAccel::Help, kapp, SLOT( appHelpActivated() ) );
			
//	key_accel->changeMenuAccel(	file_menu, ID_FILE_NEW, KAccel::New );
//	key_accel->changeMenuAccel(	file_menu, ID_FILE_OPEN, KAccel::Open );
//	key_accel->changeMenuAccel(	file_menu, ID_FILE_SAVE, KAccel::Save );
//	key_accel->changeMenuAccel( file_menu, ID_FILE_CLOSE, KAccel::Close );
//	key_accel->changeMenuAccel(	file_menu, ID_FILE_PRINT, KAccel::Print );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_QUIT, KAccel::Quit );

//  key_accel->changeMenuAccel(	edit_menu, ID_EDIT_CUT, KAccel::Cut );
//  key_accel->changeMenuAccel(	edit_menu, ID_EDIT_COPY, KAccel::Copy );
//  key_accel->changeMenuAccel(	edit_menu, ID_EDIT_PASTE, KAccel::Paste );

  key_accel->readSettings();	
}

void KGuituneApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR


  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  file_menu = new QPopupMenu();
//  file_menu->insertItem(kapp->getMiniIcon(), i18n("New &Window"), ID_FILE_NEW_WINDOW );
//  file_menu->insertSeparator();
//  file_menu->insertItem(Icon("filenew.xpm"), i18n("&New"), ID_FILE_NEW );
//  file_menu->insertItem(Icon("fileopen.xpm"), i18n("&Open..."), ID_FILE_OPEN );
//  file_menu->insertItem(i18n("Open &recent"), recent_files_menu, ID_FILE_OPEN_RECENT );

//  file_menu->insertItem(i18n("&Close"), ID_FILE_CLOSE );
//  file_menu->insertSeparator();
//  file_menu->insertItem(Icon("filefloppy.xpm") ,i18n("&Save"), ID_FILE_SAVE );
//  file_menu->insertItem(i18n("Save &As..."), ID_FILE_SAVE_AS );
//  file_menu->insertSeparator();
//  file_menu->insertItem(Icon("fileprint.xpm"), i18n("&Print..."), ID_FILE_PRINT );
//  file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"), ID_FILE_QUIT );
	
  ///////////////////////////////////////////////////////////////////
  // options_menu entry tuning_menu
  tuning_menu = new QPopupMenu();
  tuning_menu->setCheckable(true);
  tuning_menu->insertItem(i18n("&Normal"),   ID_TUNING_NORM );
  tuning_menu->insertItem(i18n("&Wien"),     ID_TUNING_WIEN );
  tuning_menu->insertItem(i18n("&Physical"), ID_TUNING_PHYS );
	  tuning_menu->setItemChecked(ID_TUNING_NORM, true);
	  tuning_menu->setItemChecked(ID_TUNING_WIEN, false);
	  tuning_menu->setItemChecked(ID_TUNING_PHYS, false);
  tuning_menu->insertSeparator();
  tuning_menu->insertItem(i18n("&Equidistant"),   ID_TUNING_EQUI );
  tuning_menu->insertItem(i18n("&Natural"),       ID_TUNING_NAT );
	  tuning_menu->setItemChecked(ID_TUNING_EQUI, true);
	  tuning_menu->setItemChecked(ID_TUNING_NAT,  false);


  ///////////////////////////////////////////////////////////////////
  // options_menu entry scale_menu
  scale_menu = new QPopupMenu();
  scale_menu->setCheckable(true);
  scale_menu->insertItem(i18n("&US"),             ID_SCALE_US  );
  scale_menu->insertItem(i18n("U&S-Alternate"),   ID_SCALE_USA );
  scale_menu->insertItem(i18n("&German"),         ID_SCALE_GE  );
  scale_menu->insertItem(i18n("G&erman-Alt."),    ID_SCALE_GEA );
	  scale_menu->setItemChecked(ID_SCALE_US,   true );
	  scale_menu->setItemChecked(ID_SCALE_USA,  false);
	  scale_menu->setItemChecked(ID_SCALE_GE,   false);
	  scale_menu->setItemChecked(ID_SCALE_GEA,  false);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry options_menu
  options_menu = new QPopupMenu();
//  options_menu->insertItem(i18n("&Sound Options..."), ID_OPTIONS_SOUND );
//  options_menu->insertItem(i18n("Sample &Number"), ID_OPTIONS_SAMPLENR );
//  options_menu->insertItem(i18n("Sample &Frequency"), ID_OPTIONS_SAMPLEFREQ );
//  options_menu->insertItem(i18n("&Trigger"), ID_OPTIONS_TRIGGER );
  options_menu->insertItem(i18n("&Tuning"), tuning_menu );
  options_menu->insertItem(i18n("&Note Scale"), scale_menu );
  options_menu->insertSeparator();
  options_menu->insertItem(Icon("mini/kmix.xpm"), i18n("Run &Mixer"), ID_OPTIONS_RUNMIXER );

  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem(i18n("&Toolbar"), ID_VIEW_TOOLBAR);
  view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );
//  view_menu->insertItem(i18n("&OSZI"), ID_VIEW_OSZI );
//  view_menu->insertItem(i18n("&Note Scale"), ID_VIEW_NOTESCALE );

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  QString aboutstring=kapp->appName()+" "+VERSION+"\n\n"+
          "(c) 2000 Florian Berger <florian.berger@jk.uni-linz.ac.at>";

  help_menu = new QPopupMenu();
  help_menu = kapp->getHelpMenu(true, aboutstring );

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // insert your popup menus with the according menubar entries in the order
  // they will appear later from left to right
  menuBar()->insertItem(i18n("&File"), file_menu);
  menuBar()->insertItem(i18n("&Options"), options_menu);
  menuBar()->insertItem(i18n("&View"), view_menu);

  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE MENU SLOTS WITH SIGNALS
  // for execution slots and statusbar messages

  connect(file_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(file_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(tuning_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(tuning_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(scale_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(scale_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(options_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(options_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(view_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(view_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

}

void KGuituneApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
//  toolBar()->insertButton(Icon("filenew.xpm"), ID_FILE_NEW, true, i18n("New File") );
//  toolBar()->insertButton(Icon("fileopen.xpm"), ID_FILE_OPEN, true, i18n("Open File") );
//  toolBar()->insertButton(Icon("filefloppy.xpm"), ID_FILE_SAVE, true, i18n("Save File") );
//  toolBar()->insertButton(Icon("fileprint.xpm"), ID_FILE_PRINT, true, i18n("Print") );
//  toolBar()->insertSeparator();
//  toolBar()->insertButton(Icon("editcut.xpm"), ID_EDIT_CUT, true, i18n("Cut") );
//  toolBar()->insertButton(Icon("editcopy.xpm"), ID_EDIT_COPY, true, i18n("Copy") );
//  toolBar()->insertButton(Icon("editpaste.xpm"), ID_EDIT_PASTE, true, i18n("Paste") );
//  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("mini/kmix.xpm"), ID_OPTIONS_RUNMIXER, true, i18n("Run Mixer") ),
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("exit.xpm"),  ID_FILE_QUIT, true, i18n("Quit") ),
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("help.xpm"), ID_HELP_CONTENTS, SIGNAL(clicked() ),
  				kapp, SLOT( appHelpActivated() ), true,i18n("Help"));

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE WITH toolBar(n)


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars by their according number
	// connect for invoking the slot actions
  connect(toolBar(), SIGNAL(clicked(int)), SLOT(commandCallback(int)));
	// connect for the status help on holing icons pressed with the mouse button
  connect(toolBar(), SIGNAL(pressed(int)), SLOT(statusCallback(int)));

}

void KGuituneApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
	// TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n("TR:0.00"),   ID_STATUS_TR );
  statusBar()->insertItem(i18n("SN:00000"), ID_STATUS_SN );
  statusBar()->insertItem(i18n("SF:00000"), ID_STATUS_SF );
  statusBar()->insertItem(i18n("Ready."),   ID_STATUS_MSG );
  statusBar()->setInsertOrder(KStatusBar::RightToLeft);
  slotStatusSF();
  slotStatusSN();
  slotStatusTR();
  connect( view, SIGNAL(signalSampFreqChanged()),
           this, SLOT(slotStatusSF()) );
  connect( view, SIGNAL(signalSampNrChanged()),
           this, SLOT(slotStatusSN()) );
  connect( view, SIGNAL(signalTriggerChanged()),
           this, SLOT(slotStatusTR()) );
}

void KGuituneApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.

  view = new KGuituneView(this);
  setView(view);
//  QString caption=kapp->getCaption();	
//  setCaption(caption+": "+doc->getTitle());

}

void KGuituneApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

void KGuituneApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}

void KGuituneApp::saveOptions()
{	
	config->setGroup("General Options");
	config->writeEntry("Geometry", size() );
  config->writeEntry("Show Toolbar", toolBar()->isVisible());
  config->writeEntry("Show Statusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBarPos",  (int)toolBar()->barPos());
	config->writeEntry("DSPDeviceName", dsp_devicename );
}


void KGuituneApp::readOptions()
{
	
	config->setGroup("General Options");

	// bar status settings
	bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
	view_menu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
	if(!bViewToolbar)
		enableToolBar(KToolBar::Hide);
	
  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
	view_menu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
	if(!bViewStatusbar)
		enableStatusBar(KStatusBar::Hide);
	
  bool bViewOSZI = config->readBoolEntry("Show OSZI", true);
	view_menu->setItemChecked(ID_VIEW_OSZI, bViewOSZI);
//	if(!bViewOSZI)
//		enableOSZI(KStatusBar::Hide);
	
  bool bViewNoteScale = config->readBoolEntry("Show NoteScale", true);
	view_menu->setItemChecked(ID_VIEW_NOTESCALE, bViewNoteScale);
//	if(!bViewNoteScale)
//		enableNoteScale(KStatusBar::Hide);
	
	// bar position settings
	KMenuBar::menuPosition menu_bar_pos;
	menu_bar_pos=(KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top);

  KToolBar::BarPosition tool_bar_pos;
  tool_bar_pos=(KToolBar::BarPosition)config->readNumEntry("ToolBarPos", KToolBar::Top);

	menuBar()->setMenuBarPos(menu_bar_pos);
  toolBar()->setBarPos(tool_bar_pos);
	
  QSize size=config->readSizeEntry("Geometry");
	if(!size.isEmpty())
		resize(size);

	// dsp-device
  dsp_devicename = config->readEntry("DSPDeviceName", QString("/dev/dsp"));
  view->setDSPName((const char *)dsp_devicename);

}

bool KGuituneApp::queryExit()
{
	saveOptions();
	return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KGuituneApp::slotFileQuit()
{
	saveOptions();
	// close the first window, the list makes the next one the first again.
	// This ensures that queryClose() is called on each window to ask for closing
	KTMainWindow* w;
	if(memberList){
		for(w=memberList->first(); w; w=memberList->first()){
			// only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
			// the window and the application stay open.
			if(!w->close())
				break;
		}
	}	
}


void KGuituneApp::slotTuningNorm()
{
    view->setTuningNorm();
	  tuning_menu->setItemChecked(ID_TUNING_NORM, true);
	  tuning_menu->setItemChecked(ID_TUNING_WIEN, false);
	  tuning_menu->setItemChecked(ID_TUNING_PHYS, false);
}


void KGuituneApp::slotTuningWien()
{
    view->setTuningWien();
	  tuning_menu->setItemChecked(ID_TUNING_NORM, false);
	  tuning_menu->setItemChecked(ID_TUNING_WIEN, true);
	  tuning_menu->setItemChecked(ID_TUNING_PHYS, false);
}


void KGuituneApp::slotTuningPhys()
{
    view->setTuningPhys();
	  tuning_menu->setItemChecked(ID_TUNING_NORM, false);
	  tuning_menu->setItemChecked(ID_TUNING_WIEN, false);
	  tuning_menu->setItemChecked(ID_TUNING_PHYS, true);
}


void KGuituneApp::slotTuningEqui()
{
    view->setTuningEqui();
	  tuning_menu->setItemChecked(ID_TUNING_EQUI, true);
	  tuning_menu->setItemChecked(ID_TUNING_NAT,  false);
}


void KGuituneApp::slotTuningNat()
{
    view->setTuningNat();
	  tuning_menu->setItemChecked(ID_TUNING_EQUI, false);
	  tuning_menu->setItemChecked(ID_TUNING_NAT,  true);
}


void KGuituneApp::slotScaleUS()
{
    view->setScaleUS();
	  scale_menu->setItemChecked(ID_SCALE_US,   true );
	  scale_menu->setItemChecked(ID_SCALE_USA,  false);
	  scale_menu->setItemChecked(ID_SCALE_GE,   false);
	  scale_menu->setItemChecked(ID_SCALE_GEA,  false);
}


void KGuituneApp::slotScaleUSAlt()
{
    view->setScaleUSAlt();
	  scale_menu->setItemChecked(ID_SCALE_US,   false);
	  scale_menu->setItemChecked(ID_SCALE_USA,  true );
	  scale_menu->setItemChecked(ID_SCALE_GE,   false);
	  scale_menu->setItemChecked(ID_SCALE_GEA,  false);
}


void KGuituneApp::slotScaleGE()
{
    view->setScaleGE();
	  scale_menu->setItemChecked(ID_SCALE_US,   false);
	  scale_menu->setItemChecked(ID_SCALE_USA,  false);
	  scale_menu->setItemChecked(ID_SCALE_GE,   true );
	  scale_menu->setItemChecked(ID_SCALE_GEA,  false);
}


void KGuituneApp::slotScaleGEAlt()
{
    view->setScaleGEAlt();
	  scale_menu->setItemChecked(ID_SCALE_US,   false);
	  scale_menu->setItemChecked(ID_SCALE_USA,  false);
	  scale_menu->setItemChecked(ID_SCALE_GE,   false);
	  scale_menu->setItemChecked(ID_SCALE_GEA,  true );
}



void KGuituneApp::slotOptionsSound()
{
    if (!fork()) {
			execlp("kmix","kmix",NULL);
			exit(0);
    }
}


void KGuituneApp::slotOptionsRunMixer()
{
    if (!fork()) {
			execlp("kmix","kmix",NULL);
			exit(0);
    }
}


void KGuituneApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
	if( view_menu->isItemChecked(ID_VIEW_TOOLBAR))
	  view_menu->setItemChecked(ID_VIEW_TOOLBAR, false);
	else
		view_menu->setItemChecked(ID_VIEW_TOOLBAR, true);
		
  enableToolBar();

  slotStatusMsg(i18n("Ready."));
}

void KGuituneApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
	if( view_menu->isItemChecked(ID_VIEW_STATUSBAR))
	  view_menu->setItemChecked(ID_VIEW_STATUSBAR, false);
	else
		view_menu->setItemChecked(ID_VIEW_STATUSBAR, true);

  enableStatusBar();

  slotStatusMsg(i18n("Ready."));
}


void KGuituneApp::slotViewOSZI()
{
  ///////////////////////////////////////////////////////////////////
  //turn OSZI on or off
	if( view_menu->isItemChecked(ID_VIEW_OSZI)){
	  view_menu->setItemChecked(ID_VIEW_OSZI, false);
    view->hideOszi();
    view->update();
 	}else{
		view_menu->setItemChecked(ID_VIEW_OSZI, true);
    view->showOszi();
    view->update();
  }

  slotStatusMsg(i18n("Ready."));
}


void KGuituneApp::slotViewNoteScale()
{
  ///////////////////////////////////////////////////////////////////
  //turn Note Scale on or off
	if( view_menu->isItemChecked(ID_VIEW_NOTESCALE)){
	  view_menu->setItemChecked(ID_VIEW_NOTESCALE, false);
    view->hideLogView();
    view->update();
 	}else{
		view_menu->setItemChecked(ID_VIEW_NOTESCALE, true);
    view->showLogView();
    view->update();
  }

  slotStatusMsg(i18n("Ready."));
}


void KGuituneApp::slotStatusSF()
{
  char text[80];
  int val;
  val=(int)view->sampfreq_exact;
//  statusBar()->clear();
  sprintf(text,"SF:%5d",val);
  statusBar()->changeItem(text, ID_STATUS_SF );
}


void KGuituneApp::slotStatusSN()
{
  char text[80];
  int val;
  val=view->sampnr;
//  statusBar()->clear();
  sprintf(text,"SN:%5d",val);
  statusBar()->changeItem(text, ID_STATUS_SN );
}


void KGuituneApp::slotStatusTR()
{
  char text[80];
  double val;
  val=view->getTrigger();
//  statusBar()->clear();
  sprintf(text,"TR:%.2f",val);
  statusBar()->changeItem(text, ID_STATUS_TR );
}


void KGuituneApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}


void KGuituneApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}



void KGuituneApp::commandCallback(int id_){
  switch (id_){

    case ID_FILE_QUIT:
    	slotFileQuit();
    	break;
   
    case ID_TUNING_NORM:
    	slotTuningNorm();
    	break;
    case ID_TUNING_WIEN:
    	slotTuningWien();
    	break;
    case ID_TUNING_PHYS:
    	slotTuningPhys();
    	break;
    case ID_TUNING_EQUI:
    	slotTuningEqui();
    	break;
    case ID_TUNING_NAT:
    	slotTuningNat();
    	break;

    case ID_SCALE_US:
    	slotScaleUS();
    	break;
    case ID_SCALE_USA:
    	slotScaleUSAlt();
    	break;
    case ID_SCALE_GE:
    	slotScaleGE();
    	break;
    case ID_SCALE_GEA:
    	slotScaleGEAlt();
    	break;

    case ID_OPTIONS_TRIGGER:
//    	slotOptionsTrigger();
    	break;
    case ID_OPTIONS_SAMPLENR:
//    	slotOptionsSampleNr();
    	break;
    case ID_OPTIONS_SAMPLEFREQ:
//    	slotOptionsSampleFreq();
    	break;
    case ID_OPTIONS_SOUND:
    	slotOptionsSound();
    	break;
    case ID_OPTIONS_RUNMIXER:
    	slotOptionsRunMixer();
    	break;

    case ID_VIEW_TOOLBAR:
    	slotViewToolBar();
    	break;
    case ID_VIEW_STATUSBAR:
    	slotViewStatusBar();
    	break;
    case ID_VIEW_OSZI:
    	slotViewOSZI();
    	break;
    case ID_VIEW_NOTESCALE:
    	slotViewNoteScale();
    	break;

    default:
    	break;
  }
}

void KGuituneApp::statusCallback(int id_){
  switch (id_){

    case ID_FILE_QUIT:{
    	QString caption=kapp->getCaption();
    	slotStatusHelpMsg(i18n("Exits "+ caption));
    	break;
    }

    case ID_TUNING_NORM:
    	slotStatusHelpMsg(i18n("Normal tuning (A=440Hz)"));
    	break;
    case ID_TUNING_WIEN:
    	slotStatusHelpMsg(i18n("Wien tuning (A=435Hz)"));
    	break;
    case ID_TUNING_PHYS:
    	slotStatusHelpMsg(i18n("Physical tuning (C=16Hz)"));
    	break;
    case ID_TUNING_EQUI:
    	slotStatusHelpMsg(i18n("Equidistant tuning halftone=2^(1/12)"));
    	break;
    case ID_TUNING_NAT:
    	slotStatusHelpMsg(i18n("Natural tuning by overtones"));
    	break;

    case ID_OPTIONS_TRIGGER:
    	slotStatusHelpMsg(i18n("Set the trigger levels for tuning"));
    	break;
    case ID_OPTIONS_SAMPLENR:
    	slotStatusHelpMsg(i18n("Set the number of samples"));
    	break;
    case ID_OPTIONS_SAMPLEFREQ:
    	slotStatusHelpMsg(i18n("Set the sample frequency"));
    	break;
    case ID_OPTIONS_SOUND:
    	slotStatusHelpMsg(i18n("Set Sound Options (samples, sample freq., ...)"));
    	break;
    case ID_OPTIONS_RUNMIXER:
    	slotStatusHelpMsg(i18n("Run the KDE-Mixer \"kmix\""));
    	break;

    case ID_VIEW_TOOLBAR:
    	slotStatusHelpMsg(i18n("Enables / disables the actual Toolbar"));
    	break;
    case ID_VIEW_STATUSBAR:
    	slotStatusHelpMsg(i18n("Enables / disables the actual Statusbar"));
    	break;
    case ID_VIEW_OSZI:
    	slotStatusHelpMsg(i18n("Enables / disables the OSZI-View"));
    	break;
    case ID_VIEW_NOTESCALE:
    	slotStatusHelpMsg(i18n("Enables / disables the Note-Scale"));
    	break;

		default:
			break;

  }
}






























































































