/* Der erste Versuch einer Radio Applikation mit Klassen */
/* November 98 Carsten					 */

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>

#include <asm/types.h>
#include <linux/videodev.h>

#include <iostream.h>   // Fr i und ostreams
#include <assert.h>

#include "radioctrl.h"

// So nun mssen wir die Funktionen von Radio noch mit Leben erfllen

Radio::Radio(double freq, int vol, const char *Device)  {
	fd=open(Device, O_RDWR);
	if ( fd < 0 ) {
		fd = -errno;
		return;
	}
	Status=true;
	// Initialisieren des Radios
	setFrequenz(freq);
	ioctl(fd, VIDIOCGAUDIO, &hw_audio);
	hw_audio.flags &= VIDEO_AUDIO_MUTE;
	ioctl(fd, VIDIOCSAUDIO, &hw_audio);
	setVolume(vol);
}

void Radio::setVolume(int vol) {
	
	assert ((vol >= 0) && (vol < 256) ); 
	assert (fd > 0);

	hw_audio.volume=65535-(vol*256);

	ioctl(fd, VIDIOCSAUDIO, &hw_audio);
	return;
}

void Radio::setFrequenz(double freq) {
	
	Frequenz = freq;
	assert ( fd > 0 );
	assert ( (Frequenz >= 87.5) && (Frequenz <= 108.0));

	int ifreq = (int) (((Frequenz * 1000 )+32) * 16) /1000;
	
#ifndef NDEBUG
	cout << "Neue Frequenz:" << Frequenz << "\n" ;
#endif
	ioctl(fd, VIDIOCSFREQ, &ifreq); 
	return;
}

// Radio einschalten, i.e. Gertedatei ffnen

int Radio::on(const char *Device) {
	// Luft schon, kein Fehler
	if ( fd > 0 )
		return 0;

	assert(Device);
	// Luft nicht mehr, wieder einschalten
	fd=open(Device, O_RDWR);
	if ( fd < 0 ) {
		fd = -errno;

		cerr << "Error on open radio: "
		     << sys_errlist[errno] << "\n";
		return -errno;
	}
	// Initialisieren des Radios
	setFrequenz(Frequenz);
	ioctl(fd, VIDIOCGAUDIO, &hw_audio);
	setVolume(hw_audio.volume);
	return 0;
}

// Radio ausschalten, einfach Gertedatei schliessen

void Radio::off(void) {
	Status=false;
	close(fd);
	return;
}	


double Radio::getFrequenz(void) {
	return Frequenz;

}

int Radio::getVolume(void) {
	int volume;
	volume = (65535-hw_audio.volume)*256;

	return volume;
}
