/***************************************************************************
                          kblade.h  -  description                              
                             -------------------                                         
    begin                : mer avr 14 20:46:47 CEST 1999
                                           
    copyright            : (C) 1999 by ROLLY Arnaud                         
    email                : rolly@technologist.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KBLADE_H
#define KBLADE_H

#include "errorshow.h"

#include <kapp.h>

#include <qcheckbox.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qwidget.h>

class KBlade : public QWidget {
  Q_OBJECT 
public: 
  /** construtor */
  KBlade(QWidget*parent=0,const char* name=0); 
  /** destructor */
  ~KBlade();
  bool getRecursiveSearch() const;
	const char *getCmdLineBitrate() const;
	const bool getCmdLineCrc() const;
	const bool getCmdLinePrivate() const;
	const bool getCmdLineCopyright() const;
	const bool getCmdLineOriginal() const;
	const bool getCmdLineDelete() const;
	const bool getCmdLineMono() const;
	
	void addError(const char *errorMsg);
	int countErrors();
	
	int countFiles();
	QString getFile(int index);
	void delFile(int index);
	
private:
	QListBox *bitrate, *mp3Files;
	QRadioButton *highest, *higher, *normal, *lower, *lowest, *idle, *original, *copy;
	QCheckBox *crc, *priv, *copyright, *del, *mono, *recursive;
	QPushButton *encode, *quit;
	QWidget *container;
	ErrorShow *errorShow;
	
protected slots:
	void slotInput();
	void slotNewMp3(const char *);
	void slotUnselectAll();
	void slotSelectAll();
	void slotRemoveSelected();
public slots:
	void slotEncode();
};
#endif






































