    /*

    Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de
                       Juhana Sadeharju
                       kouhia at nic.funet.fi

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "synthmodule.h"
extern "C" {
#include "music.h"
}

class Synth_SHELVE_CUTOFF :public SynthModule
{
protected:
	// inputs:
	enum { INVALUE, FREQUENCY };

	// outputs:
	enum { OUTVALUE };

	filter f;

public:
	void Initialize();
	void Calculate() { /* don't have that */ };
	void CalculateBlock(unsigned long samples);
	string getParams() { return("invalue,frequency;outvalue"); }
	static void *Creator() { return new Synth_SHELVE_CUTOFF; };
};

ModuleClient MC_Synth_SHELVE_CUTOFF(SynthModule::get_MS,"Synth_SHELVE_CUTOFF",
												Synth_SHELVE_CUTOFF::Creator);

void Synth_SHELVE_CUTOFF::Initialize()
{
	initfilter(&f);
	haveCalculateBlock = true;
}

void Synth_SHELVE_CUTOFF::CalculateBlock(unsigned long samples)
{
	float *outsig = out[OUTVALUE],*insig = in[INVALUE],*outend=outsig+samples;
	float filterfrequency = *in[FREQUENCY];

	// the shelve-lowpass-filter is extremely sensitive to frequencies which
	// are out of it's range (it produces NaN's then) so we'll be careful ;)
	if(filterfrequency > 22000.0) filterfrequency = 22000.0;
	if(filterfrequency < 1.0) filterfrequency = 1.0;
	setfilter_shelvelowpass(&f,filterfrequency,80.0);

	while(outsig < outend)
	{
		// better paste applyfilter here instead of:
		// *outsig++ = 0.95 * applyfilter(&f,*insig++);
  		f.x = *insig++;
  		f.y = f.cx * f.x + f.cx1 * f.x1 + f.cx2 * f.x2
    		+ f.cy1 * f.y1 + f.cy2 * f.y2;
  		f.x2 = f.x1;
  		f.x1 = f.x;
  		f.y2 = f.y1;
  		f.y1 = f.y;
  		*outsig++ = 0.95 * f.y;
	}
}
