#include <list>
#include <string>
#include <map>
#include <stdio.h>

string midiparams[128];

long readRoot(string sample)
{
	FILE *infile = fopen(sample.c_str(),"r");
	if(!infile)
	{
		fprintf(stderr,"Can't open sample %s\n",sample.c_str());
		exit(1);
	}
	if(fgetc(infile) != 3) {
		fprintf(stderr,"warning: sample %s doesn't seem to be in akai format\n",sample.c_str());
	}
	fgetc(infile);

	long root = fgetc(infile);
	fclose(infile);

	return root;
}

void takeSamples(string param,list<string> samples)
{
	map<string,long> midiRoot;

	// read midi root notes of the samples
	list<string>::iterator i;
	for(i=samples.begin();i!=samples.end();i++)
		midiRoot[*i] = readRoot(*i);

	int note;
	for(note=0;note<128;note++)
	{
		long mindist = 129,dist;
		string bestsample;

		for(i=samples.begin();i!=samples.end();i++)
		{
			dist = abs(midiRoot[*i]-note);
			if(dist<mindist)
			{
				mindist = dist;
				bestsample = *i;
			}
		}
		midiparams[note] += param+"="+bestsample+"\n";
	}
}

/*
 * akaikggen left = sample1l sample2l sample3l sample4l right = sample1r sample2r sample3r sample4r
 */
int main(int argc, char **argv)
{
	int i;
	bool take = false;
	list<string> samples;

	for(i=argc-1;i>0;i--)
	{
		if(take)
		{
			if(!samples.size())
			{
				fprintf(stderr,"empty group %s\n",argv[i]);
				exit(1);
			}
			else
			{
				takeSamples(string(argv[i]),samples);
			}
			samples.clear();
			take = false;
		}
		else
		{
			if(strcmp(argv[i],"=") == 0)
				take = true;
			else
				samples.push_back(argv[i]);
		}
	}

	if(take || samples.size())
	{
		fprintf(stderr,"usage: akaikggen <group_a> = <sample1> <sample2> <sample3>"
		                               " <group_b> = <sample1> <sample2> <sample3> ...\n");
		exit(1);
	}

	int note,start=0;
	string last = midiparams[0];
	for(note=1;note<128;note++)
	{
		if(midiparams[note] != last)
		{
			last = midiparams[note];
			printf("keygroup=%d-%d\n{\n%s}\n",start,note-1,midiparams[start].c_str());
			start = note;
		}
	}
	printf("keygroup=%d-%d\n{\n%s}\n",start,127,midiparams[start].c_str());
}
