    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#ifndef _GUIMODULE_H
#define _GUIMODULE_H

#include "arts.h"
#include "moduleserver.h"
#include "qwidget.h"
#include "qlayout.h"
#include <utility>
#include <list>

class QWidgetWatcher;
class GUIServer_impl;

class GuiModule : public ModuleServerModule
{
protected:
	int _parentType; // parentNone, parentLocal, parentGlobal

	long restoreID;
	long _MID, _ParentWidgetID, _ID, _ParentWidgetGlobalID, _GlobalID;
	Arts::Synthesizer_var Synthesizer;
	GUIServer_impl *GUIServer;

	list<pair<long,Arts::Receiver *> > receivers;

	void addPort(Arts::ModuleInfo &info, const char *name,
    	 Arts::PortDirection dir, Arts::PortDataType datatype,
     	 Arts::PortConnType conntype);

	bool setupParent(Arts::ModuleDesc *desc, const char *name);
	float getFloatParam(Arts::ModuleDesc *desc, const char *name);
	string getStringParam(Arts::ModuleDesc *desc, const char *name);
	long lookupPort(Arts::ModuleDesc *desc, const char *name);
	Arts::PortDesc *findPortParam(Arts::PortDescSeq *pds, const char *name,
										Arts::PortDataType dt);

	void emitSignal(long portid, float value);

	void getPosition(Arts::ModuleDesc *desc, int& x, int& y);
	void getSize(Arts::ModuleDesc *desc, int& width, int& height);

	list<QWidgetWatcher *> widgetWatchers;
	void watchWidget(QWidget *widget);
public:
	void initialize(Arts::Synthesizer *Synthesizer, GUIServer_impl *GUIServer);
	// reoccuring timer tick
	virtual void tick();
	virtual void publish(Arts::ArtsServer *Server,Arts::ModuleBroker *Broker)=0;
	virtual void applyParameters(Arts::ModuleDesc *desc) = 0;
	virtual void start() = 0;
	virtual void setParent(QWidget *widget, QBoxLayout *layout) = 0;
	virtual void widgetDestroyed(QWidget *widget);

	virtual Arts::StringSeq *saveSessionParameters(list<long>& IDs);
	virtual void restoreSessionParameters(const Arts::StringSeq& params);
	void setRestoreID(long restoreID);

	GuiModule();
	virtual ~GuiModule();

	// if this returns a widget, this module can be parent widget for other
	// modules
	virtual QWidget *isParent();
	virtual QBoxLayout *parentLayout();

	virtual void finalize();

	long MID();
	void setMID(long newmid);

	long ID();
	void setID(long newid);

	long globalID();
	void setGlobalID(long newid);

	long parentWidgetID();
	long parentWidgetGlobalID();

	enum { parentNone, parentLocal, parentGlobal };
	int parentType();

	void assignReceiver(long portid, Arts::Receiver *receiver);

//--- module server support ---
	static void *get_MS();
};

class QWidgetWatcher :public QObject {
	Q_OBJECT
	GuiModule *guimodule;
	QWidget *widget;
public:
	QWidgetWatcher(GuiModule *gm, QWidget *qw);
public slots:
	void widgetDestroyed();
};

#endif
