    /*

    Copyright (C) 1999 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "guimodule.h"

GuiModule::GuiModule()
{
	_ParentWidgetID = 0;
	_ParentWidgetGlobalID = 0;
	_parentType = parentNone;
}

GuiModule::~GuiModule()
{
	// --- free widget watchers
	list<QWidgetWatcher *>::iterator i;

	for(i=widgetWatchers.begin();i!=widgetWatchers.end();i++)
		delete (*i);

	// --- release receivers
	list<pair<long,Arts::Receiver *> >::iterator ri;

	for(ri=receivers.begin();ri != receivers.end();ri++)
	{
		pair<long,Arts::Receiver *> p = *ri;
		p.second->decRef();
		CORBA::release(p.second);
	}
}

void GuiModule::watchWidget(QWidget *widget)
{
	widgetWatchers.push_back(new QWidgetWatcher(this,widget));
}

void GuiModule::widgetDestroyed(QWidget *widget)
{
	// if you want to watch widgets, then you need to override this
	// function as well
	assert(0);
}

int GuiModule::parentType()
{
	return _parentType;
}

void GuiModule::initialize(Arts::Synthesizer *Synthesizer,
												GUIServer_impl *GUIServer)
{
	this->Synthesizer = Arts::Synthesizer::_duplicate(Synthesizer);
	this->GUIServer = GUIServer;
}

void GuiModule::finalize()
{
	// override this when necessary
}

QWidget *GuiModule::isParent()
{
	return 0;
}

QBoxLayout *GuiModule::parentLayout()
{
	return 0;
}

long GuiModule::parentWidgetID()
{
	return _ParentWidgetID;
}

long GuiModule::parentWidgetGlobalID()
{
	return _ParentWidgetGlobalID;
}

void GuiModule::setMID(long newmid)
{
	_MID = newmid;
}

long GuiModule::MID()
{
	return _MID;
}

void GuiModule::setID(long newid)
{
	_ID = newid;
}

long GuiModule::ID()
{
	return _ID;
}

void GuiModule::setGlobalID(long newid)
{
	_GlobalID = newid;
}

long GuiModule::globalID()
{
	return _GlobalID;
}

void *GuiModule::get_MS()
{
    static ModuleServer<GuiModule> *MS = 0;

    if(!MS) MS = new ModuleServer<GuiModule>;
    return(MS);
}

void GuiModule::assignReceiver(long portid, Arts::Receiver *receiver)
{
	pair<long,Arts::Receiver *> p(portid,Arts::Receiver::_duplicate(receiver));
	receivers.push_back(p);
	receiver->incRef();
}

void GuiModule::emitSignal(long portid, float value)
{
	list<pair<long,Arts::Receiver *> >::iterator ri;

	for(ri=receivers.begin();ri != receivers.end();ri++)
	{
		pair<long,Arts::Receiver *> p = *ri;
		if(p.first == portid)
			p.second->newFloatValue(value);
	}
}

void GuiModule::addPort(Arts::ModuleInfo &info, const char *name,
     Arts::PortDirection dir, Arts::PortDataType datatype,
     Arts::PortConnType conntype)
{
	unsigned long len;

	len = info.ports.length();
	info.ports.length(len+1);

	info.ports[len].Direction = dir;
	info.ports[len].DataType = datatype;
	info.ports[len].ConnType = conntype;

	len = info.portnames.length();
	info.portnames.length(len+1);
	info.portnames[len] = CORBA::string_dup(name);
}

float GuiModule::getFloatParam(Arts::ModuleDesc *desc, const char *name)
{
	Arts::PortDesc_var pd = desc->findPort(name);

	if(pd && pd->hasValue()) return(pd->FloatValue());
	printf("port %s has no value\n",name);
	return(0.0);
}

// This will return the ID of the _module_ this connection points to
// (not of the port) ... used for parent widget stuff
bool GuiModule::setupParent(Arts::ModuleDesc *desc, const char *name)
{
	Arts::PortDesc_var pd = desc->findPort(name);

	if(pd && pd->isConnected())
	{
		Arts::PortDescSeq_var conns = pd->Connections();
		assert(conns->length() == 1);
		Arts::PortDesc *pd2 = (*conns)[0];
		Arts::ModuleDesc_var pmd = pd2->Parent();

		// parent is directly connected
		_ParentWidgetID = pmd->ID();
		_parentType = parentLocal;
		printf("!! setting parent to %ld\n",_ParentWidgetID);
		return true;
	}
	if(pd && pd->hasValue())
	{
		// we've got the ID of the parent as global number

		_ParentWidgetGlobalID = (long)(pd->FloatValue()+0.5);
		_parentType = parentGlobal;
		return true;
	}
	return false;
}

void GuiModule::getPosition(Arts::ModuleDesc *desc, int& x, int& y)
{
	x = (int)(getFloatParam(desc,"x")*10);
	y = (int)(getFloatParam(desc,"y")*10);
}

void GuiModule::getSize(Arts::ModuleDesc *desc, int& width, int& height)
{
	width = (int)(getFloatParam(desc,"width")*10);
	height = (int)(getFloatParam(desc,"height")*10);
}

string GuiModule::getStringParam(Arts::ModuleDesc *desc, const char *name)
{
	Arts::PortDesc_var pd = desc->findPort(name);
	
	if(pd && pd->hasValue()) return(string(pd->StringValue()));
	return(string(""));
}

long GuiModule::lookupPort(Arts::ModuleDesc *desc, const char *name)
{
	Arts::PortDesc_var pd = desc->findPort(name);
	
	if(pd) return(pd->ID());
	return(0);
}

void GuiModule::tick()
{
}

Arts::StringSeq *GuiModule::saveSessionParameters(list<long>& IDs)
{
	// default: no parameters to save
	return new Arts::StringSeq;
}

void GuiModule::restoreSessionParameters(const Arts::StringSeq& params)
{
	// default: no parameters to restore
}

void GuiModule::setRestoreID(long restoreID)
{
	this->restoreID = restoreID;
}

QWidgetWatcher::QWidgetWatcher(GuiModule *gm, QWidget *qw)
{
	connect(qw, SIGNAL(destroyed()), this, SLOT(widgetDestroyed()));
	widget = qw;
	guimodule = gm;
}

void QWidgetWatcher::widgetDestroyed()
{
	guimodule->widgetDestroyed(widget);
}
