#ifndef _QTSAMPLE_H_
#define _QTSAMPLE_H_

#include "qtEditor.h"
#include "kbPosition.h"

class KbNote;
class KbPart;

/**
 * Qt implementation of a sample editor
 * copy these files (qtSampleEditor.h and qtSampleEditor.C)
 * and adjust the things (like the defines _QTSAMPLE_H_, ..., the
 * includes (dont forget the moc-file), adjust the Makefile...)
 * if unsure, see the Manual 
 * @author ?
 * @version ?
 */
class QtSampleEditor : public QtEditor
{
  Q_OBJECT

 private:

  // used for the range (in ticks) that is to be displayed
  int xLeft;
  int xRight;

  // ticks per bar
  int ticksPerBar;

  // used for a notes information in paintEvent
  KbNote * next;
  int freq;
  KbPosition pos;
  int len;

  // coordinates, used at several places...
  int xx;
  int yy;
  int xxLen;

  char barText[5];

 public:

  /**
   * constructor, takes the part to be displayed as a parameter
   */
  QtSampleEditor(KbPart * kbpart);

 public slots:
  
  /// do all the painting here
  void paintEvent ( QPaintEvent * );

  /// mouse is pressed here
  void mousePressEvent ( QMouseEvent * );

  /// mouse is moved
  void mouseMoveEvent ( QMouseEvent * );

  /// mouse is released
  void mouseReleaseEvent ( QMouseEvent * );

  /// a key is pressed
  void keyPressEvent ( QKeyEvent * );

  /// a key is released
  void keyReleaseEvent ( QKeyEvent * );

};

#endif
