#ifndef _QTPART_H_
#define _QTPART_H_

#include "qtMain.h"
#include "ifPart.h"

class KbPart;
class QtPartCanvas;
class QtMain;
class KbNote;

/**
 * This qt class presents parts
 * @short qt part class
 * @author Jan Wuerthner
 * @version 0.95
 */
class QtPart : public QLabel, public IfPart
{
  Q_OBJECT
 private:
  KbPart * part;
  QtPartCanvas * pcanvas;
  QtMain * qtmain;
  
  QButton * instName;
  QPopupMenu * instPM;
  QPopupMenu * instPMs[16];
  QPopupMenu * userDef;
  int local_x;
  int splitPoint;
  int dx;
  bool open;
  QPopupMenu * rbmenu;
  
 public:
  QtPart(KbPart * kbpart);
  ~QtPart();
  void erase();

  KbPart * gPart();
  void sPart(KbPart * p);
  KbPart * gNext();
  void sNext(KbPart * p);

 public slots:
  void instMenu(int);
  void userDefMenu(int);
  void scoreEdit();
  void drumEdit();
  void eventEdit();
  void pianoRollEdit();
  void eventTimeEdit();
  void commentEdit();
  void waveEdit();
  void closeEditor();
  void deletePart();
  void testPart();
  void partCopy();
  void partGlue();
  void partSplit();
  void partq();
  void partql();
  void partfl();
  void mousePressEvent ( QMouseEvent * );
  void mouseMoveEvent ( QMouseEvent * );
  void mouseReleaseEvent ( QMouseEvent * );
  void paintEvent( QPaintEvent * );
};

#endif
