
#define META_EVENT 0xFF
 
#define ME_TRACK_SEQ_NUMBER     0x00
#define ME_TEXT                 0x01
#define ME_COPYRIGHT            0x02
#define ME_SEQ_OR_TRACK_NAME    0x03
#define ME_TRACK_INSTR_NAME     0x04
#define ME_LYRIC                0x05
#define ME_MARKER               0x06
#define ME_CUE_POINT            0x07
#define ME_CHANNEL_PREFIX       0x20
#define ME_MIDI_PORT            0x21
#define ME_SET_TEMPO            0x51
#define ME_SMPTE_OFFSET         0x54
#define ME_TIME_SIGNATURE       0x58
#define ME_KEY_SIGNATURE        0x59
#define ME_END_OF_TRACK 0x2F                                      


#include "defs.h"
#include "kbTrack.h"
#include "kbLyrics.h"
#include <stdio.h>
#include "math.h"

#define T2MS(ticks) (((double)ticks)*(double)60000L)/((double)tempoToMetronomeTempo(tempo)*(double)tPCN)
#define MS2T(ms) (((ms)*(double)tempoToMetronomeTempo(tempo)*(double)tPCN)/((double)60000L))

int readPart(FILE*,KbPart*,int,int,char*&);
unsigned long readValue(unsigned char *&, unsigned long &);

double tempoToMetronomeTempo(unsigned long x) { return 60/((double)x/1000000); }

double metronomeTempoToTempo(unsigned long x) { return ((double)60*x)/1000000; }

void KbMain::getMidi(char * name) {

  KbTrack * kbtrack;
  KbPart  * kbPart = 0;

  int ok=1;

  FILE *fh=fopen(name,"r");
  if (fh==NULL) {
    printf("ERROR: Can't open file %s\n",name);
    ok=-1;
    return NULL;
  }

  char text[4];
  fread(text,1,4,fh);
  
  if (strncmp(text,"MThd",4)!=0) {
    fseek(fh,0,SEEK_SET);
    long pos;
    fseek(fh,pos,SEEK_SET);
    fread(text,1,4,fh);
  }
  long header_size=readLong(fh);
  fileInfo->format=readShort(fh);
  fileInfo->ntracks=readShort(fh);
  fileInfo->ticksPerCuarterNote=readShort(fh);
  if (fileInfo->ticksPerCuarterNote<0) {
    printf("ERROR: Ticks per cuarter note is negative !\n");
    fclose(fh);
    ok=-3;
    return NULL;
  }
  if (header_size>6) fseek(fh,header_size-6,SEEK_CUR);
  
  int i=0;
  while (i<fileInfo->ntracks) {
    fread(text,1,4,fh);
    if (strncmp(text,"MTrk",4)!=0) {
      printf("ERROR: Not a well built midi file\n");
      printf("%s",text);
      fclose(fh);
      ok=-5;
      return NULL;
    }
    // kbtrack = addTrack(0);
    kbPart = new KbPart(0);
    char * trName = 0;
    int trackType = readPart(fh,kbPart,fileInfo->ticksPerCuarterNote,i,trName);
    // cout << "tt: " << trackType << endl;
    switch (trackType) {
    case 0: kbtrack = addTrack(0); kbtrack->setPart(kbPart); kbtrack->sName(trName);
            ((KbScoreTrack*)kbtrack)->sProgram(kbPart->gProgram()); break;
    case 1: kbtrack = addTrack(1); kbtrack->setPart(kbPart); kbtrack->sName(trName);
            ((KbDrumTrack*)kbtrack)->sProgram(kbPart->gProgram()); break;
    case 2: kbtrack = addTrack(2); kbtrack->setPart(kbPart); kbtrack->sName(trName); break;
    case 3: kbtrack = addTrack(3); kbtrack->setPart(kbPart); kbtrack->sName(trName); break;
    case 4: kbtrack = addTrack(4); kbtrack->setPart(kbPart); kbtrack->sName(trName); break;
    default: printf("PANIC trackType=-1\n"); break;
    }
    i++;
  }
  
  fclose(fh);
  
  //adjustRightBorder();
  gInterface()->update();
}



#define X(s) cout << s << endl;


void addLyricsElement(KbPosition pos, char * ptr, int len, KbPart * part) {
  char * lyr = new char[len+1];
  snprintf(lyr,len,ptr);
  lyr[len]=0;
  // if (len>0) part->addAtom(new KbLyrics(pos,lyr)); // DOIT!
}



int readPart(FILE * file, KbPart * part, int tpcn, int Id, char *& trName) {
  int trackType = -1;
  unsigned long size = readLong(file);
  unsigned char * data=(uchar *)malloc(size);
  if (data==NULL) exit(-1);
  if (fread(data,1,size,file)!=size)  printf("File is corrupt : Couldn't load track !!\n");

  int endoftrack = 0;
  unsigned char * ptrdata = data;
  unsigned long current_ticks = 0;
  unsigned long currentpos = 0;
  unsigned long time_at_next_event = 0;
  unsigned long time_at_previous_tempochange = 0;

  /*
  unsigned long delta_ticks = readValue(ptrdata, currentpos);
  if (endoftrack) return;
  unsigned long wait_ticks = delta_ticks;
  
  time_at_previous_tempochange=0;
  current_time=0;
  ticks_from_previous_tempochange=wait_ticks;
  tempo=1000000;
  time_at_next_event=T2MS(delta_ticks);
  */
  
  unsigned long delta_ticks = 0;
  unsigned long wait_ticks = 0;
  
  // loop:
  delta_ticks = readValue(ptrdata, currentpos);
  wait_ticks = delta_ticks;

#define MAXSUS 512
  KbNote* sus[MAXSUS];
  int susp=0;
  unsigned char lastcommand = 0;
  unsigned char command = (*ptrdata);
  unsigned char note = 0;
  unsigned char vel  = 0;
  unsigned char patch= 0;
  unsigned char d1 = 0;
  unsigned char d2 = 0;
  unsigned char d3 = 0;
  unsigned char d4 = 0;
  unsigned char d5 = 0;
  unsigned char ctl = 0;
  unsigned char * evdata = 0;
  unsigned long length = 0;
  
  while (!endoftrack) {

    int i,j;
    if (endoftrack==1) {
      return;
    }
    

    if (((*ptrdata)&0x80)!=0) {
      command = (*ptrdata);
      lastcommand = command;
      ptrdata++;currentpos++;
    } else {
      command = lastcommand;
    }
    
    unsigned char channel = command & 0xF;
    command = command & 0xF0;
    int makeNote = -1;
    int makeEvent = -1;
    int newTempo = 0;
    unsigned char c1 = *ptrdata;
    switch (command) {
    case (MIDI_NOTEON) :
      note = *ptrdata;ptrdata++;currentpos++;
      vel  = *ptrdata;ptrdata++;currentpos++;
      makeNote = 1;
      if (vel==0) makeNote = 0;
      trackType = 0; // score
      break;
    case (MIDI_NOTEOFF) :
      note = *ptrdata;ptrdata++;currentpos++; 
      vel  = *ptrdata;ptrdata++;currentpos++;
      makeNote = 0;
      break;
    case (MIDI_KEY_PRESSURE) :
      note = *ptrdata;ptrdata++;currentpos++; 
      vel  = *ptrdata;ptrdata++;currentpos++;
      makeEvent=1;
      break;
    case (MIDI_PGM_CHANGE) :
      patch = *ptrdata;ptrdata++;currentpos++; 
      makeEvent=2;
      break;
    case (MIDI_CHN_PRESSURE) :
      vel  = *ptrdata;ptrdata++;currentpos++;
      makeEvent=3;
      break;
    case (MIDI_PITCH_BEND) :
      d1 = *ptrdata;ptrdata++;currentpos++; 
      d2 = *ptrdata;ptrdata++;currentpos++;
      makeEvent=4;
      break;
    case (MIDI_CTL_CHANGE) :
      ctl = *ptrdata;ptrdata++; currentpos++;
      d1  = *ptrdata;ptrdata++;currentpos++;
      makeEvent=5;
      /*
	switch (ev->ctl)
	{
	case (96) : printf("RPN Increment\n");break;
	case (97) : printf("RPN Decrement\n");break;
	case (98) : printf("nRPN 98 %d\n",ev->d1);break;
	case (99) : printf("nRPN 99 %d\n",ev->d1);break;
	case (100) : printf("RPN 100 %d\n",ev->d1);break;
	case (101) : printf("RPN 101 %d\n",ev->d1);break;
	};
      */
      break;
    case (MIDI_SYSTEM_PREFIX) :
      switch ((command|channel)) {
      case (0xF0) : 
      case (0xF7) :
	length=readValue(ptrdata, currentpos);
	evdata=ptrdata;
	ptrdata+=length;currentpos+=length;
	break;
      case (0xFE):
      case (0xF8):
	//		printf("Active sensing\n");
	break;
      case (META_EVENT) : 
	d1=*ptrdata;ptrdata++;currentpos++;
	switch (d1) {
	case (ME_END_OF_TRACK) :
	  printf("EOT\n");
	  i=0;
	  j=0;
	  endoftrack=1;
	  delta_ticks = wait_ticks = ~0;
	  time_at_next_event=10000 * 60000L;
	  break;
	case (ME_SET_TEMPO):
	  length=readValue(ptrdata, currentpos);
	  evdata=ptrdata;
	  ptrdata+=length;currentpos+=length;
	  newTempo = tempoToMetronomeTempo((evdata[0]<<16)|(evdata[1]<<8)|(evdata[2]));
	  if (newTempo!=0) part->addAtom(new KbMasterEvent(current_ticks,newTempo));
	  if (trackType==-1) trackType = 2; // master
	  break;
	case (ME_TIME_SIGNATURE) :
	  length=*ptrdata;ptrdata++;currentpos++;
	  d2=*ptrdata;ptrdata++;currentpos++;
	  d3=pow(2,(*ptrdata));ptrdata++;currentpos++;
	  d4=*ptrdata;ptrdata++;currentpos++;
	  d5=*ptrdata;ptrdata++;currentpos++;
	  if ((d2!=0)&&(d2!=0)) part->addAtom(new KbMasterEvent(current_ticks,d2,d3));
	  if (trackType==-1) trackType = 2; // master
	  break;
	case (ME_TRACK_SEQ_NUMBER) :
	  length=readValue(ptrdata, currentpos);
	  evdata=ptrdata;
	  ptrdata+=length;currentpos+=length;
	  break;
	case (ME_TEXT) :
	  length=readValue(ptrdata, currentpos);
	  evdata=ptrdata;
	  ptrdata+=length;currentpos+=length;
	  addLyricsElement(current_ticks,evdata,length,part);
	  break;
	case (ME_COPYRIGHT) :
	  length=readValue(ptrdata, currentpos);
	  evdata=ptrdata;
	  ptrdata+=length;currentpos+=length;
	  break;
	case (ME_SEQ_OR_TRACK_NAME) :
	  length=readValue(ptrdata, currentpos);
	  evdata=ptrdata;
	  ptrdata+=length;currentpos+=length;
 	  trName = new char[length+1];
	  snprintf(trName,length+1,evdata);
	  trName[length+1]=0;
	  printf("%s\n",trName);
	  break;
	case (ME_TRACK_INSTR_NAME) :
	case (ME_LYRIC) :
	case (ME_MARKER) :
	case (ME_CUE_POINT) :
	case (ME_CHANNEL_PREFIX) :
	case (ME_MIDI_PORT) :
	case (ME_SMPTE_OFFSET) :
	case (ME_KEY_SIGNATURE) :
	  length=readValue(ptrdata, currentpos);
	  evdata=ptrdata;
	  ptrdata+=length;currentpos+=length;
	  break;
	default: 
	  length=readValue(ptrdata, currentpos);
	  evdata=ptrdata;
	  ptrdata+=length;currentpos+=length;
	  break;
	  
	}
	break;
      default: 
	printf("Warning: Default handler for system event 0x%x\n",
	       (command|channel));
	break;
      }
      break;
      
    default: 
      printf("Warning: Default handler for event 0x%x - %d\n",
	     (command|channel),endoftrack);
      break;
    }
    if (makeNote==1) { // note on
      KbNote * newNote = new KbNote(note,vel,191,current_ticks,0);
      if (susp<MAXSUS) sus[susp++]=newNote;
      part->addNote(newNote);
    } else if (makeNote==0) { // note off
      int ii=0;
      for (int i=0; i<susp; i++)
	if ((note==sus[i]->gFreq())) {
	  sus[i]->sLen(current_ticks-sus[i]->gPos().gPosTicks());
	  ii=i;
	  i=susp;
	}
      for (int i=ii; i<susp-1; i++) sus[i]=sus[i+1];
      if (susp>0) susp--;
    } 
  
    
    if (endoftrack==0) {
      delta_ticks=readValue(ptrdata,currentpos);
      current_ticks+=delta_ticks;

      // ticks_from_previous_tempochange+=delta_ticks;
      
      //time_at_next_event=T2MS(ticks_from_previous_tempochange)+time_at_previous_tempochange;
      /*
	printf("tane2 : %g, ticks : %g, delta_ticks %ld, tempo : %ld\n",
	time_at_next_event,ticks_from_previous_tempochange,delta_ticks,tempo);
	printf("timeatprevtc %g , curr %g\n",time_at_previous_tempochange,current_time);
      */
      // printf("delta: %d\n",delta_ticks);
      wait_ticks=delta_ticks;
      
    }
    
  }
  if (patch!=0) part->sProgram(patch);
  free(data);
  return trackType;
}

unsigned long readValue(unsigned char * & ptrdata, unsigned long & currentpos) {
  unsigned long dticks=0;
    
  while ((*ptrdata) & 0x80) {
    dticks=(dticks << 7) | (*ptrdata) & 0x7F;
    ptrdata++;currentpos++;
  }
  dticks=((dticks << 7) | (*ptrdata) & 0x7F);
  ptrdata++;currentpos++;
  return dticks;
}




void KbMain::saveMidi(ofstream * outPtr) {
  //cout << "writing MIDI..." << endl;
  ofstream &to = *outPtr;

  int alltracks = 0;
  for (KbTrack * tr=track;tr!=0;tr=tr->gNext()) alltracks++;
  int table[alltracks];
  int dTable[alltracks];

  if (midi->isOpen()) closeDev();
  
  KbMasterTrack * mastertrack = 0;
  KbPart * master = 0;
  KbPosition mOff = 0;

  int stNumber = 0;
  int dtNumber = 0;
  int i = 0;
  for (KbTrack * tr=track;tr!=0;tr=tr->gNext()) {
    table[i] = 0; dTable[i] = 0;
    if (tr->gToggle(0)==false) // not muted
      if (tr->gPart()!=0) {    // does contain at least one part
	if (tr->isA()==0) { table[i] = stNumber; st[stNumber++] = (KbScoreTrack*) tr; }
	if (tr->isA()==1) { dTable[i] = dtNumber; dt[dtNumber++] = (KbDrumTrack*) tr; }
	if ((tr->isA()==2) && (master==0)) mastertrack = (KbMasterTrack*) tr;
      }
    i++;
  }
  if (mastertrack) master = mastertrack->gPart();
  if (master) { master->sCur(master->gFirstMasterEvent()); mOff = master->gOffset(); }

  for (int i=0;i<alltracks;i++) // this establishes a list to transform the
    if (dTable[i]>0)            // track index from the GUI to the index used here
      table[i] += dTable[i]+stNumber; // i.e. tIndex see below!

  int tNum = stNumber+dtNumber;

  int           tProgram[tNum];
  int           tOutput[tNum];
  int           tChannel[tNum];
  int           tVolume[tNum];
  int           tDelay[tNum];
  KbPart *      tPart[tNum];
  KbPosition    pOff[tNum];
  int           tStop[tNum];

  int tIndex = 0;

  for (int i=0;i<stNumber;i++) {
    tProgram[tIndex] = st[i]->gProgram();
    tOutput[tIndex] = st[i]->gOutput();
    tChannel[tIndex] = st[i]->gChannel();
    tVolume[tIndex] = st[i]->gVolume();
    tDelay[tIndex] = st[i]->gDelay();
    tPart[tIndex] = st[i]->gPart();
    pOff[tIndex] = tPart[tIndex]->gOffset(); //1536*tPart[tIndex]->gTime1()/tPart[tIndex]->gTime2()*(tPart[tIndex]->gFrom());
    if (tDelay[tIndex]>0) pOff[tIndex] += tDelay[tIndex];
    tIndex++;
  }
  for (int i=0;i<dtNumber;i++) {
    tProgram[tIndex] = dt[i]->gProgram();
    tOutput[tIndex] = dt[i]->gOutput();
    tChannel[tIndex] = dt[i]->gChannel();
    tVolume[tIndex] = dt[i]->gVolume();
    tDelay[tIndex] = dt[i]->gDelay();
    tPart[tIndex] = dt[i]->gPart();
    pOff[tIndex] = tPart[tIndex]->gOffset(); //1536*tPart[tIndex]->gTime1()/tPart[tIndex]->gTime2()*(tPart[tIndex]->gFrom());
    if (tDelay[tIndex]>0) pOff[tIndex] += tDelay[tIndex];
    tIndex++;
  }

  for (int k=0; k<256; k++) { sus[k]=0; susCh[k]=0; susTr[k]=0; }
  sus[0]=0;
  susp=0;

  long length;
  long trLength;
  int a1;
  int a2;
  int a3;
  int a4;
  int nums=0;
  // KbNote* sus[64];
  // for (int k=0; k<64; k++) { sus[k]=0; }
  int susp;
  int stop;
  int kk;
  int pp;
  int pp1;
  int noteOn;
  int noteOff;
  int prgch;
  int dtime;
  int dtime1[8];
  unsigned char* tr = new unsigned char[500000];
  int dtimeInt=0;

  //ofstream to(fname);
  to << "MThd";
  to.put(0);to.put(0);to.put(0);to.put(6);
  to.put(0);to.put(1);
  for (int i=0; i<tIndex; i++) if (tPart[i]!=0) nums++;
  to.put(0);to.put(nums);
  // ?? to.put(int(tempo/256)); to.put(tempo&255);
  to.put(1); to.put(128);
  //progressbar->setTotalSteps(numScr);

  if (master) { // mastertrack --------------------
    to << "MTrk";
    length = 0;
    dtime = 0;
    pp = 0;
    for (KbMasterEvent * me = (KbMasterEvent*) master->gFirstMasterEvent();me!=0;me=(KbMasterEvent*)me->gNext()) {
      dtime = me->gPos()-pp;
      dtimeInt=0; while (dtime>=0x80) {dtime1[dtimeInt++]=dtime&0x7F; dtime=int(dtime/128);}
      dtime1[dtimeInt++]=dtime; for (int uu=1; uu<dtimeInt; uu++) tr[length++]=dtime1[dtimeInt-uu]+128;
      tr[length++]=dtime1[0];
      tr[length++] = 0xff;
      if (me->gTempo()==0) { // meter
	tr[length++] = 0x58;
	tr[length++] = 0x04;
	tr[length++] = me->gMeter0();
	tr[length++] = (int)((log10(me->gMeter1())/log10(2)));
	tr[length++] = 0x18;
	tr[length++] = 0x08;
      } else { // tempo
	tr[length++] = 0x51;
	tr[length++] = 0x03;
	tr[length++] = 0x07; // DOIT: richtiges Tempo !!
	tr[length++] = 0xa1;
	tr[length++] = 0x20;
      }
      pp = dtime;
    }
  
    trLength=length+4;
    a1=trLength&0x000000FF;
    a2=(trLength&0x0000FF00)/256;
    a3=(trLength&0x00FF0000)/65536;
    a4=(trLength&0xFF000000)/16777216;
    to.put(a4);to.put(a3);to.put(a2);to.put(a1);
  }
  // ----- other tracks:
  //
  for (int i=0; i<tIndex; i++)
    if (tPart[i]!=0) {
      //progressbar->setProgress(i+1);
      to << "MTrk";
      
      // ----------------------------------------
      
    pp=0;
    pp1=0;
    susp=0;
    stop=0;
    noteOn=0x90+i;
    noteOff=0x80+i;
    prgch=0xc0+i;
    tPart[i]->sCur(tPart[i]->gFirstAtom());
    dtime=0;
    for (int uu=0; uu<8; uu++) dtime1[uu]=0;
    length=0;
    while (stop<2) {
      kk=0;
      while (sus[kk]!=0) {
	if (sus[kk]->gPos()+sus[kk]->gLen()<=pp) {
	  dtimeInt=0; while (dtime>=0x80) {dtime1[dtimeInt++]=dtime&0x7F; dtime=int(dtime/128);}
	  dtime1[dtimeInt++]=dtime; for (int uu=1; uu<dtimeInt; uu++) tr[length++]=dtime1[dtimeInt-uu]+128;
	  tr[length++]=dtime1[0];
	  tr[length++]=noteOff; tr[length++]=sus[kk]->gFreq(); tr[length++]=sus[kk]->gVel();
	  dtime=0;
	  for (int k=kk; k<susp+1; k++) sus[k]=sus[k+1];
	  susp--;
	} 
	kk++;
      }
      if (stop<2) 
	if (tPart[i]->gCurAtom() !=0) {
	  while ((tPart[i]->gCurAtom()->gPos() == pp) && (stop<2)) {
	    if (tPart[i]->gCurAtom()->isNote()) { // NOTE EVENT:
	      KbNote * note = (KbNote*) tPart[i]->gCurAtom();
	      dtimeInt=0; while (dtime>=0x80) {dtime1[dtimeInt++]=dtime&0x7F; dtime=int(dtime/128);}
	      dtime1[dtimeInt++]=dtime; for (int uu=1; uu<dtimeInt; uu++) tr[length++]=dtime1[dtimeInt-uu]+128;
	      tr[length++]=dtime1[0];
	      tr[length++]=noteOn; tr[length++]=note->gFreq(); tr[length++]=note->gVel();		  
	      dtime=0;
	      sus[susp++] = note;
	    }
	    if (tPart[i]->gCurAtom()->gNext()==0) { stop=2; } else { tPart[i]->sCur(tPart[i]->gCurAtom()->gNext()); }
	    //      pos[susp++]=t->gCur()->gPos()+p;
	  }
	} else { cout << "PANIC" << endl; stop = 2; }
      if (stop==2) { pp1=pp; pp=-1; }
      pp++;
      dtime++;
      if (pp > 99999999999999999) { stop = 2; } // DOIT: right limit!
    }
    
    pp=pp1;
    while (susp>0)
      {
	kk=0;
	while (sus[kk]!=0)
	  {
	    if (sus[kk]->gPos()+sus[kk]->gLen()<=pp)
	      {
		dtimeInt=0; while (dtime>=0x80) {dtime1[dtimeInt++]=dtime&0x7F; dtime=int(dtime/128);} 
		dtime1[dtimeInt++]=dtime; for (int uu=1; uu<dtimeInt; uu++) tr[length++]=dtime1[dtimeInt-uu]+128;
		tr[length++]=dtime1[0];
		tr[length++]=noteOff; tr[length++]=sus[kk]->gFreq(); tr[length++]=sus[kk]->gVel();
		dtime=0;
		for (int k=kk; k<susp+1; k++) sus[k]=sus[k+1];
		susp--;
	      } 
	    kk++;
	  }
	pp++; 
	dtime++;
      }
    
    
    // ----------------------------------------
    //    length=0x0000FFFF;

    trLength=7+8+3+length+4;
    a1=trLength&0x000000FF;
    a2=(trLength&0x0000FF00)/256;
    a3=(trLength&0x00FF0000)/65536;
    a4=(trLength&0xFF000000)/16777216;
    to.put(a4);to.put(a3);to.put(a2);to.put(a1);

    to.put(0); to.put(0xff); to.put(0x58); to.put(0x04); to.put(0x04); to.put(0x02); to.put(0x24); to.put(0x08);//4/4
    to.put(0); to.put(0xff); to.put(0x51); to.put(0x03); to.put(0x07); to.put(0xa1); to.put(0x20); //tempo
    to.put(0); to.put(prgch); to.put(tPart[i]->gProgram());//prg

    for (int uu=0; uu<length; uu++) to.put(tr[uu]);

    to.put(0); to.put(255); to.put(47); to.put(0);
  }
  to.close();
  delete[] tr;
  //progressbar->hide();

}


// ------------------------------------------------------------------------------------------------
//
// old stuff:
//
// ------------------------------------------------------------------------------------------------

  /*  unsigned char* xy= new unsigned char[2000];
  unsigned char ch;
  int i;
  int lo;
  int hi;

  long xxxxxx=6;

  int numTr;
  int delta;

  int noteOn=-1;
  int channel=0;

  int prgs[64];
  for (int uu=0; uu<64; uu++) prgs[uu]=0;

#define MAXSUS 512
  KbNote* sus[MAXSUS];
  KbNote* newNote;
  int susp=0;

  unsigned char* tr[64];
  int tracklength[64];

  in.get(ch); xy[0]=ch; in.get(ch); xy[1]=ch; in.get(ch); xy[2]=ch; in.get(ch); xy[3]=ch; xy[4]=0;
  if (!strcmp(xy,"MThd"))
    {
      in.get(ch); in.get(ch); in.get(ch); in.get(ch);
      i=int(ch);
      if (i!=6)
	{
	  cout << "strange header length" << endl;
	} else {
	  in.get(ch); in.get(ch); i=int(ch);
	  // cout << "Fileformat: " << i << endl;
	  in.get(ch); xy[0]=ch; in.get(ch); xy[1]=ch; in.get(ch); xy[2]=ch; in.get(ch); xy[3]=ch; xy[4]=0;
	  xxxxxx=0;
	  numTr=int(xy[1])+256*int(xy[0]);
	  delta=int(xy[3])+256*int(xy[2]);
	  // cout << "Reading now " << numTr << " tracks..., dtime: " << delta << endl;
	  // DOIT: progressbar->setTotalSteps(numTr);
	  for (int trackn=0; trackn<numTr; trackn++)
	    {
	      // progressbar->setProgress(trackn+1);
	      // cout << trackn ;
	      in.get(ch); xy[0]=ch; in.get(ch); xy[1]=ch; in.get(ch); xy[2]=ch; in.get(ch); xy[3]=ch; xy[4]=0;
	      if (strcmp(xy,"MTrk")) { cout << "not a MIDI track" << endl; numTr=0; }
	      in.get(ch); xy[0]=ch; in.get(ch); xy[1]=ch; in.get(ch); xy[2]=ch; in.get(ch); xy[3]=ch; xy[4]=0;
	      tracklength[trackn]=int(xy[3])+256*int(xy[2])+65536*int(xy[1])+16777216*int(xy[0]);
	      //cout << "tracklength: " << tracklength[trackn] << endl;
	      tr[trackn] = new unsigned char[tracklength[trackn]+2000];
	      for (int qq=0; qq<tracklength[trackn]; qq++) { in.get(ch); tr[trackn][qq]=ch; }
	      //for (int qq=0; qq<tracklength[trackn]; qq++) cout << int(tr[trackn][qq]) << ", ";
	    }
	  for (int trackn=0; trackn<numTr; trackn++)
	    {
	      // cout << "\n\ntl[tn](numTr):" << tracklength[trackn] << "(" << numTr << ")" << endl;
	      // Track* track=0;
	      KbPart * part = 0;
	      int run;
	      run=1;
	      int t=0;
	      int cmd;
	      int len;
	      int tempo;
	      int time1;
	      int time2;
	      int keysf;
	      int keymi;
	      // int run=1;
	      int d;
	      int dd;
	      int ddd;
	      int getnote;
	      int note;
	      int vel;
	      int ctrl;
	      int val;
	      int prg;
	      int chn;
	      int btm;
	      int top;
	      char* name;
	      name=new char[150];
	      name[0]='-';
	      name[1]=0;
	      int totalTime=0;
	      susp = 0;
	      while (run)
		{
		  //		  cout << "!!!!!!!! " << int(int(tr[t])&127) << endl;
		  dd=0; while ((d=int(tr[trackn][t++]))>128) { dd*=128; dd+=int(d)&127; }
		  dd*=128; dd+=int(d)&127;
		  //cout << "tt:" << totalTime << ", dt:" << dd << endl;
		  totalTime+=dd;
		  i=int(tr[trackn][t++]);
		  lo=i&15;
		  hi=(i&240)/16;
		  getnote=0;
		  if (i==255) {
		    cmd=int(tr[trackn][t++]);
		    len=int(tr[trackn][t++]);
		    if (cmd==0x51) {
		      tempo=int(tr[trackn][t])+256*int(tr[trackn][t+1])+65536*int(tr[trackn][t+2]);
#ifdef DEBUGIT
		      cout << "tempo: " << tempo << ":" << int(tr[trackn][t]) << ", " << int(tr[trackn][t+1]) << ", " << int(tr[trackn][t+2]) << endl;
#endif
		    } else if (cmd==0x58) {
		      time1=int(tr[trackn][t]); time2=int(tr[trackn][t+1]);
#ifdef DEBUGIT
		      cout << "time1: " << time1 << ", time2: " << time2 << endl;
#endif
		    } else if (cmd==0x59) {
		      keysf=int(tr[trackn][t]); keymi=int(tr[trackn][t+1]);
#ifdef DEBUGIT
		      cout << "key: " << keysf << ", minor=" << keymi << endl;
#endif
		    } else if (cmd==0x03) { strncpy(name,&tr[trackn][t],len)  ; name[len]=0; cout << "Name: \"" << name << "\"" << endl;
		    } else if (cmd==0x2f) { run=0;
		    } else { 
#ifdef DEBUGIT
		      cout << "cmd:" << cmd << endl; 
#endif
		    }
		    t+=len;
		  } else if (hi==9) {
		    //   cout << "note on, channel " << lo << endl;
		    noteOn=1;
		    channel=lo;
		    i=int(tr[trackn][t++]);
		    getnote=1;
		  } else if (hi==8) {
		    // cout << "note off, channel" << lo << endl;
		    noteOn=0;
		    channel=lo;
		    i=int(tr[trackn][t++]);
		    getnote=1;
		  } else if (hi==10) {
		    // After Touch
#ifdef DEBUGIT
		    cout << "PANIC10" << endl;
#endif
		    note=int(tr[trackn][t++]);
		    vel=int(tr[trackn][t++]);
		    noteOn=3;
		  } else if (hi==11) {
		    // Control Change
#ifdef DEBUGIT
		    cout << "PANIC11" << endl;
#endif
		    ctrl=int(tr[trackn][t++]);
		    val=int(tr[trackn][t++]);
		    noteOn=4;
		  } else if (hi==12) {
		    // Program Change
#ifdef DEBUGIT
		    cout << "PANIC12" << endl;
#endif
		    prg=int(tr[trackn][t++]);
		    prgs[lo]=prg;
		    noteOn=5;
		    //part->program = prg; // DOIT: if prg-change, create new Part!
		    //part->trAdr->program = prg;
		    //cout << "prg: " << prg << endl;
		  } else if (hi==13) {
		    // Channel AFter Touch
#ifdef DEBUGIT
		    cout << "PANIC13" << endl;
#endif
		    chn=int(tr[trackn][t++]);
		    noteOn=6;
		  } else if (hi==14) {
		    // Pitch Wheel Change
#ifdef DEBUGIT
		    cout << "PANIC14" << endl;
#endif
		    btm=int(tr[trackn][t++]);
		    top=int(tr[trackn][t++]);
		    noteOn=7;
		  } else if (hi==15) {
#ifdef DEBUGIT
		    cout << "PANIC: hi==15" << endl;
#endif
		    noteOn=8;
		  } else { 
		    getnote=1;
		  }
		  if (getnote) {
		    note=i; vel=int(tr[trackn][t++]);
		    if ((vel==0)&&(noteOn==1)) noteOn=0;
		    if (noteOn == 1) {
		      if (!part) {
			kbtrack = addTrack();
			part = kbtrack->addPart(0,4);
			part->sProgram(prg);
			kbtrack->sProgram(prg);
			kbtrack->sName(name);
		      }
			newNote = new KbNote(note,vel,191,totalTime,0);
			part->addNote(newNote);
			if (susp<MAXSUS) sus[susp++]=newNote;
		      } else if (noteOn == 0) {
			int ii=0;
			for (int i=0; i<susp; i++)
			  if ((note==sus[i]->gFreq()))
			    {
			      sus[i]->sLen(totalTime-sus[i]->gPos());
			      ii=i;
			      i=susp;
			    }
			for (int i=ii; i<susp-1; i++) sus[i]=sus[i+1];
			if (susp>0) susp--;
		      }
		    if ((vel==0)&&(noteOn==0)) noteOn=1;
		  }
		  if (t>tracklength[trackn]) {run=0;cout << "PANIC length-error, t:" << t << ", tl[tn]:" << tracklength[trackn] << endl;}
		}  
	    }
	}
    } else { cout << "not a MIDI file" << endl; }
  // progressbar->hide();
  */
