#ifndef _KBMAIN_C_
#define _KBMAIN_C_

#include <errno.h>
extern int errno;

#include "../config.h"


#include "ifFactory.h"
#include "kbMain.h"
#include "ifMain.h"
#include "kbPart.h"
#include "kbMasterTrack.h"
#include "kbScoreTrack.h"
#include "kbWaveTrack.h"
#include "kbComment.h"
#include "kbDrumTrack.h"
#include "kbNote.h"
#include "kbMasterEvent.h"
#include "kbMidiEvent.h"
#include "kbAuxElement.h"
#include "kbWaveEvent.h"
#include "kbLyrics.h"
#include "kbStem.h"
#include "kbExp.h"
#include "kbBow.h"

#include "partFunctions/kbPartExtension.h"

#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#include <sys/ioctl.h>
#include <unistd.h>

#include <stdio.h>
#include <fcntl.h>

#include "globalStuff.c"
#include <math.h>

#include "sound.h"

// childprocess:

#include "childinit.c"

#include "midiFile.c"

#define INITTRACKS 4


KbMain::KbMain( IfFactory * fac, int argc, char ** argv )
  : ifFactory(fac), snap(192), tempo(100), meter0(4), meter1(2), track(0), position(0),
    playWait(false), beepFlag(false), preBeats(2), partShow(0), pp(0),
    beepMidi(false), clickInst(40), clickVol(120), cycle(false), selX1(0), selX2(4*1536),
    extMan(new KbExtensionManager()), fileInfo(new midifileinfo)
{
  // MIDI init:
  fmOut::setFMPatchesDirectory("/opt/kde/share/apps/Brahms/fm");
  MidiMapper *map=new MidiMapper(NULL); // "/opt/kde/share/apps/kmid/maps/gm.map"); // YamahaPSS790.map");
  if (!map->OK()) { cout << "PANIC" << endl; exit(0); }
  
#ifdef HAVE_ARTS
  // CORBA initialization.
  orb = CORBA::ORB_init(argc, argv, "mico-local-orb");
  boa = orb->BOA_init(argc, argv, "mico-local-boa");
  CORBA::Object_var obj = orb->bind ("IDL:Arts/Synthesizer:1.0",
				     "inet:localhost:8888");
  synthesizer = Arts::Synthesizer::_narrow (obj);
  /*if(CORBA::is_nil(synthesizer)) {
    fprintf(stderr,"%s will only work when the Arts Server is running\n",
    argv[0]);
    exit(1);
    }*/
  
#endif

  midi=new DeviceManager(0); // defaults to the first entry for all 16 MIDI channels
  midi->initManager();       // defines the devices (one for each entry), creates the midiOut objects
  midi->setMidiMap(map);     // sets the MIDI map
  char * line; int n = midi->numberOfSynthDevices() + midi->numberOfMidiPorts(); // my AWE has 2 synths and 1 MIDI
  for (int i=0; i<n && i<MAXDEVNUM; i++) { devices[i] = strdup(midi->name(i)); line = devices[i]; line+=9; line[0]=0; }

  // init for child process:
  pid_t pid;
  static struct sigaction sigcld;
  sigcld.sa_handler = sigcldHandler; // call to sigcldHandler() when child exits, to avoid zombies
  sigemptyset(&sigcld.sa_mask);
  sigcld.sa_flags = 0;
  sigaction(SIGCHLD, &sigcld, NULL);

  ifMain = fac->createMain(this,argc,argv);

  // commandline arguments:
  
  if (argc<2) { // if no arguments given, create std layout
    // track = new KbMasterTrack(this);
    track = new KbScoreTrack(this);
    KbTrack * tr = track;
    for (int i=1;i<INITTRACKS;i++) {
      tr->sNext(new KbScoreTrack(this));
      tr = tr->gNext();
    }
  } else { // otherwise load song
    char ext[3];
    int l=strlen(argv[1])-1;
    ext[0] = argv[1][l-2];  ext[1] = argv[1][l-1];  ext[2] = argv[1][l]; 
    cout << "ext: " << ext << endl;
    if (strcmp(ext,"mid")==0 || strcmp(ext,"MID")==0 || strcmp(ext,"idi")==0 || strcmp(ext,"IDI")==0)
      getMidi(argv[1]);
    else if (strcmp(ext,".bms") || strcmp(ext,".BMS")==0)
      getKooBase(new ifstream(argv[1]));
    else cout << "Brahms can only read midi or Brahms file format" << endl;
    // adjustRightBorder();
  }
  
  ifMain->exec();
}

/*
void KbMain::adjustRightBorder() {
  rightPosition = 0;
  for (KbTrack * tr=gTrack(); tr!=0; tr=tr->gNext())
    for (KbPart * pt=tr->gPart(); pt!=0; pt=pt->gNext()) {
      if (pt->gLastAtom() != 0)
	if (pt->gLastAtom()->gPos()>rightPosition) rightPosition = pt->gLastAtom()->gPos();
    }
  rightPosition += int(1536.0*gMeter(0)/gMeter(1));
  sRightSel(rightPosition);
}
*/

int KbMain::gNumberOfDevices() { return midi->numberOfSynthDevices() + midi->numberOfMidiPorts(); }

IfFactory * KbMain::gFactory() {
  return ifFactory;
}

IfMain * KbMain::gInterface() {
  return ifMain;
}

KbTrack * KbMain::gTrack(int n) {
  if (n==0) return track;
  KbTrack * tr = track;
  KbTrack * rv = 0;
  for (;tr!=0 && n!=0;n--) tr = tr->gNext();
  if (tr!=0) rv = tr;
  return rv;
}

void KbMain::sTrack(KbTrack * t) {
  track = t;
}

int KbMain::gSnap() {
  return snap;
}

void KbMain::sSnap(int s) {
  snap = s;
}

int KbMain::gTempo() {
  return tempo;
}

void KbMain::sTempo(int t) {
  tempo = t;
  if (playing==true) {
    char help[20];
    sprintf(help,"1 %i",tempo);
    write(fdToChild[1], help, 20); // to child process
  }
}

int KbMain::gMeter(int i) {
  switch (i) {
  case 0: return meter0; break;
  case 1: return (int) pow(2,meter1); break;
  }
  return 0;
}

void KbMain::sMeter(int i, int m) {
  switch (i) {
  case 0: meter0 = m; break;
  case 1: meter1 = int(1.0001*log(m)/log(2)); break;
  }
}

KbTrack * KbMain::createTrack(int i) {
  KbTrack * retv = 0;
  switch (i) {
  case 0: retv = new KbScoreTrack(this); break;
  case 1: retv = new KbDrumTrack(this); break;
  case 2: retv = new KbMasterTrack(this); break;
  case 3: retv = new KbWaveTrack(this); break;
  case 4: retv = new KbCommentTrack(this); break;
  default:
    cout << "PANIC KbMain::createTrack()" << endl;
  }
  return retv;
}

KbTrack * KbMain::addTrack(int i) {
  KbTrack * rv = createTrack(i);
  if (track==0) track = rv;
  else {
    KbTrack * tr;
    for (tr=track;tr->gNext()!=0;tr=tr->gNext()) {}
    tr->sNext(rv);
  }
  return rv;
}

void KbMain::convertTrack(KbTrack * cTrack, int i) {
  gInterface()->msg("Track type changed");
  KbTrack * mytr = cTrack;
  KbTrack * nextTr = 0;
  KbTrack * tr=0;
  KbTrack * newTrack = 0;
  for (tr=gTrack(); tr!=0&&tr->gNext()!=mytr; tr=tr->gNext()) {}
  if (tr!=0) {
    nextTr = mytr->gNext();
    newTrack = createTrack(i);
    tr->sNext(newTrack);
    newTrack->sNext(nextTr);
  } else {
    nextTr = mytr->gNext();
    newTrack = createTrack(i);
    sTrack(newTrack);
    newTrack->sNext(nextTr);
  }
  delete mytr;
  newTrack->gInterface()->update();
}

char * KbMain::gDevice(int i) {
  return devices[i];
}

KbPosition KbMain::gLeftSel() {
  return selX1;
}

KbPosition KbMain::gRightSel() {
  return selX2;
}

int KbMain::gLeftBar() {
  KbPart * master = Master();
  if (master) return selX1.gBar(master);
  else return selX1.gBar(gMeter(0),gMeter(1));
}

int KbMain::gRightBar() {
  KbPart * master = Master();
  if (master) return selX2.gBar(master);
  else return selX2.gBar(gMeter(0),gMeter(1));
}

void KbMain::sLeftSel(long p) {
  if (p!=-1) selX1 = (unsigned long) p;
  else selX1 = position;
}

void KbMain::sLeftSel(KbPosition p) { selX1 = p; }

void KbMain::sRightSel(long p) {
  if (p!=-1) selX2 = (unsigned long) p;
  else selX2 = position;
}

void KbMain::sRightSel(KbPosition p) { selX2 = p; }

KbPosition KbMain::gPos() {
  return position;
}


KbPart * KbMain::Master() {
  KbMasterTrack * mastertrack = 0;
  KbPart * master = 0;
  int i = 0;
  for (KbTrack * tr=track;tr!=0;tr=tr->gNext()) {
    if (tr->gToggle(0)==false) // not muted
      if (tr->gPart()!=0) if ((tr->isA()==2) && (master==0)) mastertrack = (KbMasterTrack*) tr;
    i++; }
  if (mastertrack) master = mastertrack->gPart();
  return master;
}

void KbMain::sPos(unsigned long p) {
  position = p;
}

void KbMain::sPos(KbPosition p) {
  position = p;
}

void KbMain::sPos(int p, int b, int t) {
  position.set(p,b,t,Master(),snap);
  /*
  if (b==-1) { // p is the only parameter !
    position = p;
  } else { // p=bar, b=beat, t=ticks
    timeF = 1.0*gMeter(0)/gMeter(1);
    ticksPerBar = int(timeF*1536);
    position = ticksPerBar*(p-1) + ticksPerBar*(b-1)/gMeter(0) + t;
    position = position-(position%snap);
    ticks = t;
    beats = b;
    bars  = p;
  }
  if (position<0) position = 0;
  */
}
/*
unsigned long KbMain::gPosOf(int p, int b, int t) {
  // p=bar, b=beat, t=ticks
  KbMasterTrack * mastertrack = 0; KbPart * master = 0; unsigned long mOff = 0; int i = 0;
  for (KbTrack * tr=track;tr!=0;tr=tr->gNext()) {
    if (tr->gToggle(0)==false) // not muted
      if (tr->gPart()!=0) if ((tr->isA()==2) && (master==0)) mastertrack = (KbMasterTrack*) tr;
    i++; }
  if (mastertrack) master = mastertrack->gPart();
  if (master) {
    p--; b--;
    master->sCur(master->gFirstMasterEvent()); mOff = 1536*master->gTime1()/master->gTime2()*(master->gFrom());
    unsigned long mePos = 0;
    KbMasterEvent * me = master->gFirstMasterEvent();
    while (me!=0 && me->gPos()<pos) {
      if (me->gTempo()==0) {
	mePos = me->gPos()+mOff;
	

      }
    }
  } else {
    unsigned long myPos;
    timeF = 1.0*gMeter(0)/gMeter(1);
    ticksPerBar = int(timeF*1536);
    myPos = ticksPerBar*(p-1) + ticksPerBar*(b-1)/gMeter(0) + t;
  }
  return myPos;
}


void KbMain::BBT(unsigned long pos, int t0, int t1) {
  m0 = (t0==0)?gMeter(0):t0; // ?? DOIT!
  m1 = (t1==0)?gMeter(1):t1; // ?? DOIT
  // position = pos;
  KbMasterTrack * mastertrack = 0; KbPart * master = 0; unsigned long mOff = 0; int i = 0;
  for (KbTrack * tr=track;tr!=0;tr=tr->gNext()) {
    if (tr->gToggle(0)==false) // not muted
      if (tr->gPart()!=0) if ((tr->isA()==2) && (master==0)) mastertrack = (KbMasterTrack*) tr;
    i++; }
  if (mastertrack) master = mastertrack->gPart();
  if (master) { master->sCur(master->gFirstMasterEvent()); mOff = 1536*master->gTime1()/master->gTime2()*(master->gFrom()); }
  unsigned long pPos = 0;
  int deltaPos = 0;
  unsigned long mePos = 0;
  ticks = 0;
  beats = 0;
  bars = 0;
  KbMasterEvent * me = 0;
  if (master) {
    me = master->gFirstMasterEvent();
    while (me!=0 && me->gPos()+mOff<pos) {
      if (me->gTempo()==0) {
	mePos = me->gPos()+mOff;
	if (mePos==mOff) {
	} else {
	  deltaPos = mePos-pPos;
	  timeF = 1.0*m0/m1;
	  ticksPerBar = int(timeF*1536);
	  ticksPerBeat = ticksPerBar/m0;
	  timeWI = deltaPos%ticksPerBar;
	  ticks += deltaPos%ticksPerBeat;
	  beats += (timeWI-(deltaPos%ticksPerBeat))/ticksPerBeat;
	  bars += (deltaPos-timeWI)/ticksPerBar;
	}
	m0 = me->gMeter0();
	m1 = me->gMeter1();
	pPos = mePos;
      }
      me = (KbMasterEvent*) me->gNext();
    }
    bars++; beats++;
  } else {
    timeF = 1.0*m0/m1;
    if (timeF==0) cerr << "PANIC: BBT" << endl;
    ticksPerBar = int(timeF*1536);
    ticksPerBeat = ticksPerBar/m0;
    timeWI = pos%ticksPerBar;
    ticks = pos%ticksPerBeat;
    beats = (timeWI-ticks)/ticksPerBeat+1;
    bars = (pos-timeWI)/ticksPerBar+1;
  }
}


int KbMain::gBar(long pos, int t0, int t1) {
  if (pos!=-1) BBT(pos,t0,t1);
  return bars;
}

int KbMain::gBeat(long pos, int t0, int t1) {
  if (pos!=-1) BBT(pos,t0,t1);
  return beats;
}

int KbMain::gTick(long pos, int t0, int t1) {
  if (pos!=-1) BBT(pos,t0,t1);
  return ticks;
}
*/

void KbMain::togCycle() {
  if (cycle==true) cycle = false; else cycle = true;
}


// ******************************************************
//
// PLAY
// ====
//


void KbMain::play(int tracki/*=-1*/, unsigned long posleft/*=0*/, unsigned long posright/*=0*/)
{
  if (!playing) {
    gInterface()->playInit();
    closeDev();

    if (pipe(fdToChild) == -1)	{ cout << "PANIC: could not create pipe" << endl; }
    if (pipe(fdToParent) == -1)	{ cout << "PANIC: could not create pipe" << endl; }
   
    pid = fork(); // fd[1]: write, fd[0]: read
    if (pid == 0) {	// The Child
      ::close(fdToChild[1]); // just read
      ::close(fdToParent[0]); // write to parent
      fcntl(fdToChild[0], F_SETFL, O_NONBLOCK);
      
      playIt(fdToChild[0],tracki,posleft,posright);
      closeDev();
      exit(0);
    }
    else if (pid > 0) {  // The Parent
      playing = true;
      ::close(fdToChild[0]); // just write
      ::close(fdToParent[1]); // read from child
      fcntl(fdToParent[0], F_SETFL, O_NONBLOCK); // ??
      fback = fdToParent[0];
    }
    else { cout << "We have trouble" << endl; } // pid=-1; fork-error
  }
}


void KbMain::playIt(int fout, int tracki/*=-1*/, unsigned long posleft/*=-1*/, unsigned long posright/*=-1*/)
{

  char buffer[CMDLEN + 1];
  ssize_t n_read;
  int command = 0;
  int variable;
  char * valuePtr;
  char * valuePtr1;
  int value;
  int value1;
  
  // StructureBuilder * myBuilder = waveInit();

  int alltracks = 0;
  for (KbTrack * tr=track;tr!=0;tr=tr->gNext()) alltracks++;
  int table[alltracks];
  int dTable[alltracks];
  KbWaveTrack * wTable[alltracks];
  int waveTracks = 0;
  int waveEvents = 0;
  
  KbMasterTrack * mastertrack = 0;
  KbPart * master = 0;
  KbPosition mOff;

  int stNumber = 0;
  int dtNumber = 0;
  int i = 0;
  int w = 0;
  for (KbTrack * tr=track;tr!=0;tr=tr->gNext()) {
    table[i] = 0; dTable[i] = 0;
    if (tr->gToggle(0)==false) // not muted
      if (tr->gPart()!=0) {    // does contain at least one part
	if (tr->isA()==0) { table[i] = stNumber; revSTable[stNumber] = i; st[stNumber++] = (KbScoreTrack*) tr; }
	if (tr->isA()==1) { dTable[i] = dtNumber; revDTable[dtNumber] = i; dt[dtNumber++] = (KbDrumTrack*) tr; }
	if ((tr->isA()==2) && (master==0)) mastertrack = (KbMasterTrack*) tr;
	if ((tr->isA()==3) && (tr->gPart())) { wTable[w++] = (KbWaveTrack*) tr; }
      }
    i++;
  }
  if (mastertrack) master = mastertrack->gPart();
  if (master) { master->sCur(master->gFirstMasterEvent()); mOff = master->gOffset(); }
  //
  waveTracks = w;
  waveEvents = 0;

#ifdef HAVE_ARTS
  for (int i = 0; i<waveTracks; i++)
    for (KbPart * wp = wTable[i]->gPart(); wp!=0; wp = wp->gNext()) {
      wBuilder[waveEvents] = waveInit((KbWaveEvent*)wp->gFirstAtom());
      wPosition[waveEvents] = wp->gOffset();
      waveEvents++;
    }
#endif
  
  for (int i=0;i<alltracks;i++) // this establishes a list to transform the
    if (dTable[i]>0)            // track index from the GUI to the index used here
      table[i] += dTable[i]+stNumber; // i.e. tIndex see below!

  tNum = stNumber+dtNumber;

  int           tProgram[tNum];
  int           tOutput[tNum];
  int           tChannel[tNum];
  int           tVolume[tNum];
  int           tTransp[tNum];
  int           tDelay[tNum];
  KbPart *      tPart[tNum];
  KbPosition    pOff[tNum];
  int           tStop[tNum];

  int tIndex = 0;

  for (int i=0;i<stNumber;i++) {
    tProgram[tIndex] = st[i]->gProgram();
    tOutput[tIndex] = st[i]->gOutput();
    tChannel[tIndex] = st[i]->gChannel();
    tVolume[tIndex] = st[i]->gVolume();
    tTransp[tIndex] = st[i]->gTranspose();
    tDelay[tIndex] = st[i]->gDelay();
    tPart[tIndex] = st[i]->gPart();
    pOff[tIndex] = tPart[tIndex]->gOffset(); //1536*tPart[tIndex]->gTime1()/tPart[tIndex]->gTime2()*(tPart[tIndex]->gFrom());
    if (tDelay[tIndex]>0) pOff[tIndex] += tDelay[tIndex];
    revTable[tIndex] = revSTable[i];
    tIndex++;
  }
  for (int i=0;i<dtNumber;i++) {
    tProgram[tIndex] = dt[i]->gProgram();
    tOutput[tIndex] = dt[i]->gOutput();
    tChannel[tIndex] = dt[i]->gChannel();
    tVolume[tIndex] = dt[i]->gVolume();
    tTransp[tIndex] = dt[i]->gTranspose();
    tDelay[tIndex] = dt[i]->gDelay();
    tPart[tIndex] = dt[i]->gPart();
    pOff[tIndex] = tPart[tIndex]->gOffset(); //1536*tPart[tIndex]->gTime1()/tPart[tIndex]->gTime2()*(tPart[tIndex]->gFrom());
    if (tDelay[tIndex]>0) pOff[tIndex] += tDelay[tIndex];
    revTable[tIndex] = revDTable[i];
    tIndex++;
  }

  for (int k=0; k<256; k++) { sus[k]=0; susCh[k]=0; susTr[k]=0; }
  sus[0]=0;
  susp=0;

  for (int i=0;i<tNum;i++) {
    tStop[i] = 0;
    tPart[i]->sCur(tPart[i]->gFirstAtom());
    midi->setDevice(tChannel[i],tOutput[i]);
  }

  midi->openDev();
  midi->initDev();

  for (int i=0;i<tNum;i++) {
    if (tPart[i]!=0) {
      if (tProgram[i]==128) { midi->chnPatchChange(tChannel[i],tPart[i]->gProgram()); }
      else { midi->chnPatchChange(tChannel[i],tProgram[i]);
      }
    }
  }

  for (int i=0;i<tNum;i++) led[i] = 0;

  int stop = 0;
  long double oldTimePos = 0;
  long double timePos = 0;
  //unsigned long pp = 0;
  KbNote * note = 0;
  int totVolume;
  int totFreq;
  int myChan;
  needSync = true;
  int tempoX = 0;
  int countToAnswer = 0;

  midi->tmrStart();

  if (posleft==-1) pp = position;
  else pp = posleft;

  while (stop<2) {

    // first check correspondence with parent!
    
    midi->sync();
    if (n_read = read(fout, buffer, CMDLEN)>0) { // message from Parent
      buffer[n_read] = 0;
      command = atoi(buffer); // buffer has following structure: "n xxx yyyyy"
      valuePtr = &buffer[2]; valuePtr1 = &buffer[6]; // n = command, xxx = tracknumber, yyyyy = argument
      // cout << command << endl;
      switch (command) { // commands: 0:stop, 1:tempo, 2: mute-toggle, 3: program, 4:volume, 5: transp
      case 0:
	stop = 5 + atoi(valuePtr);
	position = pp;
	break;
      case 1:
	value = atoi(valuePtr);
	if (value>0) tempo = value;
	break;
      case 2:
	value = table[atoi(valuePtr)];
	if (tStop[value]==0) tStop[value] = 2;
	else if (tStop[value]==2) {
	  tStop[value] = 0;
	  for (;(tPart[value]->gCurAtom()!=0)&&(tPart[value]->gCurAtom()->gPos() + pOff[value] < pp);
	       tPart[value]->sCur(tPart[value]->gCurAtom()->gNext())) {}
	  if (tPart[value]->gCurAtom()==0) tStop[value]=2;
	}
	break;
      case 3:
	value = table[atoi(valuePtr)];
	value1 = atoi(valuePtr1);
	tProgram[value] = value1;
	midi->chnPatchChange(tChannel[value],value1);
	break;
      case 4:
	value = table[atoi(valuePtr)];
	value1 = atoi(valuePtr1);
	tVolume[value] = value1;
	break;
      case 5:
	value = table[atoi(valuePtr)];
	value1 = atoi(valuePtr1);
	tTransp[value] = value1;
	break;
	
      }
    }
    
    // now: Mastertrack!
    if (master) {
      if (master->gCurAtom()!=0)
	if (master->gCurAtom()->gPos()+mOff <= pp) {
	  tempoX = ((KbMasterEvent*) master->gCurAtom())->gTempo();
	  if (tempoX>0) tempo = tempoX; // DOIT: else meter!
	  master->sCur(master->gCurAtom()->gNext());
	}
    }

#ifdef HAVE_ARTS
    // now: WaveEvents:
    for (int i = 0; i<waveEvents; i++)
      if (pp==wPosition[i])
	wavePlay(wBuilder[i]);
#endif

    
    timePos += 100.0/tempo;
    if (needSync==true) { midi->sync(); needSync=false; }
    // midi->sync();
    // midi->wait(timePos);

    kk=0;
    while (sus[kk]!=0) {
      if (susPos[kk] + sus[kk]->gLen()<=pp+1) {
	myWait(timePos);
	midi->noteOff(susCh[kk], susFreq[kk], sus[kk]->gVel());
	led[susTr[kk]] = 0;
	for (int k=kk; k<susp+1; k++) {
	  sus[k]=sus[k+1]; susFreq[k]=susFreq[k+1]; susCh[k]=susCh[k+1];
	  susOut[k]=susOut[k+1]; susPos[k]=susPos[k+1]; susTr[k]=susTr[k+1]; }
	sus[susp--]=0;
	kk--;
      }
      kk++;
    }
    
    for (int ttt=0; ttt<tNum; ttt++) if (tStop[ttt]<2) if (tPart[ttt] != 0) if (tPart[ttt]->gCurAtom() !=0) {
      while ((tPart[ttt]->gCurAtom()->gPos()+pOff[ttt] <= pp) && (tStop[ttt]<2)) {
	if (tPart[ttt]->gCurAtom()->isNote()) { // NOTE EVENT:
	  myWait(timePos);
	  note = (KbNote*) tPart[ttt]->gCurAtom();
	  totVolume = note->gVel() + tVolume[ttt]; if (totVolume>127) totVolume = 127; if (totVolume<0) totVolume = 0;
	  totFreq   = note->gFreq() + tTransp[ttt]; if (totFreq>127) totFreq = 127; if (totFreq<0) totFreq = 0;
	  if (note->gChan()!=-1) myChan = note->gChan(); else myChan = tChannel[ttt];
	  midi->noteOn(myChan,totFreq,totVolume);
	  susCh[susp] = myChan;
	  susOut[susp]= tOutput[ttt];
	  susPos[susp]= note->gPos()+pOff[ttt];
	  susTr[susp] = ttt;
	  susFreq[susp] = totFreq;
	  sus[susp++] = note;
	  led[ttt] = 10;
	} else if (tPart[ttt]->gCurAtom()->isMidiEvent()) { // (other) MIDI EVENT:
	  KbMidiEvent * me = (KbMidiEvent*) tPart[ttt]->gCurAtom();
	  // DOIT!
	}

	if (tPart[ttt]->gCurAtom()->gNext()==0) {
	  if (tPart[ttt]->gNext()==0) tStop[ttt] = 2;
	  else { // new part starts: do program change etc DOIT
	    tPart[ttt] = tPart[ttt]->gNext();
	    tPart[ttt]->sCur(tPart[ttt]->gFirstAtom()); pOff[ttt] = tPart[ttt]->gOffset();
	    if (tPart[ttt]->gCurAtom()==0) tStop[ttt] = 2;
	  }
	} else {
	  tPart[ttt]->sCur( tPart[ttt]->gCurAtom()->gNext() );
	}
      }
    }
    pp++;
    if ((posright!=-1)&&(pp>posright)) stop = 2;
    if (stop<2) { stop=2; for (int i=0;i<tNum;i++) if (tStop[i]<2) stop=0; }
    if (countToAnswer==96) {
      countToAnswer = 0;
      midi->wait(timePos);
      midi->sync();
      answerParent();
    }
    countToAnswer++;
  }
  while (susp>0) {
    timePos += 100.0/tempo;
    if (needSync==true) { midi->sync(); needSync=false; }

    if (stop==5) { pp += 3072; }

    kk=0;
    while (sus[kk]!=0) {
      if (susPos[kk] + sus[kk]->gLen()<=pp) {
	myWait(timePos);
	midi->noteOff(susCh[kk], sus[kk]->gFreq(), sus[kk]->gVel());
	led[susTr[kk]] = 0;
	for (int k=kk; k<susp+1; k++) {
	  sus[k]=sus[k+1]; susCh[k]=susCh[k+1]; susOut[k]=susOut[k+1];
	  susFreq[k]=susFreq[k+1]; susPos[k]=susPos[k+1]; susTr[k]=susTr[k+1]; }
	sus[susp--]=0;
	kk--;
      } 
      kk++;
    }
    pp++; // pp+=tempo; // urspruenglich pp++;
    if (countToAnswer==96) {
      countToAnswer = 0;
      midi->wait(timePos);
      midi->sync();
      answerParent();
    }
    countToAnswer++;
  } // else { if (stop!=5) stop = 4; }
  
  
  midi->sync();
  closeDev();

  for (int i=0;i<10;i++) {
    sprintf(help,"-1 %i\n",stop);
    write(fdToParent[1], help, 80); // "stop" to parent process
  }

}

#ifdef HAVE_ARTS
StructureBuilder * KbMain::waveInit(KbWaveEvent * ev) {
  StructureBuilder * sb = new StructureBuilder(synthesizer);
  
  sb->createModule("Synth_PLAY_WAV","play-wav");
  sb->createModule("Synth_BUS_UPLINK","uplink");
  sb->createModule("Synth_STRUCT_KILL","kill");

  sb->setStringValue("play-wav.filename",ev->gFileName());
  sb->connect("play-wav.left","uplink.left");
  sb->connect("play-wav.right","uplink.right");
  sb->setStringValue("uplink.busname","audio01");
  sb->connect("play-wav.done","kill.ready");
  return sb;
}

void KbMain::wavePlay(StructureBuilder * sb) {

  Arts::ArtsServerSeq preferredServers;
  long structureID = sb->execute(preferredServers); // Brahms-STOP: synthesizer->freeStructure(structureID);

  if(!sb->okay())
    {
      fprintf(stderr,"error in SBuilder: %s\n",sb->error());
    }

  // assert(sb->okay());

}
#endif

void KbMain::waitForClap() {
  unsigned char waitbuffer[CLAPBUF];
  int dspfd, l, sum;
  bool t=false;

  if ((dspfd=open(DSP_NAME, O_RDONLY, 0))==-1) { cout << "open failed" << endl; t = true; }
  
  
  while(t==false) {
    l=read(dspfd,waitbuffer,CLAPBUF);
    if (l==-1) t = true;
    sum = -CLAPBUF*127;
    for (int i=0; i<CLAPBUF;i++) sum += (int) waitbuffer[i];
    if (abs(sum) > 5) t = true;
  }
  // DOIT: -> QtMain:   stat->changeItem("... playing song", ID_MAIN_STATUS);
}

void KbMain::myBeep() {
  clickVol1 = clickVol;
  if (beepCount%playTicks != 0) clickVol1 = clickVol1 / 2;
  midi->noteOff(9,clickInst,clickVol1);
  midi->noteOn(9,clickInst,clickVol1);
}

bool KbMain::gPlayWait() {
  return playWait;
}


bool KbMain::Playing() { return playing; }

void KbMain::myWait(int timePos) {
  if (oldTimePos!=timePos) {
    midi->wait(timePos);
    oldTimePos=timePos;
  }
  needSync=true;
}

void KbMain::answerParent() {
  // this message goes from the playing sequencer (child process) to the GUI (parent process)
  
  count = 0;
  answer = 0;
  shift = 1;
  for (i=0;i<tNum;i++) {
    if (led[i]>0) answer += int(pow(2,revTable[i]));
  }
  sprintf(help,"%i %i\0",answer,pp);
  write(fdToParent[1], help, 80); // to parent process
}


void KbMain::stopAll(bool zero) {
  // cout << "stopping" << endl;
  char help[20];
  sprintf(help,"0 %d",zero);
  write(fdToChild[1], help, 20); // to child process
  // write(fdToChild[1], "0\0", 2); // to child process
  playing = false;
}

void KbMain::hit(int out, int ch, int freq, int vol) {
  if (!playing) {
    if (!midi->isOpen()) {
      midi->setDevice(ch,out);
      midi->openDev();
      midi->initDev();
    }
    if (freq!=0) {
      midi->tmrStart();
      midi->noteOn(ch,freq,vol);
      midi->relwait(100);
      midi->noteOff(ch,freq,vol);
      midi->sync();
      midi->tmrStop();
    }
  }
}

void KbMain::closeDev() {
  playing = false;
  midi->tmrStop();
  midi->closeDev();
}

void KbMain::muteTrack(int trNum) {
  if (playing==true) {
    char help[20];
    sprintf(help,"2 %i",trNum);
    write(track->gMain()->fdToChild[1], help, 20); // to child process
  }
}

void KbMain::updateInst(int trNum, int n) {
  if (playing==true) {
    char help[20];
    sprintf(help,"3 %i 00%i",trNum,n);
    write(track->gMain()->fdToChild[1], help, 20); // to child process
  }
}

void KbMain::updateVol(int trNum) {
  if (playing==true) {
    char help[20];
    sprintf(help,"4 %i",trNum);
    write(track->gMain()->fdToChild[1], help, 20); // to child process
  }
}

void KbMain::updateTra(int trNum) {
  if (playing==true) {
    char help[20];
    sprintf(help,"5 %i",trNum);
    write(track->gMain()->fdToChild[1], help, 20); // to child process
  }
}

int KbMain::gFback() {
  return fback;
}

/*KbPosition KbMain::gRightPosition() {
  return rightPosition;
  }

void KbMain::sRightPosition(int p) {
  rightPosition = p;
  }*/

// getMidi() and saveMidi() are in file midiFile.c

long getlongval(char * p,const char * txt) {
  long rv = 0;
  int len = strlen(txt);
  bool exit=false;
  while (exit==false) {
    if (strncmp(p,txt,len)==0) {
      p += len;
      while ((p[0]!='\"')||(p[0]==0)||(p[0]=='>')||(p[0]=='\n')) p++;
      if (p[0]=='\"') { p++; rv = atol(p); }
      exit = true;
    } else {
      p++;
      if ((p[0]==0)||(p[0]=='>')||(p[0]=='\n')) exit = true;
    }
  }
  return rv;
}

int getval(char * p,const char * txt) {
  int rv = 0;
  int len = strlen(txt);
  bool exit=false;
  while (exit==false) {
    if (strncmp(p,txt,len)==0) {
      p += len;
      while ((p[0]!='\"')||(p[0]==0)||(p[0]=='>')||(p[0]=='\n')) p++;
      if (p[0]=='\"') { p++; rv = atoi(p); }
      exit = true;
    } else {
      p++;
      if ((p[0]==0)||(p[0]=='>')||(p[0]=='\n')) exit = true;
    }
  }
  return rv;
}

char * getstrval(char * p,const char * txt) {
  char * rv = 0;
  int len = strlen(txt);
  int len1 = 0;
  bool exit=false;
  while (exit==false) {
    if (strncmp(p,txt,len)==0) {
      p += len;
      while ((p[0]!='\"')||(p[0]==0)||(p[0]=='>')||(p[0]=='\n')) p++;
      if (p[0]=='\"') {
	p++;
	char * p1 = p;
	while ((p1[0]!='\"')||(p1[0]==0)||(p1[0]=='>')||(p1[0]=='\n')) p1++;
	if (p1[0]=='\"') {
	  len1 = p1-p+1;
	  rv = new char[len1];
	  for (int i=0;i<len1-1;i++) rv[i] = p[i];
	  rv[len1-1]=0;
	}
      }
      exit = true;
    } else {
      p++;
      if ((p[0]==0)||(p[0]=='>')||(p[0]=='\n')) exit = true;
    }
  }
  return rv;
}

#define GET in.getline(line,400,'\n')

void KbMain::getKooBase(ifstream * inPtr) {
  //cout << "loading Brahms..." << endl;
  
  ifstream &in = *inPtr;

  char * line = new char[401];
  char * ptr = line;
  KbTrack * tr;
  KbScoreTrack * str;
  KbDrumTrack * dtr;
  KbMasterTrack * mtr;
  KbWaveTrack * wtr;
  KbCommentTrack * ctr;
  KbPart * pt;
  KbNote * nt;
  int trNum;
  int trType;
  char * trName;
  int trMute;
  int trLock;
  int trPrg;
  int trVol;
  int trOut;
  int trDel;
  int trChn;
  // int ptStart;
  // int ptEnd;
  unsigned long ptOffset;
  int ptClef;
  int ptMeter0;
  int ptMeter1;
  int ptKey;
  int ptPrg;
  int ntPitch;
  int ntVel;
  unsigned long ntPos;
  int ntEnh;
  int ntLen;
  int ntChn;
  char * ntWord;
  int ntStem;
  int ntExp;
  int ntExpOff;
  int ntBow;
  int ntBowDir;
  int ntBowDelta;
  unsigned long mtPos;
  int mtTempo;
  int mtMeter0;
  int mtMeter1;
  unsigned long auxPos;
  int auxYoff;
  int auxSymbol;
  int auxParameter;
  char* auxWord;
  unsigned long lrPos;
  char* lrWord;
  unsigned long wavPos;
  char* wavName;

  GET;
  GET; ptr = line+10;
  if (strncmp(ptr,"Brahms",6)!=0) { cout << "not a valid Brahms file" << endl;
  } else {
    while (strncmp(ptr,"</DOCUMENT>",11)!=0) {
      ptr = line; while (ptr[0]==' ') ptr++;
      ptr++;
      if (strncmp(ptr,"HEAD",4)==0) {
	tempo  = getval(ptr,"tempo");
	meter0 = getval(ptr,"meter0");
	meter1 = getval(ptr,"meter1");
	trNum  = getval(ptr,"tracks");
      } else if (strncmp(ptr,"TRACK",5)==0) {
	trType = getval(ptr,"type");    tr = addTrack(trType);
	trName = getstrval(ptr,"name"); tr->sName(trName);
	trMute = getval(ptr,"mute");    tr->sToggle(0,trMute);
	trLock = getval(ptr,"lock");    tr->sToggle(1,trLock);
	GET; ptr=line; while (ptr[0]==' ') ptr++;
	while(strncmp(ptr,"</TRACK>",8)!=0) {
	  if (strncmp(ptr,"<OPTIONS",8)==0) {
	    switch (trType) {
	    case 0:
	      str = (KbScoreTrack*) tr;
	      trPrg = getval(ptr,"program"); str->sProgram(trPrg);
	      trChn = getval(ptr,"channel"); str->sChannel(trChn);
	      trOut = getval(ptr,"output");  str->sOutput(trOut);
	      trVol = getval(ptr,"volume");  str->sVolume(trVol);
	      trDel = getval(ptr,"delay");   str->sDelay(trDel);
	      break;
	    case 1:
	      dtr = (KbDrumTrack*) tr;
	      trPrg = getval(ptr,"program"); dtr->sProgram(trPrg);
	      trChn = getval(ptr,"channel"); dtr->sChannel(trChn);
	      trOut = getval(ptr,"output");  dtr->sOutput(trOut);
	      trVol = getval(ptr,"volume");  dtr->sVolume(trVol);
	      trDel = getval(ptr,"delay");   dtr->sDelay(trDel);
	      break;
	    case 2:
	      break;
	    case 3:
	      break;
	    case 4:
	      break;
	    }
	  } else if (strncmp(ptr,"<PART",5)==0) {
	    //ptStart = getval(ptr,"start");
	    //ptEnd   = getval(ptr,"end");
	    ptOffset = getval(ptr,"offset");
	    pt = tr->addPart(KbPosition(ptOffset));
	    GET; ptr=line; while (ptr[0]==' ') ptr++;
	    while(strncmp(ptr,"</PART>",7)!=0) {
	      if (strncmp(ptr,"<OPTIONS",8)==0) {
		ptClef = getval(ptr,"clef");     pt->sClef(ptClef);
		ptMeter0 = getval(ptr,"meter0"); pt->sTime1(ptMeter0);
		ptMeter1 = getval(ptr,"meter1"); pt->sTime2(ptMeter1);
		ptKey = getval(ptr,"key");       pt->sKey(ptKey);
		ptPrg = getval(ptr,"program");   pt->sProgram(ptPrg);
	      } else if (strncmp(ptr,"<NOTE",5)==0) {
		ntPitch = getval(ptr,"pitch");
		ntVel = getval(ptr,"vel");
		ntLen = getval(ptr,"len");
		ntPos = getval(ptr,"pos");
		ntEnh = getval(ptr,"enh");
		ntChn = getval(ptr,"chan");
		// pt->addNote(new KbNote(ntPitch,ntVel,ntLen,ntPos,ntEnh,ntChn));
		nt = new KbNote(ntPitch,ntVel,ntLen,ntPos,ntEnh,ntChn);
		pt->addNote(nt);
		GET; ptr=line; while (ptr[0]==' ') ptr++;
		while(strncmp(ptr,"</NOTE>",7)!=0) {
		    if (strncmp(ptr,"<LYRICS",7)==0) {
		      ntWord = getstrval(ptr,"word");
		      nt->appendExt(new KbLyrics(nt,ntWord));
		    } else if (strncmp(ptr,"<STEM",5)==0) {
		      ntStem = getval(ptr,"dir");
		      nt->appendExt(new KbStem(nt,ntStem));
		    } else if (strncmp(ptr,"<EXP",4)==0) {
		      ntExp = getval(ptr,"expression");
		      ntExpOff = getval(ptr,"offset");
		      nt->appendExt(new KbExp(nt,ntExp,ntExpOff));
		    } else if (strncmp(ptr,"<BOW",4)==0) {
		      ntBow = getval(ptr,"length");
		      ntBowDir = getval(ptr,"dir");
		      ntBowDelta = getval(ptr,"delta");
		      nt->appendExt(new KbBow(nt,ntBow,ntBowDir,ntBowDelta));
		    }
		  GET; ptr=line; while (ptr[0]==' ') ptr++;
		} // note end
	      } else if (strncmp(ptr,"<MASTER",7)==0) {
		mtPos = getval(ptr,"pos");
		mtTempo = getval(ptr,"tempo");
		mtMeter0 = getval(ptr,"meter0");
		mtMeter1 = getval(ptr,"meter1");
		if (mtMeter1==0) pt->addAtom(new KbMasterEvent(mtPos,mtTempo));
		else pt->addAtom(new KbMasterEvent(mtPos,mtMeter0,mtMeter1));
	      } else if (strncmp(ptr,"<MIDI",5)==0) {

	      } else if (strncmp(ptr,"<WAVE",5)==0) {
		wavPos = getval(ptr,"pos");
		wavName = getstrval(ptr,"filename");
		pt->addAtom(new KbWaveEvent(wavPos,wavName));
	      } else if (strncmp(ptr,"<TEXT",5)==0) {
		auxWord = getstrval(ptr,"text");
		auxPos = getval(ptr,"pos");
		auxYoff = getval(ptr,"offset");
		pt->addAtom(new KbText(auxPos,auxWord,auxYoff));
	      } else if (strncmp(ptr,"<SYMBOL",7)==0) {
		auxSymbol = getval(ptr,"symbol");
		auxPos = getval(ptr,"pos");
		auxYoff = getval(ptr,"offset");
		pt->addAtom(new KbSymbol(auxPos,auxSymbol,auxYoff));
	      } else if (strncmp(ptr,"<PARSYMBOL",10)==0) {
		auxSymbol = getval(ptr,"symbol");
		auxParameter = getval(ptr,"parameter");
		auxPos = getval(ptr,"pos");
		auxYoff = getval(ptr,"offset");
		pt->addAtom(new KbParSymbol(auxPos,auxSymbol,auxYoff,auxParameter));
	      }
	      GET; ptr=line; while (ptr[0]==' ') ptr++;
	    } // part end
	  }
	  GET; ptr=line; while (ptr[0]==' ') ptr++;
	} // track end
      }
      GET; ptr=line; while (ptr[0]==' ') ptr++;
    }
  }
  
  delete[] line;
  // adjustRightBorder();
  gInterface()->update();
}

void KbMain::saveKooBase(ofstream * outPtr) {
  //cout << "writing Brahms..." << endl;

  ofstream &to = *outPtr;

  KbTrack * tr = 0;
  KbMasterTrack * mtr = 0;
  KbScoreTrack * str = 0;
  KbDrumTrack * dtr = 0;
  KbWaveTrack * wtr = 0;
  KbCommentTrack * ctr = 0;

  tNum=0; for (tr=gTrack();tr!=0;tr=tr->gNext()) { tNum++; }
  tr = gTrack();
  KbPart * pt; KbAtom * c;
  int type = 0;
  to << "<?XML version=\"1.0\"?>" << endl;
  to << "<!DOCTYPE Brahms SYSTEM \"Brahms.dtd\">" <<endl;
  to << "<DOCUMENT version=\"" << VERSION << "\">" << endl;
  to << "<HEAD tempo=\"" << gTempo() << "\"";
  to << " meter0=\"" << gMeter(0) << "\"";
  to << " meter1=\"" << meter1 << "\"";
  to << " tracks=\"" << tNum << "\"";
  to << " />" << endl;
  // DOIT: progressbar->setTotalSteps(tNum);
  for (tr=gTrack();tr!=0;tr=tr->gNext()) {
    // progressbar->setProgress(i+1);
    // TRACK
    type = tr->isA();
    to << "<TRACK type=\"" << type << "\"";
    to << " name=\"" << tr->gName() << "\"";
    to << " mute=\"" << tr->gToggle(0) << "\"";
    to << " lock=\"" << tr->gToggle(1) << "\" >" << endl;
    switch (type) {
    case 0:
      str = (KbScoreTrack*) tr;
      to << "<OPTIONS";
      to << " program=\"" << str->gProgram() << "\"";
      to << " channel=\"" << str->gChannel() << "\"";
      to << " output=\"" << str->gOutput() << "\"";
      to << " volume=\"" << str->gVolume() << "\"";
      to << " delay=\"" << str->gDelay() << "\" />" << endl;
      break;
    case 1:
      dtr = (KbDrumTrack*) tr;
      to << "<OPTIONS";
      to << " program=\"" << dtr->gProgram() << "\"";
      to << " channel=\"" << dtr->gChannel() << "\"";
      to << " output=\"" << dtr->gOutput() << "\"";
      to << " volume=\"" << dtr->gVolume() << "\"";
      to << " delay=\"" << dtr->gDelay() << "\" />" << endl;
      break;
    case 2:
      break;
    case 3:
      break;
    case 4:
      break;
    }
    // PARTS
    pt = tr->gPart();
    while (pt!=0) {
      to << "<PART offset=\"" << pt->gOffset().gPosTicks() << "\" >" << endl; // start=\"" << pt->gFrom() << "\" end=\"" << pt->gTo() << "\" >" << endl;
      to << "<OPTIONS clef=\"" << pt->gClef() << "\"";
      to << " meter0=\"" << pt->gTime1() << "\"";
      to << " meter1=\"" << pt->gTime2() << "\"";
      to << " key=\"" << pt->gKey() << "\"";
      // to << pt->trAdr->channel << endl;
      to << " program=\"" << pt->gProgram() << "\" />" << endl;
      // to << pt->name << endl;
      
      for (c=pt->gFirstAtom();c!=0;c=c->gNext())
	to << *c;
      /*
	{
	  to << c->gFreq() << endl;
	  to << c->gVel() << endl;
	  to << c->gLen() << endl;
	  to << c->gPos() << endl;
	  to << c->gEnh() << endl;
	}
      */
      to << "</PART>" << endl;
      pt = pt->gNext();
      // to << -2 << endl; // part end
    }
    to << "</TRACK>" << endl;
    // to << -1 << endl; // track end
  }
  to << "</DOCUMENT>" << endl;
  to.close();
}

void KbMain::clear() {
  KbTrack * t;
  KbTrack * t1;
  t = track;
  while (t!=0) {
    if (t->gNext()==0) { delete t; t = 0; }
    else { t1 = t; t = t->gNext(); delete t1; }
  }
  track = 0;
}



bool KbMain::gBeepFlag() {
  return beepFlag;
}

bool KbMain::gBeepMidi() {
  return beepMidi;
}

int KbMain::gClickInst() {
  return clickInst;
}

int KbMain::gClickVol() {
  return clickVol;
}
  
int KbMain::gPreBeats() {
  return preBeats;
}


void KbMain::sBeepFlag(bool b) { beepFlag = b; }

void KbMain::sBeepMidi(bool b) { beepMidi = b; }

void KbMain::sClickInst(int i) { clickInst = i; }

void KbMain::sClickVol(int i) { clickVol = i; }

void KbMain::sPreBeats(int i) { preBeats = i; }

void KbMain::sPlayWait(bool b) { playWait = b; }

KbExtensionManager * KbMain::extManager() { return extMan; }

#ifdef HAVE_ARTS
Arts::Synthesizer_var KbMain::synthesizer;
CORBA::ORB_var KbMain::orb;
CORBA::BOA_var KbMain::boa;
#endif

#endif
