#ifndef _KBDRUMTRACK_C_
#define _KBDRUMTRACK_C_

#include "kbDrumTrack.h"

class KbMain;


KbDrumTrack::KbDrumTrack( KbMain * kbMain )
  : KbTrack(kbMain,1), channel(0), program(0), output(0), volume(0), transpose(0), delay(0)
{
  output = kbMain->gNumberOfDevices()-1;
  ifTrack = kbMain->gFactory()->createDrumTrack(this);
}

int KbDrumTrack::gChannel() { return channel; }

void KbDrumTrack::sChannel(int n) { channel = n; }

int KbDrumTrack::gProgram() { return program; }

void KbDrumTrack::sProgram(int n) { program = n; }

int KbDrumTrack::gOutput() { return output; }

void KbDrumTrack::sOutput(int n) { output = n; main->closeDev(); }

int KbDrumTrack::gVolume() { return volume; }

void KbDrumTrack::sVolume(int n) { volume = n; }

int KbDrumTrack::gTranspose() { return transpose; }

void KbDrumTrack::sTranspose(int n) { transpose = n; }

int KbDrumTrack::gDelay() { return delay; }

void KbDrumTrack::sDelay(int n) { delay = n; }

bool KbDrumTrack::gToggle(int i) { return toggle[i]; }

void KbDrumTrack::sToggle(int i, bool n) { toggle[i] = n; }

#endif
