#ifndef _KBBOW_H_
#define _KBBOW_H_

#include "kbNoteExt.h"
class KbNote;

/**
 * Objects of this class are bows. They do not need a (graphical) presentation of their own. They can be displayed
 * graphically within the presentation of the parts, they belong to. This is done in editors.
 * @short Bow Class
 * @author Jan Wuerthner
 * @version 0.97
 */

enum { BowUp, BowDown };

class KbBow : public KbNoteExt
{
 private:
  int length;
  int dir;
  int delta;

 public:
  KbBow(KbNote*,int);
  KbBow(KbNote*,int,int);
  KbBow(KbNote*,int,int,int);
  void flip();
  int gLength();
  int gDir();
  bool isUp();
  bool isDown();
  int gDelta();
  void sLength(int);
  void sDir(int);
  void sUp();
  void sDown();
  void sDelta(int);
  // virtual KbNoteExt * gNext();
  virtual bool isLyrics();
  virtual bool isStem();
  virtual bool isExp();
  virtual bool isBow();
  virtual ostream & print(ostream&);
  virtual KbNoteExt * copy();
};


#endif
