// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "IsoWindow.h"
#include "IsoImage.h"
#include "IsoFile.h"
#include "FileTree.h"
#include "LineDialog.h"

#include <qlayout.h>
#include <qpushbutton.h>
#include <qfileinfo.h>

#include <kconfig.h>
#include <kapp.h>
#include <klocale.h>


extern KLocale *locale;


ISOWindow::ISOWindow( QWidget *parent, const char *name,ISOImage *isoimage):QWidget(parent,name)
 {
  KConfig *config;
  QRect DefaultRect(0,50,640,300);
  QHBoxLayout *winlayout,*botlayout;
  QVBoxLayout *leftlayout;
  QVBoxLayout *rightlayout;
  QHBoxLayout *leftbuttons;
  QHBoxLayout *rightbuttons;
  QVBoxLayout *toplayout;

  QPushButton *okButton,*cancelButton;

  isoImage=isoimage;
#if QT_VERSION >= 200
  config=kapp->config();
#else
  config=kapp->getConfig();
#endif
  setCaption(locale->translate("KreateCD - ISO tree window"));

  toplayout=new QVBoxLayout(this);
  winlayout=new QHBoxLayout(0);
  toplayout->addLayout(winlayout,10);
  toplayout->addStretch(1);

  botlayout=new QHBoxLayout(0);
  toplayout->addLayout(botlayout,1);
  botlayout->addSpacing(5);
  botlayout->addStretch(1);
  okButton=new QPushButton(locale->translate("OK"),this);
  okButton->setFixedSize(okButton->sizeHint());
  botlayout->addWidget(okButton,0,AlignCenter);
  botlayout->addStretch(1);
  cancelButton=new QPushButton(locale->translate("Cancel"),this);
  cancelButton->setFixedSize(cancelButton->sizeHint());
  botlayout->addWidget(cancelButton,0,AlignCenter);
  botlayout->addStretch(1);
  botlayout->addSpacing(5);

  leftlayout=new QVBoxLayout();
  winlayout->addLayout(leftlayout,20);
  winlayout->addStretch(1);
  rightlayout=new QVBoxLayout();
  winlayout->addLayout(rightlayout,20);

  sourceTree=new FileTree(this);
  sourceTree->setMinimumSize(200,200);
  leftlayout->addWidget(sourceTree,20);

  isoTree=new FileTree(this);
  isoTree->setMinimumSize(200,200);
  rightlayout->addWidget(isoTree,20);

  leftlayout->addStretch(2);
  leftlayout->addSpacing(5);
  rightlayout->addStretch(2);
  rightlayout->addSpacing(5);

  leftbuttons=new QHBoxLayout();
  leftlayout->addLayout(leftbuttons);
  rightbuttons=new QHBoxLayout();
  rightlayout->addLayout(rightbuttons);

  // setup left buttons

  leftbuttons->addStretch(1);
  addButton=new QPushButton(locale->translate("Add"),this);
  addButton->setFixedSize(addButton->sizeHint());
  leftbuttons->addWidget(addButton);
  connect(addButton,SIGNAL(clicked()),this,SLOT(addFile()));
  leftbuttons->addStretch(1);

  // setup right buttons

  rightbuttons->addStretch(1);
  createDirButton=new QPushButton(locale->translate("Create dir"),this);
  createDirButton->setFixedSize(createDirButton->sizeHint());
  rightbuttons->addWidget(createDirButton);
  connect(createDirButton,SIGNAL(clicked()),this,SLOT(createDir()));
  rightbuttons->addStretch(1);
  deleteButton=new QPushButton(locale->translate("Delete"),this);
  deleteButton->setFixedSize(deleteButton->sizeHint());
  rightbuttons->addWidget(deleteButton);
  connect(deleteButton,SIGNAL(clicked()),this,SLOT(deleteObject()));
  rightbuttons->addStretch(1);


  // setup file trees

   {
    QFileInfo *kfi;
    kfi=new QFileInfo("/");
    sourceTree->addDir(kfi);
    delete(kfi);
   }
  isoTree->addDir(isoImage->imageRoot());

  config->setGroup("Geometry");
  this->setGeometry(config->readRectEntry("ISOWindowGeo",&DefaultRect));
  toplayout->activate();

  connect(okButton,SIGNAL(clicked()),this,SLOT(hide()));
  connect(cancelButton,SIGNAL(clicked()),this,SLOT(cancelPressed()));
  backupTree=new ISOFile (*(isoImage->imageRoot()));
 }


void ISOWindow::hide()
 {
  emit closed();
 }

ISOWindow::~ISOWindow(void)
 {
  KConfig *config;
  QRect SaveRect(this->pos(),this->size());
#if QT_VERSION >= 200
  config=kapp->config();
#else
  config=kapp->getConfig();
#endif
  config->setGroup("Geometry");
  config->writeEntry("ISOWindowGeo",SaveRect);
  delete backupTree;
 }
  
void ISOWindow::addFile(void)
 {
  QString filename;
  if (!sourceTree->getSelected(&filename)) return;
  if (!isoTree->addRealObject(&filename)) return;
  emit(imageChanged());
 }

void ISOWindow::createDir(void)
 {
  LineDialog *lidi;
  const char *dirname;
  lidi=new LineDialog(this);
  lidi->exec();
  dirname=lidi->getInput();
  if (dirname[0]==0)
   {
    delete(lidi);
    return;
   }
  isoTree->createISODir(dirname);
  delete(lidi);
  emit(imageChanged());
 }

void ISOWindow::deleteObject(void)
 {
  isoTree->deleteObject();
 }

void ISOWindow::cancelPressed(void)
 {
  isoImage->setImageRoot(backupTree);
  hide();
 }
