// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include <qwidget.h>

#include "BusScanner.h"

class ConfSCSI : public QWidget
 {
  Q_OBJECT;
  
 
  public:
    ConfSCSI( QWidget *parent=0, const char *name=0);
    ~ConfSCSI(void);
    void hide(void);
 
  signals:
    void closed(void);


  protected slots:
         void clickedWriter(int unit);
         void clickedCDROM(int unit);
         void applySettings(void);
         void okButton(void);
         void cancelButton(void);

         void updateWriterButtons(void);
         void updateCdromButtons(void);
         void changedWriterHost(int host);
         void changedCdromHost(int host);

  private:

    class QButtonGroup *scsiboxes[2];
    class QRadioButton *scsibuttons[2][MAX_SCSI_UNITS];
    class QPushButton  *okbutton;
    class QPushButton  *applybutton;
    class QPushButton  *cancelbutton;

    class QSpinBox   *writerhostspin;
    class QSpinBox   *cdromhostspin;

    class BusScanner  *SCSIBus;

    char scsidevs[MAX_SCSI_HOSTS][MAX_SCSI_UNITS][32];
    


    int cdrom_id;
    int writer_id;
    int cdrom_host;
    int writer_host;



 };


