// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "AudioPlayImage.h"
#include "AudioFile.h"

#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <unistd.h>
#include <fcntl.h>

#include <qtimer.h>
#include <qobject.h>
#include <klocale.h>

extern KLocale *locale;

AudioPlayImage::AudioPlayImage(AudioFile *afil):AudioFileConvert(afil,playImageHFork,"/dev/dsp")
 {
  AudioTimer=0;
 }


AudioPlayImage::~AudioPlayImage(void)
 {
   if (AudioTimer) stopAudio();
  }

void AudioPlayImage::playAudio(long int position)
 {
  if (AudioTimer) return;

  prepareProcess();
  AudioTimer=new QTimer();
  AudioTimer->start(80,FALSE);
  connect(AudioTimer,SIGNAL(timeout()),this,SLOT(playAudioTrigger()));
  ImagizeFlag=0;
  AudioPosition=0;
  startAudio=position;

  startProcess(false,false);
 }

int AudioPlayImage::processExited(void)
 {
  delete(AudioTimer);
  AudioTimer=0;
  return(1);
 }

void AudioPlayImage::playAudioTrigger(void)
 {
  AudioPosition+=6;
  emit(audioPlayPosition(AudioPosition));
 }

void AudioPlayImage::setAudioPosition(int frame)
 {
  if (AudioTimer==0) return;
  if (AudioPosition==frame) return;
  AudioPosition=frame;
  emit(audioPlayPosition(AudioPosition));
  sprintf(OutLine,"#SET# %ld\n",AudioPosition);
  writeStdin(OutLine,strlen(OutLine));
 }


void AudioPlayImage::setAudioBoost(float boost)
 {
  if (AudioTimer==0) return;
  sprintf(OutLine,"#BOOST# %f\n",boost);
  writeStdin(OutLine,strlen(OutLine));
 }

void AudioPlayImage::setAudioBalance(float balance)
 {
  if (AudioTimer==0) return;
  sprintf(OutLine,"#BALANCE# %f\n",balance);
  writeStdin(OutLine,strlen(OutLine));
 }

bool AudioPlayImage::processStdoutLine(char *linebuffer)
 {
  if (strncmp("#PROGRESS#",linebuffer,10)==0)
   {
    char *xptr,*yptr;
    unsigned long int cur;
    xptr=linebuffer+10;
    while (*xptr==' ') ++xptr;
    if (*xptr==0) return(true);
    cur=strtoul(xptr,&yptr,10);
    AudioPosition=cur;
    emit(audioPlayPosition(cur));
   }
  return(true);
 }


void AudioPlayImage::stopAudio(void)
 {
  closeProcess();
  if (AudioTimer) delete (AudioTimer);
  AudioTimer=0;
 }



int AudioPlayImage::playImageHFork(AudioFileOp *afi,const char *fn)
 {
  ((AudioPlayImage *)(afi))->buildImageFork(fn,1);
  return(0);
 }
