// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifndef AUDIOFILEOP_INCLUDED
#define AUDIOFILEOP_INCLUDED

#include "ProcessInterface.h"
#include "AudioFile.h"
#include <qobject.h>

#include <unistd.h>

class AudioFileOp : public ProcessInterface
 {
   Q_OBJECT
   public:
    AudioFileOp(AudioFile *afil);
    AudioFileOp(AudioFile *afil,int (*fx)(AudioFileOp *afi,const char *fn),const char *fnx);
    ~AudioFileOp(void);

   protected:
    static const int Read_Cachesize=1024;
    static const int Write_Cachesize=1024;

    int  openWrite(const char *wfilename);
    void closeWrite(void);
    int  positionSample(long int sample);

    int  readLEShort (long int  *mshort,int words=1);
    int  readLELong  (long int  *mlong,int words=1);
    int  readBEShort (long int  *mshort,int words=1);
    int  readBELong  (long int  *mlong,int words=1);
    int  readChar    (long int  *mchar,int words=1);
    int  readCharUS  (long int  *mchar,int words=1);
    int  readShort   (long int  *mshort,int words=1);
    int  readLong    (long int  *mlong,int words=1);
    int  skipRead    (int        bytes);
    int  flushCDDABuffer(void);

    int  openRead    (const char*mfilename);
    void closeRead   (void);
    int  fillSampleBuffer(void);

    int                          AudioFD;
    int                          AudioCached;
    long int                     AudioPos;
    int                          AudioPointer;
    long int                    *AudioBuffer;
    unsigned char               *ReadBuffer;

    int                          ImageFD;
    int                          ImageContent;
    unsigned char               *ImageBuffer;
    int                          DisableSwap;

    AudioFile           *myAudio;

    int                          ImagizeFlag;

    char                         OutLine[64];
    char                         linebuffer[256];

    inline int readString(char *mstring,int length)
     {
      if (read(AudioFD,mstring,length)!=length) return(0);
      return(1);
     }

    inline int readSample(long int *sample)
     {
      if (AudioCached<=AudioPointer)
       {
        if (!fillSampleBuffer()) return(0);
       }
      *sample=AudioBuffer[AudioPointer++];
      return(1);
     }

    inline int writeCDDASample(float msample)
     {
      long int xsample;

      xsample=(long int )msample;

      if (ImageContent>=Write_Cachesize)
       {
        if (!flushCDDABuffer()) return(0);
       }

      if (xsample>32767) xsample=32767;
      if (xsample<-32768) xsample=-32768;

      if (DisableSwap)
       {
        *(short int *) (ImageBuffer+2*ImageContent)=xsample;
        ++ImageContent;
        return(1);
       }

#ifdef WORDS_BIGENDIAN
      *(short int *) (ImageBuffer+2*ImageContent)=xsample;
#else
      ImageBuffer[2*ImageContent]= (xsample>>8) & 0xff;
      ImageBuffer[2*ImageContent+1]= xsample & 0xff;
#endif
      ++ImageContent;
      return(1);
     }
 };
#endif

