// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include <qobject.h>

class KProcess;

class AudioFile : public QObject
 {
  Q_OBJECT;

  public:
    enum Sample_Endian{Endian_Little,Endian_Big};
    enum Sample_Format{Samples_PCM};
    enum Sample_Size{Samples_8Bit,Samples_16Bit,Samples_32Bit};

    AudioFile(void);
    ~AudioFile(void);
    int  identifyFile(const char *filename);
    int  setupCDTrack(const char *filename);
    int getSelectedDuration(void);
    int getAbsoluteDuration(void);

    float getBoost(void);
    float getBalance(void);
    long int getStartPos(void);
    long int getEndPos(void);
    void setStartPos(long int pos);
    void setEndPos(long int pos);
    void setBoost(float boost);
    void setBalance(float balance);
    void setMaxBoost(void);


    enum Sample_Endian   getEndian(void);
    enum Sample_Size     getSampleSize(void);
    int                  getChannels(void);
    long int             getSampleRate(void);
    void                 getFormat(char *formatstring);
    int                  needImage(void);
    int                  buildImage(const char *fn);
    int                  scanImage(void);

    int      buildImageFork(const char *fn,int playmode);
    float    maximumBoost(const char *fn);

  signals:
    void                 audioPlayPosition(int block);

  public slots:
    void                 playAudio(long int position=-1);
    void                 stopAudio(void);
    void                 setAudioPosition(int frame);
    void                 setAudioBoost(float boost);
    void                 setAudioBalance(float balance);

  private slots:

    void buildImageExit(KProcess *);
    void buildImageMsg(KProcess *,char *buf,int len);

    void scanImageExit(KProcess *);
    void scanImageMsg(KProcess *,char *buf,int len);

    void playAudioMsg(KProcess *,char *buf,int len);
    void playAudioExit(KProcess *);
    void playAudioTrigger(void);


  private:
    static const int Read_Cachesize=1024;
    static const int Write_Cachesize=1024;

    int      identifyMSWave(void);

    int  openWrite(const char *wfilename);
    int  writeCDDASample(float msample);
    int  flushCDDABuffer(void);
    void closeWrite(void);

    int  readLEShort (long int  *mshort,int words=1);
    int  readLELong  (long int  *mlong,int words=1);
    int  readBEShort (long int  *mshort,int words=1);
    int  readBELong  (long int  *mlong,int words=1);
    int  readChar    (long int  *mchar,int words=1);
    int  readCharUS  (long int  *mchar,int words=1);
    int  readShort   (long int  *mshort,int words=1);
    int  readLong    (long int  *mlong,int words=1);
    int  readString  (char      *mstring,int length);
    int  skipRead    (int        bytes);

    int  openRead    (const char*mfilename);
    void closeRead   (void);

    int  positionSample(long int sample);
    int  readSample(long int  *sample);
    int  fillSampleBuffer(void);



    int                          AudioFD;
    int                          AudioCached;
    long int                     AudioPos;
    int                          AudioPointer;
    long int                    *AudioBuffer;
    unsigned char               *ReadBuffer;

    int                          ImageFD;
    int                          ImageContent;
    unsigned char               *ImageBuffer;
    int                          DisableSwap;
    long int                     AudioPosition;


    enum Sample_Endian           SampleEndian;
    enum Sample_Format           SampleFormat;
    int                          SampleChannels;
    enum Sample_Size             SampleSize;
    long int                     SampleRate;
    int                          SampleBytes;
    long int                     DataPos;
    long int                     DataSize; 
    long int                     DataSamples;
    long int                     SelectedStart;
    long int                     SelectedEnd;

    float                        BoostFactor;
    float                        Balance;
    float                        MaxBoost;

    char                         Format[16];
    char                         FileName[1024];

    class ProgressDialog        *ImagizeDialog;
    int                          ImagizeFlag;

    char                         linebuffer[64];

    class Fork                  *AudioFork;
    class QTimer                *AudioTimer;
    long int                     startAudio;

    char                         OutLine[64];


 }; 


