/***************************************************************************
                          setup.cpp  -  description
                             -------------------
    begin                : Sat Mar 3 2001
    copyright            : (C) 2001 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/

#include <stdio.h>

#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlabel.h>

#include <kconfig.h>
#include <kapp.h>

#include "setup.h"
#include "cddata.h"

Setup::Setup(QWidget *parent, const char *name ) : Setup_GUI(parent,name) {

// Read the CD-Devices and added them to the ComboBoxes
	const char* arr[4];
	char buf[256];
	CDdata *CD = new CDdata;

	QComboBox_cdwriterdev->clear();

	for( int i = 0; ! CD -> getDev( i, &arr ); i++ ) {
		sprintf( buf, "%s %s", arr[0],arr[1] );
		QComboBox_cdwriterdev -> insertItem( buf, i );
	}

	QComboBox_cdreaderdev->clear();

	for( int i = 0; ! CD -> getDev( i, &arr ); i++ ) {
		sprintf( buf, "%s %s", arr[0],arr[1] );
		QComboBox_cdreaderdev -> insertItem( buf, i );
	}

	QComboBox_cdreaderdev -> insertItem( "ATAPI CD-ROM ( /dev/cdrom )" );

	//Read config and display them into the ComboBoxes
	KConfig* config = kapp->config();

	config->setGroup("CD-Writer");
	QComboBox_cdwriterdev->setCurrentItem( config->readNumEntry("Index") );
	QCheckBox_BurnProof->setChecked( config->readNumEntry("BurnProof") );

	config->setGroup("CD-Reader");
	QComboBox_cdreaderdev->setCurrentItem( config->readNumEntry("Index") );
}

Setup::~Setup(){
}

// 'Save-Button' clicked
void Setup::slot_save(){
	KConfig* config = kapp->config();
	CDdata *CD = new CDdata;

	//Save settings for CD-Writer
	config->setGroup("CD-Writer");
	config->writeEntry("Name", QComboBox_cdwriterdev->currentText());
	config->writeEntry("Device", CD->getDevStr( QComboBox_cdwriterdev->currentItem() ));
	config->writeEntry("Index", QComboBox_cdwriterdev->currentItem());
	config->writeEntry("isRW", CD->isRW( QComboBox_cdwriterdev->currentItem() ));
	config->writeEntry("BurnProof", QCheckBox_BurnProof->isChecked() );

	//Save settings for CD-Reader
	config->setGroup("CD-Reader");
	config->writeEntry("Name", QComboBox_cdreaderdev->currentText());
	config->writeEntry("Device", CD->getDevStr( QComboBox_cdreaderdev->currentItem() ));
	config->writeEntry("Index", QComboBox_cdreaderdev->currentItem());

	if ( config->readEntry("Device") == "dev=0,0,0" ) config->writeEntry("Device", "/dev/sr0");
	if ( config->readEntry("Device") == "dev=0,1,0" ) config->writeEntry("Device", "/dev/sr1");
	if ( config->readEntry("Device") == "dev=0,2,0" ) config->writeEntry("Device", "/dev/sr2");
	if ( config->readEntry("Device") == "dev=0,3,0" ) config->writeEntry("Device", "/dev/sr3");
	if ( config->readEntry("Device") == "dev=0,4,0" ) config->writeEntry("Device", "/dev/sr4");
	if ( config->readEntry("Device") == "dev=0,5,0" ) config->writeEntry("Device", "/dev/sr5");
	if ( config->readEntry("Device") == "dev=0,6,0" ) config->writeEntry("Device", "/dev/sr6");
	if ( config->readEntry("Device") == "dev=0,7,0" ) config->writeEntry("Device", "/dev/sr7");
	if ( config->readEntry("Name") == "ATAPI CD-ROM ( /dev/cdrom )" ) config->writeEntry("Device", "/dev/cdrom");

 	close( true );
}

// 'Exit-Button' clicked
void Setup::slot_quit(){
	close( true );
}
