#include "tools.h"

extern int         debuglevel;
extern t_debugFile debugFile; 

t_debugFile::t_debugFile(string dir = "", string name = "")
{
  myDir = dir;
  myBaseName = name;
  fileOpen = false;
}

t_debugFile::~t_debugFile()
{
  if (fileOpen) myFile.close();
}

void t_debugFile::setDirName(string dir, string name)
{
  myDir = dir;
  myBaseName = name; 
}

int t_debugFile::createFile()
{
  string pfad = getNrFile(myDir, myBaseName);
  myFile.open(pfad.c_str());
  fileOpen = true;
  if (!myFile) return(1);
  else return(0);
}

int t_debugFile::newFile()
{
  if (fileOpen) 
    {
      myFile.close();
      fileOpen = false;
    }
  return(0);
}

int t_debugFile::newSection(string title = "")
{
  int retCode = 0;

  if (!fileOpen) retCode = createFile();
  if (retCode) return(retCode);
  if (title == "")
    myFile << "------------------------ new section ----------------------------\n";
  else 
    myFile << "------------------------ new section: " << title << " ----------------------------\n";
  return(0);
}

int t_debugFile::output(string aString)
{
  int retCode = 0;

  if (!fileOpen) retCode = createFile();
  if (retCode) return(retCode);
  myFile << aString << "\n";
  return(0);
}

int t_debugFile::appendFile(string filename)
{
  ifstream  inFile;
  int       retCode = 0;
  char      c;
  
  if (!fileOpen) retCode = createFile();
  if (retCode) return(retCode);
  
  inFile.open(filename.c_str());
  if (!inFile) return(1);
  while ((c = inFile.get()) != EOF) myFile << c;
  inFile.close();
  return(0);
}

void getSysInfo(string pfad)
{
  string befehl;
  string catbefehl;
  string befehle[] = {"mount", "uname -mrspv", "echo $HOME", "which kisocd", 
		      "which kisocd.sh", "echo $KDEDIR", "echo $QTDIR", 
		      "cdrecord -scanbus", "mkisofs -v", 
		      "cat ${HOME}/.kde/share/apps/kisocd/.config"};

  
  catbefehl = "cat " + pfad + ".tmp >> " + pfad;
  for (int cnt= 0; cnt < 10; cnt++)
    {
      befehl = befehle[cnt];
      befehl += " &> " + pfad + ".tmp";      
      system(befehl.c_str());
      system(catbefehl.c_str());
      befehl = "echo --------------------------------------------------";
      befehl += " &> " + pfad + ".tmp";      
      system(befehl.c_str());
      system(catbefehl.c_str());
    }
  catbefehl = "rm " + pfad + ".tmp";
  system(catbefehl.c_str());
}

string str2Latex(string tmpStr)
{
  string tmpStr2 = "";

  for (unsigned int Cnt = 0; Cnt < tmpStr.length(); Cnt++) 
    {
      if ((tmpStr[Cnt] == '$') || (tmpStr[Cnt] == '&') || (tmpStr[Cnt] == '%') || 
	  (tmpStr[Cnt] == '#') || (tmpStr[Cnt] == '_') || (tmpStr[Cnt] == '{') || 
	  (tmpStr[Cnt] == '}')) {
	tmpStr2+= "\\";
      }
      tmpStr2 += tmpStr[Cnt];
    }
  return(tmpStr2);
}

string holStartVerz(string altVerz)
{
  if (altVerz.length() > 2)
    if (altVerz[0] == '/')
      while (altVerz[altVerz.size()-1] != '/') altVerz.replace(altVerz.size()-1,
 1, "");
    else altVerz = "";
  else altVerz = "";
  
  return(altVerz);
}

bool existDat(string DateiPfad)
{
  ifstream testDat;
//const  char     *tmp;

//  tmp = DateiPfad.c_str();
//  testDat.open(tmp);
  testDat.open((const char*)DateiPfad.c_str());
  if (!testDat) return(0); 
  else 
    { 
      testDat.close();
      return(1); 
    }
}

string dateiInhalt(string pfad)
{
  ifstream  inDat;
  char      Zeile[500];
  string    tmp = "";
  
  inDat.open(pfad.c_str());
  if (!inDat) 
    {
      pfad = i18n("Unable to open ") + pfad;
      fehlermeldung(pfad.c_str());
      return(pfad);
    }
  while (!inDat.eof())
    {
      inDat.getline(Zeile, 498);
      tmp += Zeile;
      tmp += "\n";
    }        
  inDat.close();
  return(tmp);
}

void createPathItems(QListView*     ktl, 
		     string         pfad)
{
  QListViewItem* tmp = NULL;
  string         Pfadabschnitt;
  QListViewItem* lastParent = NULL;
  bool           Abbruch = false;
  bool           firstRun = true;

  while (pfad.length() > 1) {
    Abbruch = false;

    while ((!Abbruch) && (pfad.length() > 1)) {
      if (firstRun) {
	tmp = ktl->firstChild();
	firstRun = false;
	lastParent = NULL;
      }
      else {
	lastParent = tmp;
	tmp = tmp->firstChild();
      }
      
      pfad.replace(0, 1, "");  
      Pfadabschnitt = pfad.substr(0, pfad.find("/"));
      pfad.replace(0, pfad.find("/"), "");      
      
      while ((tmp != NULL) && (Pfadabschnitt.compare(tmp->text(0)) != 0)) {
	tmp = tmp->nextSibling();
      }
      if (tmp == NULL) Abbruch = true;
    }
    if ((Abbruch) || (pfad.length() > 1)) {
      if (lastParent == NULL) tmp = new QListViewItem(ktl, Pfadabschnitt.c_str());
      else                    tmp = new QListViewItem(lastParent, Pfadabschnitt.c_str());
    }
  }
}


QString getSizeText(const char* Beschr, unsigned long Groesse)
{
  QString tmp = "";

  if (Groesse >= 10240) {
    if (Groesse >= 10485760) {
      tmp.sprintf("%lu MByte", Groesse/1048576);
    }
    else {
      tmp.sprintf("%lu kByte", Groesse/1024);
    }
  }
  else tmp.sprintf("%lu Byte", Groesse);
  tmp.insert(0, Beschr);
  return(tmp);
}

string holPfadInhalt(QListViewItem* itemPtr)
{
  // gibt den Pfad von "itemPtr" zurck, inklusive der Wurzel, Anfang
  // und Ende mit "/".

  string           tmpStr = "/";
  vector<string>   drehpuffer;
  QListViewItem*   tmpPtr;

  tmpPtr = itemPtr;

  do {
    drehpuffer.push_back(tmpPtr->text(0));
    tmpPtr = tmpPtr->parent();
  } while (drehpuffer[drehpuffer.size()-1] != "CD");
  
  while (drehpuffer.size() > 0) {
    tmpStr += drehpuffer.back();
    drehpuffer.pop_back();
    tmpStr += "/";
  }  

  cout << tmpStr << "\n";

  return(tmpStr.c_str());
}

/*
bool vergleichPfade(KPath* Pfad1, KPath* Pfad2)
{
  bool               tmp = true;
  vector<QString*>   Abschnitte1;
  vector<QString*>   Abschnitte2;
  int                Cnt1 = 0;
  int                Cnt2 = 0;
  int                Cnt;

  // Beide Pfade auslesen:
  while (!Pfad1->isEmpty()) {
    Abschnitte1.push_back(Pfad1->pop());
    Cnt1++;
  }
  Cnt1--;
  while (!Pfad2->isEmpty()) {
    Abschnitte2.push_back(Pfad2->pop());
    Cnt2++;
  }
  Cnt2--;
  // grober Vergleich:
  if (Cnt1 != Cnt2) { tmp = false; }
  else { Cnt = Cnt1; }
  // Beide Pfade restaurieren:
  while (Cnt1 >= 0) {
    Pfad1->push(Abschnitte1[Cnt1]);
    Cnt1--;
  }
  while (Cnt2 >= 0) {
    Pfad2->push(Abschnitte2[Cnt2]);
    Cnt2--;
  }
  // Jetzt im Detail vergleichen, falls es noch ntig ist:
  if (tmp) {
    while ((Cnt >= 0) && (tmp)) {
      cout << (const char*)(Abschnitte1[Cnt]) << " ?=? " << (const char*)(Abschnitte2[Cnt]) << "\n";
      if ((const char*)(Abschnitte1[Cnt]) != (const char*)(Abschnitte2[Cnt])) { tmp = false; }
      Cnt--;
    }
  }  
  return(tmp);
}

bool enthaeltPfad(KPath* Pfad1, KPath* Pfad2)
  // liefert true zurck, wenn Pfad2 in Pfad1 enthalten ist oder wenn 
  // sie gleich sind.
{
  bool               tmp = true;
  vector<QString*>   Abschnitte1;
  vector<QString*>   Abschnitte2;
  int                Cnt1 = 0;
  int                Cnt2 = 0;
  int                Cnt;
  int                diff;

  // Beide Pfade auslesen:
  while (!Pfad1->isEmpty()) {
    Abschnitte1.push_back(Pfad1->pop());
    Cnt1++;
  }
  Cnt1--;
  while (!Pfad2->isEmpty()) {
    Abschnitte2.push_back(Pfad2->pop());
    Cnt2++;
  }
  Cnt2--;
  // grober Vergleich:
  if (Cnt1 < Cnt2) { tmp = false; }
  else { 
    Cnt = Cnt2; 
    diff = Cnt1-Cnt2;
  }
  // Beide Pfade restaurieren:
  while (Cnt1 >= 0) {
    Pfad1->push(Abschnitte1[Cnt1]);
    Cnt1--;
  }
  while (Cnt2 >= 0) {
    Pfad2->push(Abschnitte2[Cnt2]);
    Cnt2--;
  }
  // Jetzt im Detail vergleichen, falls es noch ntig ist:
  if (tmp) {
    while ((Cnt >= 0) && (tmp)) {
      if ((const char*)(Abschnitte1[Cnt+diff]) != (const char*)(Abschnitte2[Cnt])) { tmp = false; }
      Cnt--;
    }
  }  
  return(tmp);
}

*/

void fehlermeldung(const char* Inhalt)
{
  int CursorMerker = int(QApplication::overrideCursor());

  if (debuglevel & 1 != 0) 
    {
      debugFile.newSection("errormessage");
      debugFile.output(Inhalt);
    }
  cerr << Inhalt;
  if (CursorMerker != 0) {
    QApplication::restoreOverrideCursor();
  }
  QMessageBox::warning(0, i18n("KisoCD: error?!?"), Inhalt);
  if (CursorMerker != 0) {
    QApplication::setOverrideCursor(CursorMerker);
  }
}

void infomeldung(const char* Inhalt)
{
  int CursorMerker = int(QApplication::overrideCursor());

  if (debuglevel & 1 != 0)
    {
      debugFile.newSection("message");
      debugFile.output(Inhalt);
    }
  cerr << Inhalt;
  if (CursorMerker != 0)
    QApplication::restoreOverrideCursor();
  QMessageBox::about(0, i18n("KisoCD: info"), Inhalt);
  if (CursorMerker != 0) 
    QApplication::setOverrideCursor(CursorMerker);
}

bool ausschlussTrifft(string Pfad, vector<string> Muster)
{
  int   flag;

  /*
  for (unsigned int Cnt= 0; Cnt < Muster.size(); Cnt++) {
    string such = Muster[Cnt];
    // nur nach Mustern, nicht nach Pfaden schauen:
    if (such[0] != '/') {

      flag = 0;

      if (such[such.size()-1] == '*') {
	flag |= 1;
	such.replace(such.size()-1, 1, "");
      }
      if (such[0] == '*') {
	flag |= 2;
	such.replace(0, 1, "");
      }
      switch (flag) {
      case 0:
	if (Pfad == such) return(true);
	break;  
      case 2:
	if (Pfad.find(such) == Pfad.size()-such.size()) return(true);
	break;
      case 1:
	if (Pfad.find(such) == 0) return(true);
	break;
      case 3:
	if (Pfad.find(such) != string::npos) return(true);
	break;
      }    
    }
  }
  return(false);
  */


  bool tmp = false;


  for (unsigned int Cnt= 0; Cnt < Muster.size(); Cnt++) {
    string such = Muster[Cnt];
    // nur nach Mustern, nicht nach Pfaden schauen:
    if (such[0] != '/') {

      flag = 0;

      if (such[such.size()-1] == '*') {
	flag |= 1;
	such.replace(such.size()-1, 1, "");
      }
      if (such[0] == '*') {
	flag |= 2;
	such.replace(0, 1, "");
      }
      if (such.size() <= Pfad.size()) {
	switch (flag) {
	case 0:
	  if (Pfad == such) tmp = true;
	  break;  
	case 2:
	  if (Pfad.find(such) == Pfad.size()-such.size()) tmp = true;
	  break;
	case 1:
	  if (Pfad.find(such) == 0) tmp = true;
	  break;
	case 3:
	  if (Pfad.find(such) != string::npos) tmp = true;
	  break;
	}    
      }
    }
    if (tmp) {
      cout << "****Treffer: " << such << "  " << Pfad << "\n";
      break;
    }
  }
  return(tmp);
}

string backslashifyWhitespace(string inputStr)
{
  unsigned int Cnt = 0;
  string tmpStr = inputStr;

  while (Cnt < tmpStr.size()-1) {
    if (tmpStr[Cnt] == ' ') {
      tmpStr.replace(Cnt++, 1, "\\ ");
    }
    Cnt++;
  }
  return(tmpStr);
}

string backslashifySpecial(string inputStr)
{
  unsigned int Cnt = 0;
  string tmpStr = inputStr;

  while (Cnt < tmpStr.size()-1) 
    {
      switch (tmpStr[Cnt])
	{
	case '\'': tmpStr.replace(Cnt++, 1, "\\'"); break;
	case '(': tmpStr.replace(Cnt++, 1, "\\("); break;
	case ')': tmpStr.replace(Cnt++, 1, "\\)"); break;
	case ' ': tmpStr.replace(Cnt++, 1, "\\ "); break;
	}
      Cnt++;
    }
  return(tmpStr);
}

string itoStr(long int nr, char fill, unsigned char digits)
{
  string  tmp = "";
  char    digit;
  int     Cnt;
  
  if (nr == 0)
    {
      for (Cnt = 0; Cnt < digits-1; Cnt++) tmp += fill;
      tmp += '0';
    }
  else 
    {
      Cnt = 0;
      while (Cnt < digits || nr != 0)
	{
	  if (nr > 0) digit = (nr % 10)+48;
	  else digit = fill;
	  
	  tmp = digit + tmp;
	  nr /= 10;
	  Cnt++;
	}
    }
  
  return(tmp);
}


string getNrPath(string root, string name)
  // ein Verzeichnis suchen, das bei "root" beginnt und "name"###
  // als Namen hat. Es darf noch nicht existieren.
{
  int     nrCnt = 0;
  string  fullPath;
  DIR*    Verz;
  bool    frei;
  
  do 
    {
      nrCnt++;
      fullPath = root + name + itoStr(nrCnt, '0', 3);
      Verz = opendir(fullPath.c_str());
      frei = (Verz == NULL);
      if (!frei) closedir(Verz);
    }
  while (!frei && (nrCnt < 1000));
  
  
  if (nrCnt == 1000) return("");
  else return(fullPath); 
}

string getNrFile(string root, string name)
  // eine Datei suchen, das bei "root" beginnt und "name"###
  // als Namen hat. Sie darf noch nicht existieren.
{
  int     nrCnt = 0;
  string  fullPath;
  
  do 
    {
      nrCnt++;
      fullPath = root + name + itoStr(nrCnt, '0', 3);
    }
  while (existDat(fullPath) && (nrCnt < 1000));
    
  if (nrCnt == 1000) return("");
  else return(fullPath); 
}

int close_ofs(ofstream &outDat)
  // todo: prfen, ob es am Platz lag oder woran auch sonst immer...
{
  int retcode = 0;
  
  if (!outDat)
    {
      string dateiPfad;
      string befehl = "df ~ &> ";

      dateiPfad = getNrFile("/tmp/", "kisocd");              
      befehl += dateiPfad;
      if (!system(befehl.c_str())) 
	{
	  befehl = dateiInhalt(dateiPfad);      
	  if (befehl.find("100%") != string::npos)
	    fehlermeldung(i18n("An error occured when writing to a file.\n"
			  "Seems there is no space left in your home-directory."));
	}
      else 
	fehlermeldung(i18n("An error occured when writing to a file."));
      unlink(dateiPfad.c_str());
      
      retcode = 1;
    }

  outDat.close(); 
  return(retcode);
}

void dumpOptions(T_Options opts)
{
  cout << "  IDdisc: " << opts.IDdisc;
  cout << "\n  IDvolume: " << opts.IDvolume;
  cout << "\n  IDpreparer: " << opts.IDpreparer;
  cout << "\n  IDpublisher: " << opts.IDpublisher;

  if (opts.fCreateImage) cout << "\n  Createimage true";
  else cout << "\n  Createimage false";

  if (opts.fDummyWrite) cout << "\n  fDummyWrite true";
  else cout << "\n  fDummyWrite false";
  if (opts.fPadTrack) cout << "\n  fPadTrack true";
  else cout << "\n  fPadTrack false";
  if (opts.fbootCD) cout << "\n  fbootCD true";
  else cout << "\n  fbootCD false";

  cout << "\n  bootImagePath: " << opts.bootImagePath;

  if (opts.fMulti) cout << "\n  fMulti true";
  else cout << "\n  fMulti false";
  if (opts.fMultiFirstSess) cout << "\n  fMultiFirstSess true";
  else cout << "\n  fMultiFirstSess false";
  if (opts.fMultiLastSess) cout << "\n  fMultiLastSess true";
  else cout << "\n  fMultiLastSess false";
  cout << "\n";
}

string whereisExec(string name)
{
  string dateiPfad;
  string befehl = "which " + name + " &> ";

  dateiPfad = getNrFile("/tmp/", "kisocd");  
  befehl += dateiPfad;
  if (!system(befehl.c_str()))
    {
      befehl = dateiInhalt(dateiPfad);
      while (befehl[befehl.length()-1] == '\n') 
	befehl.replace(befehl.length()-1, 1, "");
    }
  else befehl = "";
  unlink(dateiPfad.c_str());
  return(befehl);
}

int execKFM(string startDir)
  // Rckgabewert:
  //   0 wenn es offensichtlich geklappt hat
  //   1 wenn was schief ging
{
  /*
  bool kfmRunning = false; 

  string tmpBef = "ps | grep \"kfm\" &> ";
  string tmpPfad = getNrFile("/tmp/", "kisocd");

  tmpBef += tmpPfad;
  if (system(tmpBef.c_str())) 
    {
      tmpBef = "error executing basic command:\n" + tmpBef;
      fehlermeldung(tmpBef.c_str());
      return(1);
    }
  
  tmpBef = dateiInhalt(tmpPfad);
  unlink(tmpPfad.c_str());

  while (tmpBef.find("kfm") != string::npos && kfmRunning == false)
    {
      if ((tmpBef.find("kfm") != string::npos && tmpBef.find("\"kfm\"") != string::npos &&
	   (tmpBef.find("kfm") != (tmpBef.find("\"kfm\"")+1))) ||
	  (tmpBef.find("kfm") != string::npos && tmpBef.find("\"kfm\"") == string::npos)) kfmRunning = true;
      if (tmpBef.find("\n") != string::npos)
	{
	  while (tmpBef[0] != '\n') tmpBef.replace(0, 1, "");
	  tmpBef.replace(0, 1, "");
	}
      else tmpBef = "";
    }
  
  if (kfmRunning)
    {
      cout << "kfmclient exec file:\n";
      tmpBef = "kfmclient exec file:";
      tmpBef += startDir;
      if (system(tmpBef.c_str())) return(1);
      else return(0);
    }
  else
    {
      cout << "kfm -sw exec file:\n";
      tmpBef = "kfm -sw exec file:";
      tmpBef += startDir;
      tmpBef += " &";
      if (system(tmpBef.c_str())) return(1);
      else return(0);
    }
  */
  
  string tmpBef = "kfmclient exec file:";
  tmpBef += startDir;

  return(system(tmpBef.c_str()));
}

int getPrefLang(string &lang1, string &lang2, string &lang3)
{
  string           confPfad;

  confPfad = getenv("HOME");
  confPfad += "/.kderc";

  lang1 = "en";
  lang2 = "en_UK";
  lang3 = "de";

  if (existDat(confPfad))
    {
      KSimpleConfig    *configDat;
      
      configDat = new KSimpleConfig(confPfad.c_str(), true);
      configDat->setGroup("Locale");          
      if ((confPfad = configDat->readEntry("Language", "none")) != "none")
	{      
	  cout << "Languages: " << confPfad << "\n";
	  if (confPfad.find(":") != string::npos)
	    {
	      lang1 = confPfad.substr(0, confPfad.find(":"));
	      confPfad.replace(0, confPfad.find(":")+1, "");
	      lang2 = confPfad.substr(0, confPfad.find(":"));
	      confPfad.replace(0, confPfad.find(":")+1, "");
	      lang3 = confPfad;
	    }
	}
    }
  return(0);
}

void writeLatexFileHeader(ofstream &outDat)
{
  outDat << "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n";
  outDat << "%\n";
  outDat << "% autogenerated latex-file for CD-inlay and traycard.\n";
  outDat << "% Made by Jens Wilhelm Wulf for KisoCD.\n";
  outDat << "% Thanks to Beate for enhancements!\n";
  outDat << "%\n";
  outDat << "% Make your changes below (where indicated).\n";
  outDat << "%\n";
  outDat << "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n";
  outDat << "\n";
  outDat << "\\documentclass[12pt, a4paper]{article}\n";
  outDat << "\\usepackage{german}\n";
  outDat << "\\usepackage[latin1]{inputenc} % fr die Umlautverwendung\n";
  outDat << "\\usepackage[T1]{fontenc}      % Erlaubt Trennung von Wrtern mit Umlauten\n";
  outDat << "\\usepackage{rotating}\n";
  outDat << "\n";
  outDat << "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n";
  outDat << "%\n";
  outDat << "% Short description of the cds contents:\n";
  outDat << "%\n";
  outDat << "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n";
  outDat << "\n";
  outDat << "\\def\\CD_Titel{CD 7: pictures and general documents}\n";
  outDat << "\n";
  outDat << "\\def\\Inhalt{\n";
  outDat << "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n";
  outDat << "%\n";
  outDat << "% Here you can insert your latex-input:\n";
  outDat << "%\n";
  outDat << "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n";
  outDat << "  \\small\n";
  outDat << "  \\begin{description}\n";  
}

void writeLatexFileFooter(ofstream &outDat)
{
  outDat << "  \\end{description}\n";
  outDat << "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n";
  outDat << "%\n";
  outDat << "% There should be no need to edit below.\n";
  outDat << "%\n";
  outDat << "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n";
  outDat << "}\n";
  outDat << "\n";
  outDat << "\\begin{document}\n";
  outDat << "  \\pagestyle{empty}\n";
  outDat << "  \\fontfamily{cmss}\n";
  outDat << "  \\fontsize{14}{16}\n";
  outDat << "  \\selectfont\n";
  outDat << "  \\unitlength=0.1mm\n";
  outDat << "  \\begin{picture}(1600.00,2000.00)\n";
  outDat << "    % Die Markierungen zum schneiden und knicken zeichnen:\n";
  outDat << "    \\put(0, 0){\\dashbox{3}(62, 1170)}      % linkes Ohr\n";
  outDat << "    \\put(62, 0){\\dashbox{3}(1375, 1170)}   % Mitte\n";
  outDat << "    \\put(0, 1170){\\dashbox{3}(1200, 1200)} % Mitte\n";
  outDat << "    \\put(1437, 0){\\dashbox{3}(62, 1170)}   % rechtes Ohr\n";
  outDat << "\n";
  outDat << "    \\put(0, -70){\\dashbox{3}(1170, 62)}    % Ohr zur Testansicht\n";
  outDat << "    \\put(5, -54){\\CD_Titel}\n";
  outDat << "\n";
  outDat << "    \\put(0, 2308){\\dashbox{3}(1200, 62)}   % Titel auf Vorderseite\n";
  outDat << "    \\put(5, 2324){\\CD_Titel}\n";
  outDat << "\n";
  outDat << "    \\put(62, 1108){\\dashbox{3}(1375, 62)}  % Titel auf Rckseite\n";
  outDat << "    \\put(67, 1124){\\CD_Titel}\n";
  outDat << "\n";
  outDat << "    \\put(27, 5) {\n";
  outDat << "      \\begin{rotate}{90}\n";
  outDat << "        \\CD_Titel\n";
  outDat << "      \\end{rotate}\n";
  outDat << "    }\n";
  outDat << "    \\put(1439, 1165) {\n";
  outDat << "      \\begin{rotate}{-90}\n";
  outDat << "        \\CD_Titel\n";
  outDat << "      \\end{rotate}\n";
  outDat << "    }\n";
  outDat << "    % der Text in der Mitte:\n";
  outDat << "    \\put(55, 1066){\n";
  outDat << "      \\begin{minipage}[t]{135mm}\n";
  outDat << "        \\Inhalt\n";
  outDat << "      \\end{minipage}\n";
  outDat << "      }\n";
  outDat << "    % der Text auf der Vorderseite:\n";
  outDat << "    \\put(0, 2273){\n";
  outDat << "      \\begin{minipage}[t]{115mm}\n";
  outDat << "        \\Inhalt\n";
  outDat << "      \\end{minipage}\n";
  outDat << "      }\n";
  outDat << "  \\end{picture}\n";
  outDat << "\\end{document}\n";
}

void writeKoverFileHeader(ofstream &koverDat)
{
  koverDat << "[Title]\n";
  koverDat << "Text=give me a name!\n";
  koverDat << "Font=times,32,5,iso-8859-1,50,0\n";
  koverDat << "Color=0,0,0\n";
  koverDat << "[Program]\n";
  koverDat << "Name=Kover\n";
  koverDat << "Version=0.31\n";
  koverDat << "[General]\n";
  koverDat << "BackgroundColor=255,255,255\n";
  koverDat << "Number=0\n";
  koverDat << "[Images]\n";
  koverDat << "BackgroundImageMode=1\n";
  koverDat << "BackgroundImage=\n";
  koverDat << "[Contents]\n";
  koverDat << "text=";
}

void writeKoverFileFooter(ofstream &koverDat)
{
  koverDat << "\nFont=helvetica,16,5,iso-8859-1,50,0\n";
  koverDat << "Color=0,0,0\n";
}

int writeCdrecordCmd(ofstream &outDat, T_Options aktOpts, T_FileOptions fileOpts)
{
  string device = getDevID(fileOpts.writeDevice);

  outDat << "cdrecord -v ";
  if (aktOpts.fDummyWrite) outDat << "-dummy ";
  if (aktOpts.fPadTrack) outDat << "-pad ";
  if (fileOpts.fEject) outDat << "-eject ";
  if (aktOpts.fMulti) outDat << "-data ";
  if (aktOpts.fMulti && !aktOpts.fMultiLastSess) outDat << "-multi "; 

  if (aktOpts.fCreateImage) 
    {
      outDat << "speed=" << fileOpts.nWritingSpeedImg << " ";
      outDat << "dev=" << device << " '" << fileOpts.imageFilePath << "'";
      outDat << "\n";	  
    }
  else
    {
      outDat << "fs=" << fileOpts.nFifoSize << "m ";
      outDat << "speed=" << fileOpts.nWritingSpeedOTF << " ";
      outDat << "dev=" << device << " -";
      outDat << "\n";
    }
}

string getDevID(string tmp)
{
  while (tmp.find("(") != string::npos) tmp.replace(tmp.length()-1, 1, "");  
  return(tmp);
}

int createMirrDir(ofstream          &outDat, 
		  string            sessPfad, 
		  T_FileOptions     fileOpts, 
		  string            &linkFile,
		  string            HeimatPfad)
{
  string mirrorDirBase;
  
  mirrorDirBase = fileOpts.imageFilePath;
  while (mirrorDirBase[mirrorDirBase.length()-1] != '/') 
    mirrorDirBase.replace(mirrorDirBase.length()-1, 1, "");
  
  outDat << "\n# Anlegen des Mirror-Verzeichnisses:\n";
  
  outDat << "baseDir=" << mirrorDirBase << "\n";
  outDat << "zaehler=0\n";
  outDat << "dirName=kisocd$zaehler\n";
  outDat << "fullPath=$baseDir$dirName\n";
  outDat << "\n";
  outDat << "while [ -d $fullPath ]\n";
  outDat << "do\n";
  outDat << "  dirName=kisocd$zaehler\n";
  outDat << "  fullPath=$baseDir$dirName\n";
  outDat << "  if [ $zaehler -ge 10 ]\n";
  outDat << "  then\n";
  outDat << "    echo There seem to be some mirror-dirs left in \n";
  outDat << "    echo $baseDir\n";
  outDat << "    echo maybe you want to delete them?\n";
  outDat << "    echo Because of earlier errors they have not been deleted.\n";
  outDat << "  fi\n";
  outDat << "  zaehler=`expr $zaehler + 1`\n";
  outDat << "done\n";
  outDat << "\n";
  outDat << "echo KisoCD: $fullPath as mirror-dir\n";
  outDat << "V=$fullPath\n";

  outDat << "if mkdir $V\n";
  outDat << "    then \n";
  outDat << "      true\n";
  outDat << "    else\n";
  outDat << "      echo KisoCD: aborted, because the mirror-dir\n";
  outDat << "      echo $V\n";  
  outDat << "      echo did already exist! You have to give a nonexistent directory!\n";
  outDat << "      exit\n";
  outDat << "fi\n";

  if (sessPfad != "")    
    {
      linkFile = sessPfad;
      linkFile.replace(0, 1, "");
      linkFile.replace(0, linkFile.find("/")+1, "");
	
      outDat << "V=${fullPath}/" << linkFile << "\n";
      outDat << "mkdir $V\n";
    }
  
  linkFile = HeimatPfad;
  linkFile += "/links.lst";
  
  linkFile = HeimatPfad;
  linkFile += "/dirs.lst";
  outDat << "echo \"KisoCD: Creating mirror-directory. This may take a while...\"\n";
  outDat << "source " << linkFile << "\n";
  
  linkFile = HeimatPfad;
  linkFile += "/links.lst";
  outDat << "source " << linkFile << "\n";
  
  outDat << "# Anlegen des Mirror-Verzeichnisses beendet.\n\n";
  return(0);
}

int deleteMirrDir(ofstream &outDat)
{
  outDat << "# Lschen des Mirror-Verzeichnisses:\n";
  outDat << "echo \"KisoCD: Deleting mirror-directory.\"\n";
  outDat << "rm -r $fullPath/\n";
  outDat << "# Lschen des Mirror-Verzeichnisses beendet.\n\n";
  return(0);
}


void downloadFile(string dropped)
{
  KShellProcess*  process = NULL;
  string          kurzTitel;
  
  kurzTitel = dropped;
  while (kurzTitel.length() > 10) kurzTitel.replace(0, 1, "");
  kurzTitel = "wget:" + kurzTitel;
  
  dropped = "\"" + dropped + "\"";	
  
  process = new KShellProcess;
  (*process) << "xterm" 
	     << "-T" << kurzTitel.c_str() 
	     << "-fn" << "5x8" 
	     << "-e" << "wget" 
	     << "-P" << "/win2/" 
	     << dropped.c_str();
  process->start(KShellProcess::DontCare);
  
  delete process;	
}

string rmSlashes(string ziel)
  // entfernt fhrende Slashes und reduziert direkt aufeinanderfolgende auf einen einzigen
{
  // Fhrende '/' lschen
  if (ziel.size() != 0)
    while ((ziel[0] == '/') && (ziel.size() != 0))
      ziel.replace(0, 1, "");
  // Jetzt wre es noch schn, aufeinanderfolgende '/' zu reinigen...
  for (int Cnt = 0; Cnt < int(ziel.size()-1); Cnt++) 
    if ((ziel[Cnt] == '/') && (ziel[Cnt+1] == '/')) ziel.replace(Cnt+1, 1, "");
  
  return(ziel);
}

void mountViewImage(bool &fMounted, T_FileOptions fileOpts)
{
  if (fMounted) fehlermeldung(i18n("image already mounted!"));
  else 
    {
      string tmpBef;
      string tmpPfad;
      
      // mounten, je nach Erfolg fMounted setzen
      tmpBef = "mount ";
      tmpBef += fileOpts.imageFilePath;
      tmpBef += " ";
      tmpBef += fileOpts.mountPoint;
      tmpBef += " -o loop &> ";
      
      tmpPfad = getNrFile("/tmp/", "kisocd");
      tmpBef += tmpPfad;
      
      if (system(tmpBef.c_str()) != 0) 
	{
	  string fehler = i18n("Error when mounting! I'll just show you mount's output:\n");
	  
	  fehler+= dateiInhalt(tmpPfad);		
	  fehlermeldung(fehler.c_str()); 
	  // hier setze ich fMounted nicht false, denn es kann ja sein,
	  // dass es den Fehler gerade deshalb gab, weil schon etwas
	  // gemounted ist!!!
	}
      else 
	{
	  fMounted = true;
	  if (execKFM(fileOpts.mountPoint)) fehlermeldung(i18n("Error executing kfm!"));
	}
      unlink(tmpPfad.c_str());
    }      	
}  
  
void unmountImage(bool &fMounted, string mountPoint)
{
  // Image unmounten, wenn es einen Fehler gibt, Meldung machen.
  // Das ganze so lange, bis image wirklich unmounted ist. 
  // Mit Hinweis auf evtl. sptere Fehler kann man auch abbrechen.
  // Hinterher fMounted entsprechend setzen.
  
  string tmpBef;
  bool fEnde = false;
  
  tmpBef = "umount " + mountPoint + " &> ";
  
  string tmpPfad = getNrFile("/tmp/", "kisocd");
  tmpBef += tmpPfad;

  while ((system(tmpBef.c_str()) != 0) && (!fEnde)) 
    {
	string fehler = dateiInhalt(tmpPfad);
	fehler += "\n";
	fehler += i18n("You can try again or cancel. The latter\n" 
		       "possibly results in further errors when trying to mount again.");
	fEnde = (QMessageBox::warning(0, i18n("error when unmounting"), 
				      fehler.c_str(),
				      i18n("try again"), i18n("Cancel"), 
				      0, 1, 1));
    }
  fMounted = fEnde;
}


string getPersConfigDir()
{
  string outDatPath;

  outDatPath = getenv("HOME");
  outDatPath += "/.kde/share/apps/";
  outDatPath += ProggieNameLC;

  return(outDatPath);
}


