/***************************************************************************
                          subprocessoutput.h  -  description                              
                             -------------------                                         
    begin                : Fri Aug 20 1999                                           
    copyright            : (C) 1999 by Jens Wilhelm Wulf                         
    email                : jens_w2@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef SUBPROCESSOUTPUT_H
#define SUBPROCESSOUTPUT_H

#include <qwidget.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qpushbutton.h>

#include <kapp.h>
#include <kprocess.h> 
#include <qdialog.h>
#include <string>

/**
  *@author Jens Wilhelm Wulf
  */

class subprocessoutput : public QDialog  {
   Q_OBJECT
public: 
   KShellProcess*     proc;
   int                ID;

// Belegung von ID:
//      bei imageSub
//         1 bei image-erzeugung
//         2 bei Simulation
//      bei brennSub
//         1 bei brennen
//         2 bei blankRW-all
//         3 bei blankRW-fast
//         4 bei blankRW-lastsess

   string             str;     // akkumuliert die Zeichen, die ausgegeben werden sollen, bis eine Zeile fertig ist.
   bool               teilAus; // ist true, wenn schon Zeichen ausgegeben wurden, obwohl noch keine Zeile fertig war.  
   
   QListBox    *QListBox_1;
   QLabel      *QLabel_1;
   QPushButton *b_continue;
   QPushButton *b_abort;
   QPushButton *b_close;
   
	subprocessoutput(string      labelInhalt, 
			 QWidget     *parent=0, 
			 const char  *name=0, 
			 bool        fModal = false,
			 bool        fehler = false);
	~subprocessoutput();
	bool containsString(string);
	string getLatestLineWith(string aStr, int pos);
	bool isRunning();
	void newProc(string, string);
public slots:
	void input(KProcess *dummy, char *buffer, int buflen);

protected: 
	void initDialog();

private: 
};

#endif





