/***************************************************************************
                          quickstartdialog.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Aug 22 1999                                           
    copyright            : (C) 1999 by Jens Wilhelm Wulf                         
    email                : jens_w2@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "quickstartdialog.h"

quickstartdialog::quickstartdialog(QWidget *parent, 
				   const char *name, 
				   bool fModal) : QDialog(parent,name,fModal)
{
  this->resize(470,390);
  this->setMaximumSize(470,390);
  this->setMinimumSize(470,390);

  QListBox_1= new QListBox(this,"NoName");
  QListBox_1->setGeometry(10,10,450,330);

  b_close= new QPushButton(this,"NoName");
  b_close->setGeometry(30,350,100,30);
  b_close->setText(i18n("Close"));

  QPushButton_2= new QPushButton(this,"NoName");
  QPushButton_2->setGeometry(220,350,100,30);
  QPushButton_2->setText(i18n("<< previous"));

  QPushButton_1= new QPushButton(this,"NoName");
  QPushButton_1->setGeometry(340,350,100,30);
  QPushButton_1->setText(i18n("next >>"));

  QPushButton_1->setEnabled(false);
  QPushButton_2->setEnabled(false);

  helpDatPfad = KApplication::kde_htmldir() + "/";
  
  {
    string lang1, lang2, lang3;
    
    getPrefLang(lang1, lang2, lang3);

    if (existDat(helpDatPfad + lang1 + "/kisocd/quickstart.txt")) 
      helpDatPfad += lang1 + "/kisocd/quickstart.txt";
    else 
      if (existDat(helpDatPfad + lang2 + "/kisocd/quickstart.txt")) 
	helpDatPfad += lang2 + "/kisocd/quickstart.txt";
      else helpDatPfad += lang3 + "/kisocd/quickstart.txt";
  }
  
  chapter = 1;
  helpDat.open(helpDatPfad.c_str());
  cout << helpDatPfad << "\n";

  if (!helpDat) fehlermeldung(i18n("Unable to open quickhelp-file!"));
  else 
    { 
      char     Zeile[103];
      
      helpDat.getline(Zeile, 100);
      readChapter();
      connect(QPushButton_2, SIGNAL(clicked()), SLOT(prevChapter()));
      connect(QPushButton_1, SIGNAL(clicked()), SLOT(nextChapter()));
      connect(b_close, SIGNAL(clicked()), SLOT(hide()));
      QPushButton_1->setEnabled(true);
    }
}

void quickstartdialog::readChapter()
{
  char  Zeile[102];

  QListBox_1->clear();
  while ((!helpDat.eof()) && (Zeile[0] != '[')) 
    {
      helpDat.getline(Zeile, 100);
      if (Zeile[0] != '[') QListBox_1->insertItem(Zeile);
    }
  if (Zeile[0] != '[') QPushButton_1->setEnabled(false);
}

void quickstartdialog::gotoFirstChapter()
{
  char     Zeile[103];

  chapter = 1;
  helpDat.close();      
  helpDat.open(helpDatPfad.c_str());
  helpDat.getline(Zeile, 100);
  readChapter();
  QPushButton_1->setEnabled(true);
  QPushButton_2->setEnabled(false);
}

void quickstartdialog::prevChapter()
{
  if (chapter > 1)
    {
      char  C1, C2;     
      char  Zeile[102];

      chapter--;   
      if (chapter == 1) QPushButton_2->setEnabled(false);
      if (chapter / 10 > 0) C1 = (chapter/10)+48;
      else C1 = ' ';
      C2 = (chapter%10)+48;
      QPushButton_1->setEnabled(true);
      helpDat.close();
      helpDat.open(helpDatPfad.c_str());
      while ((!helpDat.eof()) && 
	     !(Zeile[0] == '[' && Zeile[1] == C1 && Zeile[2] == C2)) 
	helpDat.getline(Zeile, 100);
      readChapter();      
    }
}

void quickstartdialog::nextChapter()
{
  readChapter();
  chapter++;
  QPushButton_2->setEnabled(true);  
}

quickstartdialog::~quickstartdialog()
{
}

#include "quickstartdialog.moc"




