#ifndef opt_cd_included
#define opt_cd_included

/*** Qt ***/
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qdialog.h>
#include <qwidget.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qframe.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>

/*** KDE ***/
#include <kfiledialog.h>
#include <ktabctl.h>
#include <kprocess.h>
#include <krestrictedline.h>
#include <ksimpleconfig.h>

/*** C++ ***/
#include <string>
#include <stdlib.h>   // fr getenv(..) und system(..)
#include <fstream.h>
#include "sys/stat.h" // fr die Dateiattribute
#include <iostream.h>

/*** KisoCD ***/
#include "tools.h"
#include "types.h"
#include "edit.h"

class opt_cd : public QDialog
{
    Q_OBJECT

private:
    T_Options*        defOpts;
    T_Options*        aktOpts;
    bool*             optsApplied;
    KSimpleConfig*    globalConf;

  /******* IDs ***********/
  QLineEdit*    qtarch_LineEdit_6; 
  QLineEdit*    qtarch_LineEdit_7;
  QLineEdit*    qtarch_LineEdit_8;
  QLineEdit*    qtarch_LineEdit_9;
  QLabel*       qtarch_Label_1;
  QLabel*       qtarch_Label_2;
  QLabel*       qtarch_Label_3;  
  QLabel*       qtarch_Label_4;

  /****** Filesystem ***********/
  QCheckBox*    cbSymlink;
  QCheckBox*    cbConvLD;
  QCheckBox*    cbTRANS;
  QCheckBox*    cbJoliet;
  QCheckBox*    cbFN32;
  QCheckBox*    cbRR2;
  QCheckBox*    cbRR1;
  QPushButton*   btnUnix;
  QPushButton*   btnDOS;
  QPushButton*   btnWin;
  QPushButton*   btnUnixWin;

  /******** basics ***********/
  QButtonGroup*   QGroupBox_1;
  QButtonGroup*   QGroupBox_2;
  QRadioButton*   QRadioButton_1;
  QRadioButton*   QRadioButton_2;
  QRadioButton*   QRadioButton_3;
  QRadioButton*   QRadioButton_4;
  QRadioButton*   QRadioButton_5;
  QCheckBox*      QCheckBox_1;
  QCheckBox*      QCheckBox_2;

  /******* multisession/bootable **********/
  QButtonGroup*   QGroupBox_1f;
  QGroupBox*      QGroupBox_2f;
  QRadioButton*   QRadioButton_1f;
  QRadioButton*   QRadioButton_2f;
  QRadioButton*   QRadioButton_3f;
  QPushButton*    QPushButton_1f;
  QLabel*         QLabel_1f;
  QLabel*         QLabel_2f;
  
  /***** allgemein *********/
  KTabCtl*       tabCtl;
  QWidget*       tabP1;
  QWidget*       tabP3;
  QWidget*       tabP4;
  QPushButton*   buttonCancel;
  QPushButton*   buttonOK;
  QPushButton*   buttonApply;
  QPushButton*   buttonSaveDefaults;


  void readGlobalConf();

public:
    opt_cd(QWidget*       parent,
	   const char*    name,
	   KSimpleConfig* globConf,
	   T_Options*     pSaveOpts,
	   T_Options*     pAktOpts,
	   bool*          changed);
    ~opt_cd();
    

protected slots:
 /********* filesystem *********/
 void CBRR1toggled(bool state);
 void CBRR2toggled(bool state);
 void followSymlinkToggled(bool);
 void fsOptDOS();
 void fsOptWin();
 void fsOptUnix();
 void fsOptUnixWin();
 /**** allgemein ****/
 void applyOptions();
 void setOptionsAsDefault(); 
 void updateDepsI(int dummy);
 void updateDeps();
 void ok_clicked();
 /******* bootable **********/
 void bootbrowseClicked();  
};

#endif // opt_cd_included






