// -*- c++ -*-

#ifndef EDIT_H
#define EDIT_H

/*** Qt ***/
#include <qlistview.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qlistbox.h>
#include <qtooltip.h>

/*** KDE ***/
#include <kfiledialog.h>
#include <kprocess.h>
#include <ktopwidget.h>
#include <kapp.h>
#include <kurl.h>
#include <kmenubar.h>
#include <kcontainer.h>
#include <knewpanner.h>
#include <drag.h>
#include <kprogress.h>
#include <ksimpleconfig.h>

/*** C++ ***/
#include <fstream.h>
#include <stdlib.h>   // fr getenv(..) und system(..)
#include <unistd.h>   // fr chdir(...)
#include <iostream.h>
#include "sys/stat.h" // fr die Dateiattribute
#include "sys/types.h"
#include <vector>
#include "ctype.h"
#include <string>

/*** KisoCD ***/
#include "tools.h"
#include "neuVerzDiag.h"
#include "cdEditData.h"
#include "cdTree.h"
#include "types.h"
#include "subprocessoutput.h"
#include "simplekfvdialog.h"
#include "quickstartdialog.h"
#include "version.h"
#include "opt_sys.h"
#include "opt_cddoc.h"
#include "opt_cd.h"

class Edit : public KTopLevelWidget
{
  Q_OBJECT

public: 
  Edit(int aDebuglevel);
  ~Edit();

public slots:
  void commandCallback(int id_);
  void changedDirCallback(QListViewItem *);
  void DDDirektCB(KDNDDropZone* _dropzone);
  void editwindowClick();
  void prozessEnde(KProcess *);
  void dropAktion(string);
  void setupFileMenu();
  void setupSStepMenu();
  void setupCDDocMenu();
  void untersucheMkisofsAusgabe(KProcess *);
private:
  T_Options          aktOpts;
  T_Options          defOpts;
  T_FileOptions      fileOpts;
  t_fileWatch        texFileWatch;
  long int           sessOffset;
  KSimpleConfig*     globalConf;
  subprocessoutput*  imageSub;
  subprocessoutput*  brennSub;
  bool               NOTsaved;
  bool               ProjectOpen;
  string             aktDateiName;  // Projektdatei!
  string             aktVerz;       // das im rechten Fenster angezeigte
  string             HeimatPfad;    // ~/+ProgrammName
  bool               fMounted;      // ist das aktuelle Image gemountet? 
  int                brennGesamtStatus;

  simplekfvdialog*   myFileView;
  quickstartdialog*  myQuickHelp;

  // Child widgets

  QPopupMenu         *file;
  QPopupMenu         *cdDoc;
  QPopupMenu         *help;
  QPopupMenu         *CDRW;
  QPopupMenu         *m_options;
  QPopupMenu         *m_view;
  QPopupMenu         *m_virtcd;
  QPopupMenu         *burnSingleStep;

  KMenuBar           *menu;
  KStatusBar         *statusBar;
  QListView          *ktlist;
  QListView          *DatList;
  KDNDDropZone       *DDDirektaufnahme;
  KNewPanner         *Panner;
  KProgress          *VoelleGefuehl;

  void closeEvent( QCloseEvent* e );
  bool endeFrage();
  /********************************/
  int checkPrerequisites();
  void getGlobalConfDat(KSimpleConfig* &globalConf);
  void makeNewLatexFile(string  HeimatPfad, 
			QString htmldir);
  void saveOptions(struct T_Options      &defOpts, 
		   struct T_FileOptions  &fileOpts,
		   string                HeimatPfad);
  void setDefaultConfig(struct T_Options      &defOpts, 
			struct T_FileOptions  &fileOpts,
			string                HeimatPfad);
  int ladeVorgaben(KSimpleConfig*        globalConf,
		   string                HeimatPfad,
		   struct T_Options      &defOpts, 
		   struct T_FileOptions  &fileOpts);
  int preBurningBox();
  /********************************/
  int startSubProc(subprocessoutput*   &subProc, 
		   string   shortInfoText, 
		   int      menuID, 
		   string   pfad, 
		   int      pType, 
		   int      ID, 
		   int      bGS);
  void startLatexCompile(KShellProcess* &process, 
			 bool           &processStarted,
			 bool           wait = false);
  int createStatusBar();
  int createMenu();
  int createMainView();
  int startCreateImage();
  void startImageSim(int);
  void startBrennProzess();
  void burnCD_guided(int someVar = 0);
  int saveToFile(const char* filename);
  int loadFromFile(const char* filename);
  void addedDrop(string src, 
		 string dst);
  void setzeVoelleGefuehl(unsigned long WieVoll);
  void writeMkisofsCommand(ofstream &outDat, 
			   bool     fImageFile, 
			   bool     test, 
			   string   bootDir, 
			   long int ms1, 
			   long int ms2);
  int createFinalScript(bool allowShutdown,
			bool delImage = false);
  string createImageScript(bool     test, 
			   long int ms1, 
			   long int ms2,
			   string   sessPfad);
  int getSessionData(long int &ms1, 
		     long int &ms2, 
		     string &sessPfad);
  void machNeuVerz();
  int bootableActions(ofstream &outDat, 
		      string &bootDir);
  void blankRW(int, bool);
  bool prozessAktiv();
  bool needMirrorDir();
  void clearLabels();
  
  void disableMenuEntries();
  void reenableMenuEntries();
public:
  T_cdTree           *MeineCD;
};

#endif // EDIT_H





















