#ifndef _kmasterdatacd_h
#define _kmasterdatacd_h

/* Fernando Herrera <fherrera@eurielec.etsit.upm.es>
 *
 *
 *
 *
 *
 */

#include <qgrpbox.h>
#include <qpushbt.h>
#include <ktablistbox.h>
#include <qlayout.h>
#include <qbttngrp.h>
#include <qchkbox.h>
#include <qradiobt.h>
#include <qlabel.h>
#include <qlined.h>

#include <drag.h>
#include <kprogress.h>
#include <kconfig.h>
#include <kapp.h>
#include <kprocess.h>

class ChgFileDlg : public QDialog
{
 Q_OBJECT
 
 public:
  ChgFileDlg ( QWidget *parent=0, const char *name=0 );
 private slots:
  void newFileDes();
 signals:
  void newDes ( const QString & );
 private:
    QLabel *nameLbl;
    QPushButton *ok, *cancel;
    QLineEdit *nameEdit;
};

class KMasterDataCd : public QGroupBox
{
  Q_OBJECT
  
 public:
  KMasterDataCd ( QWidget *parent = 0 );
  ~KMasterDataCd();
  void updateUsage();
  KTabListBox *fileListBox;

 protected:
  void getFileSize( const char *myFile );
  void updateIsoSize( int rowChanged, bool add );
  KConfig *config;
  QPushButton *startMakeImage;
  KProgress *imageUsage;
  QLabel *imageSize;
  long imageSizeNum; // Where _real_ size are Stored
  QLabel *imageTime;
  QCheckBox *rockRidge;
  QCheckBox *joliet;
  /* aadir: ~files, store in 8.3, bootable images, follow simbolic links
   * and more features...
   */
  QLineEdit *outputFile;
  QRadioButton *isoStoreFile , *isoStoreFly;
  KDNDDropZone *filesDropZone; 

 protected slots:
  void filesDropAction( KDNDDropZone *zone );
  void getSizeExit( KProcess* );
  void getSizeOutput( KProcess*, char*, int);
  void getSizeErr( KProcess*, char*, int);
  void filePopup( int, int );
  void removeFile();
  void changeFileDes();
  void fileDesChanged(const QString &);
  void makeImage();

};


#endif
