/*
 * kmol.h 
 *
 * Copyright (C) 1999 Tomislav Gountchev <tomi@socrates.berkeley.edu>
 */

// using the framework generated by kapptemplate 0.3.0

#ifndef KMOL_H 
#define KMOL_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <ktmainwindow.h>
 
#include "kmolwidget.h"

/**
 * This class serves as the main window for KMol.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Tomislav Gountchev <tomi@socrates.berkeley.edu>
 * @version 0.2
 */
class KMol : public KTMainWindow
{
	Q_OBJECT
public:
	/**
	 * Default Constructor
	 */
	KMol();

	/**
	 * Default Destructor
	 */
	virtual ~KMol();

public slots:
	/**
	 * This is called whenever the user Drag n' Drops something into our
	 * window
	 */
	void slotDropEvent(KDNDDropZone *);
 
protected:
	/**
	 * This function is called when it is time for the app to save its
	 * properties for session management purposes.
	 */
	void saveProperties(KConfig *);

	/**
	 * This function is called when this app is restored.  The KConfig
	 * object points to the session management config file that was saved
	 * with @ref saveProperties
	 */
	void readProperties(KConfig *);

private:
	KMolWidget *view;
};

#endif // KMOL_H 
