/***************************************************************************
                          quanta.cpp  -  description
                             -------------------
    begin                :   18 23:09:05 EET 1999
    copyright            : (C) 1999 by Yacovlev Alexander & Dmitry Poplavsky
    email                : pdima@mail.univ.kiev.ua
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>

// include files for QT
#include <qdir.h>
#include <qfile.h>
#include <qstrlist.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qlayout.h>
#include <qwidgetstack.h>

// include files for KDE
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kfiledialog.h>
#include <kdir.h>
#include <ktabbar.h>
#include <kcursor.h>

#include <knewpanner.h>
#include <htmlview.h>
#include <ktabctl.h>
#include <kprocess.h>
#include <kapp.h>

// application specific includes
#include "quanta.h"
#include "quantaview.h"
#include "quantadoc.h"
#include "kwview.h"
#include "dirview.h"
#include "treeview.h"
#include "messageoutput.h"
#include "doctreeview.h"
#include "docitem.h"
#include "docbrowser.h"

#include "resource.h"

#include "pics/new.xpm"
#include "pics/open.xpm"
#include "pics/save.xpm"
#include "pics/save_all.xpm"
#include "pics/print.xpm"
#include "pics/exit.xpm"
#include "pics/close.xpm"

#include "pics/cut.xpm"
#include "pics/copy.xpm"
#include "pics/paste.xpm"
#include "pics/redo.xpm"
#include "pics/undo.xpm"
#include "pics/find.xpm"
#include "pics/findnext.xpm"
#include "pics/replace.xpm"

#include "pics/tree_win.xpm"
#include "pics/output_win.xpm"
#include "pics/preview.xpm"
#include "pics/back.xpm"
#include "pics/forward.xpm"
#include "pics/repaint.xpm"

#include "pics/home.xpm"
#include "pics/folder_red.xpm"
#include "pics/minimize.xpm"
#include "pics/maximize.xpm"



QuantaApp::QuantaApp()
{
  config=kapp->getConfig();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();

  initDocument();
  initView();
  initKeyAccel();

  readOptions();

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
  disableCommand(ID_FILE_SAVE);

	disableCommand(ID_VIEW_BACK);
  disableCommand(ID_VIEW_FORWARD);

  disableCommand(ID_EDIT_CUT);
  disableCommand(ID_EDIT_COPY);
  disableCommand(ID_EDIT_PASTE);

  disableCommand(ID_EDIT_UNDO);
  disableCommand(ID_EDIT_REDO);

	htmlFilter = HTML_MASK;
	textFilter = TEXT_MASK;
	imageFilter = IMAGE_MASK;
	backupFilter = BACKUP_MASK;
}

QuantaApp::~QuantaApp()
{

}

void QuantaApp::initKeyAccel()
{
  keyAccel = new KAccel(this);
	
  // fileMenu accelerators
  keyAccel->connectItem(KAccel::New, this, SLOT(slotFileNew()));
  keyAccel->connectItem(KAccel::Open, this, SLOT(slotFileOpen()));
  keyAccel->connectItem(KAccel::Save, this, SLOT(slotFileSave()));
  keyAccel->connectItem(KAccel::Close, this, SLOT(slotFileClose()));
  keyAccel->connectItem(KAccel::Print, this, SLOT(slotFilePrint()));
  keyAccel->connectItem(KAccel::Quit, this, SLOT(slotFileQuit()));
  // editMenu accelerators
  keyAccel->connectItem(KAccel::Cut, this, SLOT(slotEditCut()));
  keyAccel->connectItem(KAccel::Copy, this, SLOT(slotEditCopy()));
  keyAccel->connectItem(KAccel::Paste, this, SLOT(slotEditPaste()));
  keyAccel->connectItem(KAccel::Undo, this, SLOT(slotEditUndo()));
  keyAccel->connectItem(KAccel::Find, this, SLOT(slotEditSearch()));
  keyAccel->connectItem(KAccel::Replace, this, SLOT(slotEditReplace()));

  keyAccel->insertItem("redo",Key_Y+CTRL);
  keyAccel->connectItem("redo", this, SLOT(slotEditRedo()));

  keyAccel->insertItem("find next",Key_F3);
  keyAccel->connectItem("find next", this, SLOT(slotEditSearchAgain()));

  keyAccel->connectItem(KAccel::Help, kapp, SLOT(appHelpActivated()));
			
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_NEW, KAccel::New);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_OPEN, KAccel::Open);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_SAVE, KAccel::Save);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_CLOSE, KAccel::Close);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_PRINT, KAccel::Print);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_QUIT, KAccel::Quit);

  keyAccel->changeMenuAccel(editMenu, ID_EDIT_CUT, KAccel::Cut);
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_COPY, KAccel::Copy);
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_PASTE, KAccel::Paste);
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_UNDO, KAccel::Undo);
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_REDO, "redo");
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_SEARCH, KAccel::Find);
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_REPLACE, KAccel::Replace);
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_SEARCH_AGAIN, "find next");

  keyAccel->insertItem("br",Key_Return+CTRL);
  keyAccel->connectItem("br",view,SLOT(slotTagBr()));

  keyAccel->insertItem("nbsp",Key_Space+CTRL);
  keyAccel->connectItem("nbsp",view,SLOT(slotTagNbsp()));

  keyAccel->readSettings();	
}

void QuantaApp::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR
  recentFilesMenu = new QPopupMenu();
  connect(recentFilesMenu, SIGNAL(activated(int)), SLOT(slotFileOpenRecent(int)));

  ///////////////////////////////////////////////////////////////////
  // menuBar entry fileMenu
  fileMenu = new QPopupMenu();
  fileMenu->insertItem(kapp->getMiniIcon(), i18n("New &Window"), ID_FILE_NEW_WINDOW);
  fileMenu->insertSeparator();
  fileMenu->insertItem(QPixmap((const char**)new_xpm),  i18n("&New"), ID_FILE_NEW);
  fileMenu->insertItem(QPixmap((const char**)open_xpm), i18n("&Open..."), ID_FILE_OPEN);
  fileMenu->insertItem(i18n("Open &recent"), recentFilesMenu, ID_FILE_OPEN_RECENT);
	// fileMenu->insertItem(QPixmap((const char**)base_xpm), i18n("&Base directory select"), ID_FILE_DIR_SELECT);

  fileMenu->insertItem(i18n("&Close"), ID_FILE_CLOSE);
  fileMenu->insertSeparator();
  fileMenu->insertItem(QPixmap((const char**)save_xpm) ,i18n("&Save"), ID_FILE_SAVE);
  fileMenu->insertItem(i18n("Save &As..."), ID_FILE_SAVE_AS);
  fileMenu->insertItem(QPixmap((const char**)save_all_xpm), i18n("Save All..."), ID_FILE_SAVE_ALL);
  fileMenu->insertSeparator();
  fileMenu->insertItem(i18n("Weblint"), ID_FILE_LINT);
  fileMenu->insertSeparator();

  fileMenu->insertItem(QPixmap((const char**)print_xpm), i18n("&Print..."), ID_FILE_PRINT);
  fileMenu->insertSeparator();
  fileMenu->insertItem(QPixmap((const char**)exit_xpm), i18n("E&xit"), ID_FILE_QUIT);
	
  ///////////////////////////////////////////////////////////////////
  // menuBar entry editMenu
  editMenu = new QPopupMenu();
  editMenu->insertItem(QPixmap((const char**)cut_xpm),  i18n("Cu&t"), ID_EDIT_CUT);
  editMenu->insertItem(QPixmap((const char**)copy_xpm), i18n("&Copy"), ID_EDIT_COPY);
  editMenu->insertItem(QPixmap((const char**)paste_xpm),i18n("&Paste"), ID_EDIT_PASTE);
  editMenu->insertSeparator();
  editMenu->insertItem(QPixmap((const char**)undo_xpm),i18n("&Undo"), ID_EDIT_UNDO);
  editMenu->insertItem(QPixmap((const char**)redo_xpm),i18n("&Redo"), ID_EDIT_REDO);
  editMenu->insertSeparator();
  editMenu->insertItem(QPixmap((const char**)find_xpm),i18n("&Search"), ID_EDIT_SEARCH);
  editMenu->insertItem(QPixmap((const char**)find_next_xpm),i18n("Search &again"), ID_EDIT_SEARCH_AGAIN);
  editMenu->insertItem(QPixmap((const char**)replace_xpm),i18n("R&eplace"), ID_EDIT_REPLACE);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry viewMenu
  viewMenu = new QPopupMenu();
  viewMenu->setCheckable(true);
  viewMenu->insertItem(i18n("&Toolbar"), ID_VIEW_TOOLBAR);
  viewMenu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR);

  viewMenu->insertItem(QPixmap((const char**)tree_win_xpm),  i18n("&Tree"),     ID_VIEW_TREE);
  viewMenu->insertItem(QPixmap((const char**)output_win_xpm),i18n("&Messages window"),     ID_VIEW_MES);
  viewMenu->insertItem(QPixmap((const char**)preview),       i18n("&Preview"),         ID_VIEW_PREVIEW);
  viewMenu->insertItem(QPixmap((const char**)repaint_xpm),   i18n("&Refresh preview"), ID_VIEW_REPAINT);

  viewMenu->setAccel(Key_F6, ID_VIEW_PREVIEW);
  viewMenu->setAccel(Key_F5, ID_VIEW_REPAINT);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry optionsmenu

  optionsMenu = new QPopupMenu();
  optionsMenu->insertItem(i18n("&Editor options"), ID_OPTIONS_EDITOR );
  optionsMenu->insertItem(i18n("Editor &defaults"), ID_OPTIONS_DEFAULTS );

  ///////////////////////////////////////////////////////////////////
  // menuBar entry helpMenu
  QString aboutstring=QString(i18n("      \nQuanta - HTML Editor for KDE\nVersion "))
            +VERSION+"\n\n(c) 2000 \n"\
  					"Dmitry Poplavsky   <pdima@mail.univ.kiev.ua>\n"\
  					"Alexander Yakovlev <korvin@mail.univ.kiev.ua>";

  helpMenu = new QPopupMenu();
  helpMenu = kapp->getHelpMenu(true, aboutstring);

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // insert your popup menus with the according menubar entries in the order
  // they will appear later from left to right
  menuBar()->insertItem(i18n("&File"), fileMenu);
  menuBar()->insertItem(i18n("&Edit"), editMenu);
  menuBar()->insertItem(i18n("&View"), viewMenu);
  menuBar()->insertItem(i18n("&Options"), optionsMenu);

  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), helpMenu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE MENU SLOTS WITH SIGNALS
  // for execution slots and statusbar messages

  connect(fileMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(fileMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  connect(editMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(editMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  connect(viewMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(viewMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  connect(optionsMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(optionsMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

}

void QuantaApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  toolBar()->insertButton(QPixmap((const char**)new_xpm),     ID_FILE_NEW,      true, i18n("New File"));
  toolBar()->insertButton(QPixmap((const char**)open_xpm),    ID_FILE_OPEN,     true, i18n("Open File"));
  toolBar()->insertButton(QPixmap((const char**)save_xpm),    ID_FILE_SAVE,     true, i18n("Save File"));
  toolBar()->insertButton(QPixmap((const char**)save_all_xpm),ID_FILE_SAVE_ALL, true, i18n("Save all files"));
  toolBar()->insertButton(QPixmap((const char**)print_xpm),   ID_FILE_PRINT,    true, i18n("Print"));

  QFrame *separatorLine1= new QFrame( toolBar());
  separatorLine1->setFrameStyle( QFrame::VLine|QFrame::Sunken);
  toolBar()->insertWidget( 0,20,separatorLine1);

  toolBar()->insertSeparator();
  toolBar()->insertButton(QPixmap((const char**)cut_xpm),  ID_EDIT_CUT, true, i18n("Cut"));
  toolBar()->insertButton(QPixmap((const char**)copy_xpm), ID_EDIT_COPY, true, i18n("Copy"));
  toolBar()->insertButton(QPixmap((const char**)paste_xpm),ID_EDIT_PASTE, true, i18n("Paste"));
  toolBar()->insertButton(QPixmap((const char**)undo_xpm),ID_EDIT_UNDO, true, i18n("Undo"));
  toolBar()->insertButton(QPixmap((const char**)redo_xpm),ID_EDIT_REDO, true, i18n("Redo"));

  QFrame *separatorLine2= new QFrame( toolBar());
  separatorLine2->setFrameStyle( QFrame::VLine|QFrame::Sunken);
  toolBar()->insertWidget( 0,20,separatorLine2);

  toolBar()->insertButton(QPixmap((const char**)tree_win_xpm), ID_VIEW_TREE, true, i18n("View tree"));
  toolBar()->setToggle(ID_VIEW_TREE);
  toolBar()->insertButton(QPixmap((const char**)output_win_xpm), ID_VIEW_MES, true, i18n("View messages"));
  toolBar()->setToggle(ID_VIEW_MES);
  toolBar()->insertButton(QPixmap((const char**)preview),      ID_VIEW_PREVIEW, true, i18n("Preview"));
  toolBar()->setToggle(ID_VIEW_PREVIEW);
  toolBar()->insertButton(QPixmap((const char**)back_xpm),      ID_VIEW_BACK, true, i18n("Back"));
  toolBar()->insertButton(QPixmap((const char**)forward_xpm),   ID_VIEW_FORWARD,  true, i18n("Forward"));
  toolBar()->insertButton(QPixmap((const char**)repaint_xpm),   ID_VIEW_REPAINT,  true, i18n("Refresh Preview"));

  QFrame *separatorLine3= new QFrame( toolBar());
  separatorLine3->setFrameStyle( QFrame::VLine|QFrame::Sunken);
  toolBar()->insertWidget( 0,20,separatorLine3);

  toolBar()->insertButton(Icon("help.xpm"), ID_HELP_CONTENTS, SIGNAL(clicked()),
  				kapp, SLOT(appHelpActivated()), true,i18n("Help"));
  				
  				


  toolBar()->insertButton(QPixmap((const char**)close_xpm),ID_FILE_CLOSE, true, i18n("Close File"));
  toolBar()->insertButton(QPixmap((const char**)maximize_xpm),ID_VIEW_MAX, true, i18n("Maximize preview"));				
  toolBar()->insertButton(QPixmap((const char**)minimize_xpm),ID_VIEW_MIN, true, i18n("Minimize preview"));
  toolBar()->alignItemRight(ID_VIEW_MIN);
  toolBar()->alignItemRight(ID_VIEW_MAX);
  toolBar()->alignItemRight(ID_FILE_CLOSE);

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE WITH toolBar(n)


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars by their according number
  // connect for invoking the slot actions
  connect(toolBar(), SIGNAL(clicked(int)), SLOT(commandCallback(int)));
  // connect for the status help on holing icons pressed with the mouse button
  connect(toolBar(), SIGNAL(pressed(int)), SLOT(statusCallback(int)));

}

void QuantaApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n(IDS_STATUS_DEFAULT), ID_STATUS_MSG);
}

void QuantaApp::initDocument()
{
  doc = new QuantaDoc(this);

  posURL = 0;
  posDocURL = 0;
}

void QuantaApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.
  pann          = new KNewPanner(this,"test",KNewPanner::Horizontal);
  pann          -> setSeparatorPos(100);
  previewSepPos = 50;
  docFlag       = false;

	pannV = new KNewPanner(pann,"test1",KNewPanner::Vertical);
	
	CTabCtl *tabBar = new CTabCtl( pannV );
	stackDocWrite   = new QWidgetStack( pannV );
	view            = new QuantaView( stackDocWrite, this );
	CTabCtl *tabDoc = new CTabCtl( stackDocWrite );
	
	docBrowser      = new  DocBrowser( tabDoc );
	docBrowser      ->getKHTMLWidget()->setURLCursor( KCursor::handCursor() );
  docBrowser      ->setFocusPolicy(QWidget::NoFocus);
  initDocumentation();

  tabDoc -> addTab( docBrowser, i18n("Documentation browser") );
  tabDoc -> setFocusPolicy(QWidget::ClickFocus);

	stackDocWrite   ->addWidget(view,0);
	stackDocWrite   ->addWidget(tabDoc,1);
	
	stackDocWrite   ->raiseWidget(0);
	
  config->setGroup("General Options");
  	
  homeTopDirs = new QStrList();
  config->readListEntry("Home Top dirs", *homeTopDirs);

  rootTopDirs = new QStrList();
  config->readListEntry("Root Top dirs", *rootTopDirs);

		
	static char homeDir[128];
	strcpy(homeDir, (QString(QDir::home().path())+"/").data());
	TreeView   *treeHome = new TreeView(QPixmap((const char**)home_xpm),i18n("Home directory"), homeDir , tabBar, homeTopDirs);
	TreeView   *treeRoot = new TreeView(QPixmap((const char**)folder_red_xpm),i18n("Root directory"),"/",tabBar, rootTopDirs);
	DocTreeView *treeDoc = new DocTreeView( tabBar );
	
	tabBar->addTab( treeHome, i18n( "&Home") );
	tabBar->addTab( treeRoot, i18n( "&Root") );
	tabBar->addTab( treeDoc,  i18n( "&Doc") );
	
	tabBar->setFocusPolicy(QWidget::ClickFocus);
	
	widStack = new QWidgetStack(pann);
	
  html = new KHTMLView(widStack);
  html->getKHTMLWidget()->setURLCursor( KCursor::handCursor() );
  html->setFocusPolicy(QWidget::NoFocus);

  view->html = html;

  mesOutput = new MessageOutput(kapp, widStack);
  mesOutput->setFocusPolicy(QWidget::NoFocus);
  mesOutput->setReadOnly(TRUE);

  widStack->addWidget(html,0);
  widStack->addWidget(mesOutput,1);

  widStack->raiseWidget(0);

  pannV->activate(tabBar,stackDocWrite);
  pann ->activate(pannV,widStack);

  doc->addView(view);

  setView((QWidget *)pann);
  QString caption=kapp->getCaption();	
  setCaption(caption+": "+doc->getTitle());

  connect(docBrowser, SIGNAL(URLSelected( KHTMLView *, const char*, int, const char *)), SLOT(slotLoadDocUrl( KHTMLView*, const char*, int, const char *)));

  connect(html, SIGNAL(URLSelected( KHTMLView *, const char*, int, const char *)), SLOT(slotLoadUrl( KHTMLView*, const char*, int, const char *)));
  connect(html, SIGNAL(onURL( KHTMLView *, const char*)), SLOT(slotOnURL( KHTMLView*, const char*)));
  connect(mesOutput, SIGNAL(clicked()), this, SLOT(slotClickLint()));

  connect(treeHome, SIGNAL(selectionChanged(QListViewItem *)), SLOT(slotSelectFile(QListViewItem *)));
  connect(treeRoot, SIGNAL(selectionChanged(QListViewItem *)), SLOT(slotSelectFile(QListViewItem *)));
  connect(treeDoc,  SIGNAL(selectionChanged(QListViewItem *)), SLOT(slotSelectDoc(QListViewItem *)));

  connect( view,  SIGNAL(writeSelected(int)), doc,  SLOT(selectWrite(int)));
  connect( tabBar,SIGNAL(tabSelected(int))  , this, SLOT(slotDocSelected(int)));

  connect( docBrowser, SIGNAL(textSelected(KHTMLView *,bool)), this, SLOT(slotClipboardStatus(KHTMLView *,bool)));
}

void QuantaApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_, true);
  toolBar()->setItemEnabled(id_, true);
  doc->writeRBMenu->setItemEnabled(id_, true);
}

void QuantaApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_, false);
  toolBar()->setItemEnabled(id_, false);
  doc->writeRBMenu->setItemEnabled(id_, false);
}


void QuantaApp::checkCommand(int id_, bool stat)
{
  ///////////////////////////////////////////////////////////////////
  viewMenu ->setItemChecked( id_, stat);
	toolBar()->setButton(      id_, stat);
}

void QuantaApp::addRecentFile(const QString &file)
{
  if(recentFiles.find(file) == -1)
  {
    if( recentFiles.count() < 5)
    {
      recentFiles.insert(0, file);
    }
    else
    {
      recentFiles.remove(4);
      recentFiles.insert(0, file);
    }
    recentFilesMenu->clear();
    for ( int i=0 ; i < (int) recentFiles.count(); i++)
    {
      recentFilesMenu->insertItem(recentFiles.at(i));
    }
  }
}

void QuantaApp::openDocumentFile(const char* _cmdl)
{
  slotStatusMsg(i18n("Opening file..."));

  doc->openDocument(_cmdl);
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}


QuantaDoc *QuantaApp::getDocument() const
{
  return doc;
}

void QuantaApp::saveOptions()
{	
  config->setGroup("General Options");
  config->writeEntry("Geometry", size());
  config->writeEntry("Show Toolbar", toolBar()->isVisible());
  config->writeEntry("Show Statusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int) menuBar()->menuBarPos());
  config->writeEntry("ToolBarPos", (int) toolBar()->barPos());
  config->writeEntry("Recent Files", recentFiles);
  config->writeEntry("Preview", viewMenu->isItemChecked(ID_VIEW_PREVIEW) );
  config->writeEntry("TreeWrite", viewMenu->isItemChecked(ID_VIEW_TREE) );

  config->writeEntry("Home Top dirs", *homeTopDirs);
  config->writeEntry("Root Top dirs", *rootTopDirs);

  if ( viewMenu->isItemChecked(ID_VIEW_PREVIEW) ) {
  	if ( docFlag ) config->writeEntry("Separator pos", previewSepPos);
  	        else   config->writeEntry("Separator pos", pann->separatorPos());
  }
  else
  	config->writeEntry("Separator pos", previewSepPos);
  	
  if ( viewMenu->isItemChecked(ID_VIEW_TREE) )
  	config->writeEntry("VSeparator pos", pannV->separatorPos() );
  else
  	config->writeEntry("VSeparator pos", treewriteSepPos);
  	
  doc->write->writeConfig(config);

}


void QuantaApp::readOptions()
{
	
  config->setGroup("General Options");

  // bar status settings
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  viewMenu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  if(!bViewToolbar)
  {
     enableToolBar(KToolBar::Hide);
  }
	
  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  viewMenu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  if(!bViewStatusbar)
  {
    enableStatusBar(KStatusBar::Hide);
  }

  // bar position settings
  KMenuBar::menuPosition menuBarPos;
  menuBarPos=(KMenuBar::menuPosition) config->readNumEntry("MenuBarPos", KMenuBar::Top);

  KToolBar::BarPosition toolBarPos;
  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);

  menuBar()->setMenuBarPos(menuBarPos);
  toolBar()->setBarPos(toolBarPos);
	
  // initialize the recent file list
  recentFiles.setAutoDelete(TRUE);
  config->readListEntry("Recent Files", recentFiles);

  for (int i=0; i < (int) recentFiles.count(); i++)
  {
    recentFilesMenu->insertItem(recentFiles.at(i));
  }


  QSize size=config->readSizeEntry("Geometry");
  if(!size.isEmpty())
  {
    resize(size);
  } else {
  	resize( QSize(780,580) );
  }

  previewSepPos = config->readNumEntry("Separator pos", 65 );

  if ( ! config->readBoolEntry("Preview", true) )
  {
		checkCommand(ID_VIEW_PREVIEW,false);
		pann->setSeparatorPos(100);
	} else {
		checkCommand(ID_VIEW_PREVIEW,true);
		toolBar()->setButton(ID_VIEW_PREVIEW,true);
		pann->setSeparatorPos(previewSepPos);
	}
	
	treewriteSepPos = config->readNumEntry("VSeparator pos", 25 );
	
	if ( ! config->readBoolEntry("TreeWrite", true) )
  {
		checkCommand(ID_VIEW_TREE,false);
		pannV->setSeparatorPos(0);
	} else {
		checkCommand(ID_VIEW_TREE,true);
		pannV->setSeparatorPos(treewriteSepPos);
	}
	
	QRect geom = pann->geometry();
	pann->resize(geom.width()+1,geom.height());
	pann->resize(geom.width()  ,geom.height());
	
	geom = pannV->geometry();
	pannV->resize(geom.width()+1,geom.height());
	pannV->resize(geom.width()  ,geom.height());
	
	doc->write->readConfig(config);

}

void QuantaApp::saveProperties(KConfig *_cfg)
{
  if(doc->getTitle()!=i18n("Untitled") && !doc->isModified())
  {
    // saving to tempfile not necessary

  }
  else
  {
    QString filename=doc->getAbsFilePath();	
    _cfg->writeEntry("filename", filename);
    _cfg->writeEntry("modified", doc->isModified());
		
    QString tempname = kapp->tempSaveName(filename);
    doc->saveDocument(tempname);
  }
}


void QuantaApp::readProperties(KConfig* _cfg)
{
  QString filename = _cfg->readEntry("filename", "");
  bool modified = _cfg->readBoolEntry("modified", false);
  if(modified)
  {
    bool canRecover;
    QString tempname = kapp->checkRecoverFile(filename, canRecover);
  	
    if(canRecover)
    {
      doc->openDocument(tempname);
      doc->setModified();
      QFileInfo info(filename);
      doc->setAbsFilePath(info.absFilePath());
      doc->setTitle(info.fileName());
      QFile::remove(tempname);
    }
  }
  else
  {
    if(!filename.isEmpty())
    {
      doc->openDocument(filename);
    }
  }

  QString caption=kapp->getCaption();	
  setCaption(caption+": "+doc->getTitle());
}		

bool QuantaApp::queryClose()
{
  return doc->saveModified();
}

bool QuantaApp::queryExit()
{
  saveOptions();
  return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void QuantaApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new application window..."));
	
  QuantaApp *new_window= new QuantaApp();
  new_window->show();

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotFileNew()
{
  slotStatusMsg(i18n("Creating new document..."));

  {	
  	doc->newDocument();

    QString caption=kapp->getCaption();	
    setCaption(caption+": "+doc->getTitle());
  }

  view->repaintPreview();

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotFileOpen()
{
  slotStatusMsg(i18n("Opening file..."));
	
  {	
    QString fileToOpen=KFileDialog::getOpenFileName(getDocument()->basePath,
                                                    i18n("*.*htm* *.php* *.asp *.cfm *.css *.jss *.js|HTML files\n*|All files"), this, i18n("Open File..."));
    if(!fileToOpen.isEmpty())
    {
      doc->openDocument(fileToOpen);

      QString caption=kapp->getCaption();	
      setCaption(caption+": "+doc->getTitle());
      addRecentFile(fileToOpen);
      addRecentURL(QString("file:")+fileToOpen);

    }
  }

  view->repaintPreview();

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotFileOpenRecent(int id_)
{
  slotStatusMsg(i18n("Opening file..."));
	
  {
    doc->openDocument(recentFiles.at(id_));
    QString caption=kapp->getCaption();	
    setCaption(caption+": "+doc->getTitle());
  }

  view->repaintPreview();

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotFileSave()
{
  slotStatusMsg(i18n("Saving file..."));
	
  if ( !getDocument()->write->hasFileName() )
  	slotFileSaveAs();
  else
  	doc->saveDocument(doc->getAbsFilePath());

  view->repaintPreview();

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotFileSaveAs()
{
  slotStatusMsg(i18n("Saving file with a new filename..."));

  QString newName=KFileDialog::getSaveFileName(getDocument()->basePath,
                                               i18n("*.*htm* *.php* *.asp *.cfm *.css *.jss *.js|HTML files\n*|All files"), this, i18n("Save as..."));
  if(!newName.isEmpty())
  {
    QFileInfo saveAsInfo(newName);
    doc->setTitle(saveAsInfo.fileName());
    doc->setAbsFilePath(saveAsInfo.absFilePath());

    doc->write->setModified( true);
    doc->saveDocument(newName);
    addRecentFile(newName);

    QString caption=kapp->getCaption();	
    setCaption(caption+": "+doc->getTitle());
  }

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotFileClose()
{
  slotStatusMsg(i18n("Closing file..."));

  if( !doc->write->canDiscard() )
  {
     // here saving wasn't successful
  }
  else
  {
    doc->closeDocument();
    QString caption=kapp->getCaption();	
    setCaption(caption+": "+doc->getTitle());
  }

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));
  html->print();
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotFileQuit()
{
  slotStatusMsg(i18n("Exiting..."));

 	saveOptions();
 	// close the first window, the list makes the next one the first again.
 	// This ensures that queryClose() is called on each window to ask for closing
 	KTMainWindow* w;
 	if(memberList)
 	{
   	for(w=memberList->first(); w!=0; w=memberList->next())
   	{
     	// only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
     	// the window and the application stay open.
      //if ( ((QuantaApp *)w)->doc->write->canQuit() ) {	
      	if(!w->close());
      //}
			//break;
    }
  }	
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));
  doc->write->cut();
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to clipboard..."));
  if ( docFlag)
    docBrowser->slotCopyText();
  else
    doc->write->copy();

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting clipboard contents..."));
  doc->write->paste();
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotViewToolBar()
{
  slotStatusMsg(i18n("Toggle the toolbar..."));
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  if( viewMenu->isItemChecked(ID_VIEW_TOOLBAR))
  {
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, false);
    enableToolBar(KToolBar::Hide);
  }
  else
  {
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, true);
    enableToolBar(KToolBar::Show);
  }		

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotViewStatusBar()
{
  slotStatusMsg(i18n("Toggle the statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  if( viewMenu->isItemChecked(ID_VIEW_STATUSBAR))
  {
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, false);
    enableStatusBar(KStatusBar::Hide);
  }
  else
  {
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, true);
    enableStatusBar(KStatusBar::Show);
  }

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}


void QuantaApp::slotStatusMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG);
}


void QuantaApp::slotStatusHelpMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}



void QuantaApp::commandCallback(int id_)
{
  switch (id_)
  {
    case ID_FILE_NEW_WINDOW:
         slotFileNewWindow();
    	 	 break;

    case ID_FILE_NEW:
    	 	 slotFileNew();
         break;

    case ID_FILE_OPEN:
         slotFileOpen();
         break;

    case ID_FILE_LINT:
         slotLint();
         break;

    case ID_FILE_SAVE:
         slotFileSave();
         break;

    case ID_FILE_SAVE_AS:
         slotFileSaveAs();
         break;

    case ID_FILE_SAVE_ALL:
         slotFileSaveAll();
         break;

    case ID_FILE_CLOSE:
         slotFileClose();
         break;

    case ID_FILE_PRINT:
         slotFilePrint();
         break;

    case ID_FILE_QUIT:
         slotFileQuit();
         break;

    case ID_EDIT_CUT:
         slotEditCut();
         break;

    case ID_EDIT_COPY:
         slotEditCopy();
         break;

    case ID_EDIT_PASTE:
         slotEditPaste();
         break;

    case ID_EDIT_UNDO:
         view->write()->undo();
         break;

    case ID_EDIT_REDO:
         view->write()->redo();
         break;

    case ID_EDIT_SEARCH:
         view->write()->search();
         break;

    case ID_EDIT_SEARCH_AGAIN:
         view->write()->searchAgain();
         break;

    case ID_EDIT_REPLACE:
         view->write()->replace();
         break;
  
    case ID_VIEW_TOOLBAR:
         slotViewToolBar();
         break;

    case ID_VIEW_STATUSBAR:
         slotViewStatusBar();
         break;

    case ID_VIEW_TREE:
    		 slotViewTree();
    		 break;
    		
    case ID_VIEW_MES:
    		 slotViewMes();
    		 break;
    		
    case ID_VIEW_PREVIEW:
    		 slotViewPreview();
    		 break;

    case ID_VIEW_BACK:
    		 slotViewBack();
    		 break;
    		
    case ID_VIEW_FORWARD:
    		 slotViewForward();
    		 break;
    		
    case ID_VIEW_REPAINT:
    		 slotViewRepaint();
    		 break;
    		
    case ID_OPTIONS_EDITOR:
    		 doc->write->optDlg();
    		 doc->write->writeConfig( kapp->getConfig() );
    		 break;
    		
    case ID_OPTIONS_DEFAULTS:
    		 doc->write->hlDef();
    		 doc->write->writeConfig( kapp->getConfig() );
    		 break;
    		
    case ID_VIEW_MIN:
         slotViewMin();
    		 break;
    		
    case ID_VIEW_MAX:
         slotViewMax();
    		 break;
    		

    default:
         break;
  }
}

void QuantaApp::statusCallback(int id_)
{
  switch (id_)
  {
    case ID_FILE_NEW_WINDOW:
         slotStatusHelpMsg(i18n("Opens a new application window"));
         break;

    case ID_FILE_NEW:
         slotStatusHelpMsg(i18n("Creates a new document"));
         break;

    case ID_FILE_OPEN:
         slotStatusHelpMsg(i18n("Opens an existing document"));
         break;

    case ID_FILE_OPEN_RECENT:
         slotStatusHelpMsg(i18n("Opens a recently used file"));
         break;

    case ID_FILE_SAVE:
         slotStatusHelpMsg(i18n("Saves the actual document"));
         break;

    case ID_FILE_SAVE_AS:
         slotStatusHelpMsg(i18n("Saves the actual document as..."));
         break;

    case ID_FILE_CLOSE:
         slotStatusHelpMsg(i18n("Closes the actual document"));
         break;

    case ID_FILE_PRINT:
         slotStatusHelpMsg(i18n("Prints out the actual document"));
         break;

    case ID_FILE_QUIT:
         slotStatusHelpMsg(i18n("Quits the application"));
         break;

    case ID_EDIT_CUT:
         slotStatusHelpMsg(i18n("Cuts the selected section and puts it to the clipboard"));
         break;

    case ID_EDIT_COPY:
         slotStatusHelpMsg(i18n("Copies the selected section to the clipboard"));
         break;

    case ID_EDIT_PASTE:
         slotStatusHelpMsg(i18n("Pastes the clipboard contents to actual position"));
         break;

    case ID_VIEW_TOOLBAR:
         slotStatusHelpMsg(i18n("Enables/disables the toolbar"));
         break;

    case ID_VIEW_STATUSBAR:
         slotStatusHelpMsg(i18n("Enables/disables the statusbar"));
         break;

    default:
         break;
  }
}

/** Repaint preview */
void QuantaApp::slotViewRepaint(){
	slotStatusMsg(i18n("Repainting..."));
	view->repaintPreview();
	slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

/** Selection base directry for HTML files */
void QuantaApp::slotFileDirSelect(){
	 getDocument()->basePath = KFileDialog::getDirectory(QDir::currentDirPath(),this, i18n("Directory selection..."));
	 slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

/** Load document from Url
when You select link in preview window */
void QuantaApp::slotLoadUrl (KHTMLView *_view, const char *_url, int _button, const char *_target ){
	slotStatusMsg(i18n("Loading file from URL..."));
  loadUrl(_url);
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}
/** connected to KHtmlView onURL signal */
void QuantaApp::slotOnURL ( KHTMLView *_view, const char *_url ){
	slotStatusMsg(QString(_url));
	slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}
/** add url to list for back/forward navigation */
void QuantaApp::addRecentURL(const QString &url)
{
    if( recentURLs.count() < 20)
    {
      recentURLs.insert( posURL, url);
      for ( int i=posURL;i>0;i--) {
      	recentURLs.remove((unsigned int)0);
      }
      posURL = 0;
    }
    else
    {
      recentURLs.remove(19);
      recentURLs.insert(posURL, url);
      for ( int i=posURL;i>0;i--) {
      	recentURLs.remove((unsigned int)0);
      }
      posURL = 0;
    }
}

/** add url to list for back/forward navigation */
void QuantaApp::addRecentDocURL(const QString &url)
{
    if( recentDocURLs.count() < 20)
    {
      recentDocURLs.insert( posDocURL, url);
      for ( int i=posDocURL;i>0;i--) {
      	recentDocURLs.remove((unsigned int)0);
      }
      posDocURL = 0;
    }
    else
    {
      recentDocURLs.remove(19);
      recentDocURLs.insert(posDocURL, url);
      for ( int i=posDocURL;i>0;i--) {
      	recentDocURLs.remove((unsigned int)0);
      }
      posDocURL = 0;
    }
}

/** back navigation */
void QuantaApp::slotViewBack(){
  if (docFlag) {
    int count = recentDocURLs.count()-1;
	  if ( count > posDocURL ) {
	  	posDocURL++;
	  	QString url = recentDocURLs.at(posDocURL);
	  	openInDocBrowser( url,false );
	  }
  } else {
	  int count = recentURLs.count()-1;
	  if ( count > posURL ) {
	  	posURL++;
	  	QString url = recentURLs.at(posURL);
	  	loadUrl( url.data(),false);
	  }
	}
	
	slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

/** forwadr navigation */
void QuantaApp::slotViewForward()
{
  if (docFlag) {
    if ( posDocURL>0 ) {
	  	posDocURL--;
	  	QString url = recentDocURLs.at(posDocURL);
	  	openInDocBrowser( url,false );
	  }
  } else {
	  if ( posURL>0 ) {
	  	posURL--;
	  	QString url = recentURLs.at(posURL);
	  	loadUrl( url.data(),false);
	  }
	}
	slotStatusMsg(i18n(IDS_STATUS_DEFAULT));	
}

/** load document from url */
void QuantaApp::loadUrl(const char *_url,bool saveRecent=true){
	QString url(_url);

  if ( url.left(5) == "file:" ) {
  	  _url+=5; // cut file://
  	  char anchor[128];
  	  *anchor=0;
  		
  	  if ( char *end = strstr(_url,"#") ) {
  	  	strncpy(anchor,end+1,128);
  	  	*end = 0;
  	  }
  		  		
  		QFile fileToOpen(_url);
   		if( fileToOpen.exists())
   		{
   			doc->openDocument(_url);
    		QString caption=kapp->getCaption();	
     		setCaption(caption+": "+doc->getTitle());
     		
     		if ( saveRecent ) addRecentURL( url );
     		
     		if ( posURL == 0 )
     					disableCommand(ID_VIEW_FORWARD);
     		else
     					enableCommand(ID_VIEW_FORWARD);
     					
     		if ( posURL+1 ==  (int)recentURLs.count() )
     					disableCommand(ID_VIEW_BACK);
     		else
     					enableCommand(ID_VIEW_BACK);
     					
      		
     		if (*anchor)
     			html->gotoAnchor(anchor);
    	}

  }
  else if( url.left(5) == "http:" ) {
  	KProcess showHtml;
  	showHtml << "kfmclient" << "exec" << url.data();
  	showHtml.start( KProcess::DontCare);
  }
}
/** change undo/redo status */
void QuantaApp::slotNewUndo(){
	 int state = view->write()->undoState();
	 //undo
   if(state & 1)
 			enableCommand(ID_EDIT_UNDO);
   else
			disableCommand(ID_EDIT_UNDO);
   //redo
   if(state & 2)
      enableCommand(ID_EDIT_REDO);
   else
      disableCommand(ID_EDIT_REDO);
   slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}
/** for check tree on/off */
void QuantaApp::slotViewTree(){
	slotStatusMsg(i18n("Tree on/off..."));
	
	if (viewMenu->isItemChecked(ID_VIEW_TREE)) {
		checkCommand(ID_VIEW_TREE,false);
		
		treewriteSepPos = pannV->separatorPos();
		pannV->setSeparatorPos(0);
	} else {
		checkCommand(ID_VIEW_TREE,true);
		
		pannV->setSeparatorPos(treewriteSepPos);
	}
	
	QRect geom = pannV->geometry();
	pannV->resize(geom.width()+1,geom.height());
	pannV->resize(geom.width()  ,geom.height());
	
	slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}
/** handle events from treeview
connected to double click */
void QuantaApp::slotSelectFile(QListViewItem *item){

	Directory *parent = (Directory *) item->parent();
	if (!parent) return;
	QString name = QString(parent->fullName()) + item->text(0);
	QString fname = QString("file:") + name;

	if ( KDir::match( htmlFilter, name) ) {
		loadUrl(fname.data());
		addRecentFile(fname.data());
		
		QString caption=kapp->getCaption();	
    setCaption(caption+": "+doc->getTitle());
	}

	if ( KDir::match( imageFilter, name) ) {
		loadImage(fname.data());
	}
	
	slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}
/** Load image ( gif / jpeg ) and generate
<img> tag for it */
void QuantaApp::loadImage( const char* fname){
	QString url(fname);

  if ( url.left(5) == "file:" ) {
    fname+=5; // cut file://
  	
  	QFile fileToOpen(fname);
  		
  	if( fileToOpen.exists())
  	{
  		QString tag;
  		tag = "<center>\n<img src=\"";
  		tag += fileToOpen.name();
  		tag += "\">\n</center>";
     		
      html->begin( fname);
      html->parse();

      html->write( tag);

      html->end();
      html->show();
    }
  }
}

/** run Weblint for syntax checking */
void QuantaApp::slotLint(){
  slotFileSave();

  if ( !viewMenu->isItemChecked(ID_VIEW_MES) )
      slotViewMes();

  mesOutput->clear();
  mesOutput->insertAtEnd(QString(i18n("Weblint output:\n")));

  QString filename = doc->getAbsFilePath();
  char * fname = filename.data();

  QFileInfo file( fname);

  if ( !file.isFile() ) {
    mesOutput->insertAtEnd(QString(i18n("Error: file not found:\n")));
    return;
  }

  proc = new KProcess();
  proc ->clearArguments();
  *proc << "weblint";
  *proc << "-s" << "-x" << "Netscape";
  *proc << fname;

  connect( proc, SIGNAL(receivedStdout(KProcess*,char*,int)), this,
            SLOT(slotGetLintOutput(KProcess*,char*,int)));
  proc->start(KProcess::NotifyOnExit, KProcess::AllOutput);

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

/**  */
void QuantaApp::slotGetLintOutput(KProcess *proc, char *buffer, int buflen)
{
  mesOutput->insertAtEnd(QString(buffer,buflen+1));
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

/** slot for toggle preview */
void QuantaApp::slotViewPreview(){
	slotStatusMsg(i18n("Preview on/off..."));
	
	if (viewMenu->isItemChecked(ID_VIEW_PREVIEW)) {
	  view->saveScroll();
	
		checkCommand(ID_VIEW_PREVIEW,false);
		
		previewSepPos = pann->separatorPos();
		pann->setSeparatorPos(100);
	
		QRect geom = pann->geometry();
	  pann->resize(geom.width()+1,geom.height());
	  pann->resize(geom.width()  ,geom.height());
	} else {
	  // if view otgat
	  if (viewMenu->isItemChecked(ID_VIEW_MES))
	    previewSepPos = pann->separatorPos();
	
		checkCommand(ID_VIEW_PREVIEW,true);
		checkCommand(ID_VIEW_MES,false);
		
		view->repaintPreview( false);
		
		pann->setSeparatorPos(previewSepPos);
		widStack->raiseWidget(0);
		
		QRect geom = pann->geometry();
	  pann->resize(geom.width()+1,geom.height());
	  pann->resize(geom.width()  ,geom.height());
	
	  view->setScroll();
	}
	
	slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

/** view messages window on/off */
void QuantaApp::slotViewMes(){
  slotStatusMsg(i18n("Messages window on/off..."));
	
	if (viewMenu->isItemChecked(ID_VIEW_MES)) {
		checkCommand(ID_VIEW_MES,false);
		
		previewSepPos = pann->separatorPos();
		pann->setSeparatorPos(100);
	
	} else {
	  /** if mes otgat */
	  // nagat mes
	  if (viewMenu->isItemChecked(ID_VIEW_PREVIEW))
	    previewSepPos = pann->separatorPos();
	
		checkCommand(ID_VIEW_MES,true);
		checkCommand(ID_VIEW_PREVIEW,false);
		
		pann->setSeparatorPos(previewSepPos);
		widStack->raiseWidget(1);
	}
	
	QRect geom = pann->geometry();
	pann->resize(geom.width()+1,geom.height());
	pann->resize(geom.width()  ,geom.height());
	
	slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

/** 
connected to  signal  click from MessageOutput
 */
void QuantaApp::slotClickLint()
{
  int mline = mesOutput->currentLine();
  const char *tmp = mesOutput->text();

  for ( int i=0; i<mline; i++ ) {
    if ( !(tmp = strstr(tmp,"\n")) )
      return;
    tmp++;
  }

  tmp+=4;

  int line;
  if ( !sscanf(tmp,"%d",&line) ) return;
  if ( line < 1 ) return;

  view->write()->setCursorPosition(line-1,0);
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotEditUndo(){
  doc->write->undo();
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotEditRedo(){
  doc->write->redo();
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotEditSearch(){
  doc->write->search();
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotEditSearchAgain(){
  doc->write->searchAgain();
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void QuantaApp::slotEditReplace(){
  doc->write->replace();
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}


/** save all files */
void QuantaApp::slotFileSaveAll(){
  slotStatusMsg(i18n("Saving file..."));
  doc->saveAll();
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}
/** slot for new modify flag */
void QuantaApp::slotNewStatus(){
  if ( doc->isModified() ) {
    enableCommand(ID_FILE_SAVE);
  } else {
    disableCommand(ID_FILE_SAVE);
  }
}
/** new mark staus */
void QuantaApp::slotMarkStatus(KWriteView *, bool status){
  if ( status ) {
    enableCommand(ID_EDIT_CUT);
    enableCommand(ID_EDIT_COPY);
  } else {
    disableCommand(ID_EDIT_CUT);
    disableCommand(ID_EDIT_COPY);
  }
}

/** new clipboard staus */
void QuantaApp::slotClipboardStatus(KWriteView *, bool status){
  if ( status ) {
    enableCommand(ID_EDIT_PASTE);
  } else {
    disableCommand(ID_EDIT_PASTE);
  }
}

/** maximize preview window */
void QuantaApp::slotViewMax()
{
    if ( widStack->id( widStack->visibleWidget() )) {
      checkCommand(ID_VIEW_MES,true);
    } else {
      checkCommand(ID_VIEW_PREVIEW,true);
		}

		int pos = pann->separatorPos();
		
		//view->repaintPreview( true);
		
		if ( pos != 0 && pos < 100) {
		  //view->saveScroll();
  		previewSepPos = pann->separatorPos();
  		pann->setSeparatorPos(0);
  	} else {	
  	  if ( pos >= 100 ) {
  	    pann->setSeparatorPos( previewSepPos );
  	    previewSepPos = 0;
  	  } else
  	    pann->setSeparatorPos( previewSepPos );
  	}
		
  	QRect geom = pann->geometry();
	  pann->resize(geom.width()+1,geom.height());
	  pann->resize(geom.width()  ,geom.height());
	
	  view->setScroll();
}

/** minimize preview window */
void QuantaApp::slotViewMin()
{
		view->saveScroll();
		
		int pos = pann->separatorPos();
		
		if ( pos < 100 && pos > 0) previewSepPos = pos;
		
		pann->setSeparatorPos(100);
		
		checkCommand(ID_VIEW_PREVIEW,false);
		checkCommand(ID_VIEW_MES,false);
		
  	QRect geom = pann->geometry();
	  pann->resize(geom.width()+1,geom.height());
	  pann->resize(geom.width()  ,geom.height());
}
/** select doc/tree etc */
void QuantaApp::slotDocSelected(int id)
{
  static int posSep;

  if ( id == 2) { // doc selected
    docFlag = true;

    posSep  = pann->separatorPos();
    pann    ->setSeparatorPos(100);

    disableCommand(ID_VIEW_PREVIEW);
    disableCommand(ID_VIEW_MES);
    disableCommand(ID_VIEW_MIN);
    disableCommand(ID_VIEW_MAX);
    disableCommand(ID_FILE_CLOSE);

    if ( posDocURL == 0 ) disableCommand(ID_VIEW_FORWARD);
    else enableCommand(ID_VIEW_FORWARD);
    if ( posDocURL+1 ==  (int)recentDocURLs.count() )
  	  disableCommand(ID_VIEW_BACK);
    else enableCommand(ID_VIEW_BACK);

    stackDocWrite->raiseWidget(1);
  }
  else {
    stackDocWrite->raiseWidget(0);

    enableCommand(ID_VIEW_PREVIEW);
    enableCommand(ID_VIEW_MES);
    enableCommand(ID_VIEW_MIN);
    enableCommand(ID_VIEW_MAX);
    enableCommand(ID_FILE_CLOSE);

    if ( docFlag ) {
      if ( posURL == 0 ) disableCommand(ID_VIEW_FORWARD);
      else enableCommand(ID_VIEW_FORWARD);
      if ( posURL+1 ==  (int)recentURLs.count() )
  	    disableCommand(ID_VIEW_BACK);
      else enableCommand(ID_VIEW_BACK);

      pann ->setSeparatorPos( posSep );
    }
    else
      pann ->setSeparatorPos( previewSepPos );

    docFlag = false;
  }

  QRect geom = pann->geometry();
  pann->resize(geom.width()+1,geom.height());
	pann->resize(geom.width()  ,geom.height());
}
/** init documentation main page */
void QuantaApp::initDocumentation()
{
  QString name = kapp->kde_datadir()+"/quanta/doc/";
	name+="olist.html";
	openInDocBrowser( name );
}
/** slot for select documentation file */
void QuantaApp::slotSelectDoc(QListViewItem *item){
	
	QString name = kapp->kde_datadir()+"/quanta/doc/";
	
	if ( dynamic_cast<DocItem*>(item) )
	  name+= ((DocItem *)item)->url;
	else
	  name+="olist.html";
	
	openInDocBrowser( name );
	
	slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}
/**  */
void QuantaApp::openInDocBrowser( QString name, bool addRecent=true )
{
	QString anchor = "";
  int pos;
  if ( ( pos = name.find('#') ) != -1 ) {
    anchor = name.mid(pos+1,9999);
    name=name.left(pos);
  }

	QFile file( name.data() );
	
	if ( !file.exists() )
	  return;
	
	docBrowser->begin( name );
  docBrowser->parse();

  file.open( IO_ReadOnly );

  char buffer[512];
  char *buf = (char *)buffer;

  while ( ( file.readLine( buf, 512)) > 0 )
    docBrowser->write( buf );

  file.close();

  docBrowser->end();
  docBrowser->show();

  docBrowser->repaint();

  if ( anchor!="" )
    docBrowser->gotoAnchor( anchor.data() );

  if ( addRecent ) addRecentDocURL( name );
     		
  if ( posDocURL == 0 )
    disableCommand(ID_VIEW_FORWARD);
  else
    enableCommand(ID_VIEW_FORWARD);
     					
  if ( posDocURL+1 ==  (int)recentDocURLs.count() )
  	disableCommand(ID_VIEW_BACK);
  else
  	enableCommand(ID_VIEW_BACK);
}
/** slot for load html doc file on click */
void QuantaApp::slotLoadDocUrl( KHTMLView*, const char* url, int, const char *)
{
  QString URL = url;
  if ( URL.left(5) == "file:" ) URL.remove(0,5);

  openInDocBrowser( URL );
}

/** enable/disabe copy menu */
void QuantaApp::slotClipboardStatus( KHTMLView *_view, bool _selected )
{
  if ( _selected )
    enableCommand(ID_EDIT_COPY);
  else
    disableCommand(ID_EDIT_COPY);
}
