/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef WINEDIT_H
#define WINEDIT_H

#include <qwidget.h>
#include <qstring.h>
#include <qscrollbar.h>
#include <qevent.h>
#include <qfile.h>
#include <qdir.h>
#include <kmsgbox.h>

#include "topwin.h"
#include "subwidget.h"
#include "morewidgets.h"
#include "infman.h"
#include "prfilter.h"
#include "Dec.h"

#define BORDER 10
#define SC_W 17

/****************************************************************************
	class winedit:
This class is the central widget of the window/form editor. It manages
all sub widgets, both real sub widgets ( "sub windows" ) and one leven
widgets ( like buttons, labels ). WINEDIT is also responsible for loading/saving
form files and for regional variables, consts and functions.
****************************************************************************/

class winedit : public QWidget
{
	Q_OBJECT

public:
	/* Constructor: NOT winedit(parent, name) but (parent, FILENAME);
	   if FILENAME is 0L, no file will be opened at the beginning.*/
	winedit( QWidget *, const char * );

	/* Save the files, one file for the top level window, and each
	   one for every sub widget (excepted those without the right
	   of having own childs [like labels, buttons] ). The files
	   are called WIDGET_NAME.vkf (or .vktf for top level window),
	   and are stored in the actual directory.
	   Returns true if succeeded, false if no directory was set
	   or if save failed. */
	bool save();

	/* Close the actual file(s) and opens a new window (= FILE->NEW )
	   Returns false only if canceld by the user! */
	bool closeAndNew();

	/* Open the file given in newName and all sub widget files.
	   Sets the actual directory to the directory within the file.
	   Returns true if succeeded, false if not. */
	bool open( const char *newName );

	/* Sets the directory to newDir. This is necessary before
	   save() is called for the first time with a new window form.
	   Returns true if succeeded, false if not.*/
	bool setDir( const char *newDir );

	/* Returns true, if a directory is set, false if not.
	   Check it, before you call save() ! */
	bool hasName();

	/* Has the document been modified since last saving ? */
	inline bool isModified() { return modified; }

	/* Set the tool, I should actually work with. Tool IDs are
	   declared in Dec.h and are something like ID_NO_TOOL (pointer)
	   or ID_BUTTON (draw new button) */
	void setTool( int nTool );


	/* This function writes pointers to all widgets of type wt (e.g. "Button")
	   in the widgetHolder array rnames[x], or 0L, if there aren't so many widgets
	   of this type in the window. x is 0-MAX_SUBS */
	void getSubs( QString wt, widgetHolder *wids[] );


public slots:
	/* Tells winedit, that something in it has been modified: */
	void setModified();

signals:
	/* Reset tools ==> Activete pointer tool (ID_NO_TOOL) */
	void resetToolSignal();
	void showEvent(QString,QString);

private:
	QString dirNme( QString );
	QString pureName( QString );

	QString nameOf( widgetHolder * );

	QString addPrOf( widgetHolder *, QString );
	bool saveWid( widgetHolder *, bool=false );

	bool close();

	void openWid( const char *, widgetHolder *parent=0L );

	virtual void resizeEvent( QResizeEvent * );

	/* Constructs/deletes the scrollbars, and set their actual values: */
	void setScrollBars( int, int );

	/* To control setScrollBars: */
	void checkZoom();

	/* This function returns whether a sub widget of par has the
	   name tName, excepted widget exc: */
	bool hasSWName( QWidget *par, QString tName, QWidget *exc );

	bool modified;
	int tool;

	QString fn;
	QString dirName;

	QScrollBar *hBar; bool haveHBar;
	QScrollBar *vBar; bool haveVBar;
	QWidget *dWid;

	topWin *win;

	subWin *swins[MAX_SUBS];
	subButton *sbut[MAX_SUBS];
	subLabel *slab[MAX_SUBS];
	subPixLabel *splab[MAX_SUBS];
	subEdit *sedi[MAX_SUBS];
	subList *slist[MAX_SUBS];
	subCheckBox *schk[MAX_SUBS];
	subOptionButton *sopt[MAX_SUBS];
	subSlider *shscr[MAX_SUBS];
	subProcCtrl *spr[MAX_SUBS];

	int actualI;

private slots:
	void hScrolled(int);
	void vScrolled(int);

	void mr();
	void newWidget( int, int, int, int, widgetHolder * );

	void resetTool();

	void deleteWid( widgetHolder * );

	void resetOptButtons( QWidget *, QWidget * );

	void nameExists( QString, widgetHolder * );

	void showEvt(QString,QString);

};

#endif
