/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef WHOLDER_H
#define WHOLDER_H

#include <qwidget.h>
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qevent.h>
#include <qkeycode.h>
#include <qpalette.h>
#include <qcolor.h>
#include <kpopmenu.h>
#include <qpoint.h>
#include <qrect.h>
#include <qpoint.h>
#include <qdir.h>

#include "pedi.h"
#include "Dec.h"

//Only to use by class widgetHolder:
class ptWidget : public QWidget
{
	Q_OBJECT

public:
	ptWidget( QWidget * );

	void showIt( bool isActive );
	void setActive( bool isActive );


signals:
	void moved( int, int );
	void mr();
	void mReject();


protected:
	virtual void mousePressEvent( QMouseEvent *e );
	virtual void mouseReleaseEvent( QMouseEvent *e );
	virtual void mouseMoveEvent( QMouseEvent *e );


private:
	bool moveMode;
	int mX, mY;


};



/*******************************************************************************
	class widgetHolder:
This is a minimal implementation of a widget, that can be used as a
visible object (window, sub widget, button ,label, ...) in the window
editor. You must reimplement it in a concrete object class to use it!
*******************************************************************************/

class widgetHolder : public QWidget
{

	Q_OBJECT

public:
	//Constructor:
	widgetHolder( widgetHolder *parent );
	widgetHolder( QWidget *parent );

	/* Returns my properties in the first QString, and their values in
	   the second one: */
	void getProperties( QString [], QString [] );

	/* Returns a pointer on my parent (QWidget): */
	inline QWidget *getParent() { return myParent; }

	/* Returns a pointer on my parent (widgetHolder or 0L): */
	inline widgetHolder *getWhParent() { return whParent; }

	/* This overwrites Qt's move(...): I need this, since I want,
	   that move also causes a resizeEvent. */
	void move (int, int);


	// Ooops! The following three functions are useless, so I commented them out:

	/* If I'm a window or a subwidget, you may set my regional
	   variables here, their names in n and their initial values
	   in v. IMPORTANT: Both n and v must have an array length
	   of AT LEAST 512 !!!*/
	//void setVars( QString n[], QString v[] );

	/* If I'm a window or a subwidget, you may set my regional
	   constants here, their names in n and their values
	   in v. IMPORTANT: Both n and v must have an array length
	   of AT LEAST 512 !!!*/
	//void setConsts( QString n[], QString v[] );

	/* If I'm a window or a subwidget, you may set my regional
	   functions here, their names in n and their argument numbers
	   in v (as string). IMPORTANT: Both n and v must have an array length
	   of AT LEAST 512 !!!*/
	//void setFuncs( QString n[], QString v[] );

	/* Returns a pointer on the names of my regional variables:
	   You may use it to read AND to change variable data. */
	QString *getVarNames();

	/* Returns a pointer on the names of my regional constants:
	   You may use it to read AND to change variable data. */
	QString *getConstNames();

	/* Returns a pointer on the names of my user defined functions:
	   You may use it to read AND to change function data. */
	QString *getFuncNames();

	// Returns a pointer on the (initial) values of my regional variables:
	QString *getVarVals();

	// Returns a pointer on the values of my regional constants:
	QString *getConstVals();

	/* Returns a pointer on the number (number as string, e.g. "12")
	   of arguments for each of my function: */
	QString *getFuncVals();

	/* Sets the result of the latest name check: */
	inline void setNResult(bool b) { nResult = b; }

	/* Invokes a name check: */
	void forceNameCheck();

public slots:
	void changeProperty( QString prop, QString val );
	inline void setTool( int t ) { tool = t; }

signals:
	void mr();
	void newWidget( int, int, int, int, widgetHolder * );
	void resetTool();
	void modified();
	void deleteMe( widgetHolder * );
	void testName( QString, widgetHolder * );
	void showEvent( QString, QString );

	void nameOk(bool);

protected:
	void buildProperties( QString prop[], QString val[] );

	void setImage( QPixmap );

	virtual void newProperties( QString prop[], QString val[] ) = 0;

	bool allowSubs;
	bool haveXY;

	int ownType;

private:

	void constr();

	void redraw();
	void resetZPs();

	void runSrcEdit( QString );

	virtual void resizeEvent( QResizeEvent * );
	virtual void paintEvent( QPaintEvent * );
	virtual void focusInEvent( QFocusEvent * );
	virtual void focusOutEvent( QFocusEvent * );

	virtual void mousePressEvent( QMouseEvent * );
	virtual void mouseMoveEvent( QMouseEvent * );
	virtual void mouseReleaseEvent( QMouseEvent * );

	virtual void keyPressEvent( QKeyEvent * );


	QString props[2][100];

	QPixmap myPix;

	ptWidget *zoomPoints[8];

	int activeZP;

	KPopupMenu *menu, *emenu;

	propEditDialog *pedi;

	int tool;

	int mX, mY;
	bool moveMode;

	int sX, sY;
	bool sMode;

	bool nResult;

	QWidget *sLines[4];
	QPoint *fp, *sp;

	widgetHolder *whParent;
	QWidget *myParent;

	QString rVars[2][512];
	QString rConsts[2][512];
	QString rFuncs[2][512];


private slots:

	void moveP1( int, int );
	void moveP2( int, int );
	void moveP3( int, int );
	void moveP4( int, int );
	void moveP5( int, int );
	void moveP6( int, int );
	void moveP7( int, int );
	void moveP8( int, int );

	void moveOK();
	void moveCancel();

	void editProps();

	void editEStart();
	void editEClick();
	void editEChanged();
	void editEReturn();
	void editEExited();

	void emitDel() { emit deleteMe(this); }

	void checkName(QString);
};


#endif
