/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef VFDIALOG_H
#define VFDIALOG_H

#include <qdialog.h>
#include <qtabdialog.h>
#include <qstring.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qevent.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <kmsgbox.h>
#include <qregexp.h>

#include "Dec.h"


/* NOTE: All these classes are only for the stand alone version of KWinEdit,
	and they will be useless in the IDE !!! */

//Defines the type of the dialogs
enum iTypes { Variable, Constant, Function };

/******************************************************************************
	class addDialog:
A small dialog with two QLineEdit widgets, to add a list entry (Variable name
+ value or function name + number of arguments) to a inVFD widget (see below).
*******************************************************************************/

class addDialog: public QDialog
{
	Q_OBJECT

public:
	//Constructor of the (parentless) dialog
	addDialog();

	/* Sets the dialog type (to enum itype);
	   Types differs in label text and in some checks. */
	void setType(iTypes);

	/* Returns the new variable or function name (text in the first
	   QLineEdit) or "" if caceled. */
	QString newEntry();

	/* Returns the new variable value or number of function arguments
	   (text in the second QLineEdit) or "" if caceled. */
	QString newArgument();

private:
	virtual void resizeEvent( QResizeEvent * );

	bool isOK;

	QLabel *label;
	QLineEdit *fl, *sl;

	QPushButton *ok, *cancel;

	iTypes myType;

private slots:
	void okClick();
	void cancelClick();

};


/******************************************************************************
	class inVFD:
Widget for the tabDialog below. It has a text label, describing its function,
a list widget for varibles or functions, an add and a remove button.
******************************************************************************/
class inVFD : public QWidget
{
	Q_OBJECT

public:
	//Constructor; (enum) iTypes is the dialog type
	inVFD( QWidget *parent, iTypes );

	//Set the label text (information for the user):
	void setText( QString );

	//Set predefined entries (name, value):
	void setEntries( QString[], QString[] );

	//Turns the modified entries/values in the two QString arrays
	void getEntries( QString[], QString[] );

private:
	virtual void resizeEvent( QResizeEvent * );

	QLabel *label;

	int boxIndex;

	QListBox *box;

	QPushButton *addButton, *rmButton;

	QString entrs[2][512];

	addDialog *nd;

	iTypes myType;

private slots:
	void highlighted( int );

	void add();
	void rm();
};



/****************************************************************************
	class vfDialog:
Modal dialog, which allows to
add and to remove entries in different sections (each one for
one widget in the form editor).

WARNING: This dialog probably won't work with too many widgets in the
form editor, since QTabDialog provides only a one-line-TabBar, and I need
a tab widget for every sub window !!!
****************************************************************************/

class vfDialog : public QTabDialog
{
	Q_OBJECT

public:
	//Constructor; type must be one of "Variable", "Constant" or "Function"
	vfDialog( QString type );

	/* Add a new tab widget for sub window 'name' with allready
	   registered variables/functions in vf[] with value vfv: */
	void setMember( QString name, QString vf[], QString vfv[] );


	/* This function saves the modified list of the variable/function names of
	   the specified member in FS and its values in VS.*/
	void getMember( QString memberName, QString FS[], QString VS[] );

private:
	inVFD *widgets[MAX_SUBS];
	int wIndex;

	QString myType;

	QString subNames[MAX_SUBS];

};

#endif