/*************************************************************
*
* (c) 1999, 2000 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef MOREWIDGETS_H
#define MOREWIDGETS_H

#include <qwidget.h>
#include <qstring.h>
#include <qpixmap.h>

#include "wholder.h"
#include "prfilter.h"

/*********************************************************************************
	A widget looking a little like a QPushButton:
*********************************************************************************/

class subButton : public widgetHolder
{
	Q_OBJECT

public:
	subButton( int, int, widgetHolder * );	

protected:
	virtual void newProperties( QString props[], QString vals[] );

private:
	void drawPix();

	QString myText;

	QPixmap pix;

};



/*********************************************************************************
	A widget looking like a QLabel:
*********************************************************************************/

class subLabel : public widgetHolder
{
	Q_OBJECT

public:
	subLabel( int, int, widgetHolder * );	

protected:
	virtual void newProperties( QString props[], QString vals[] );

private:
	void drawPix();

	int r, g, b;

	QString myText;

	QPixmap pix;

};



/*********************************************************************************
	A widget looking like a QLabel (but for pixmaps):
*********************************************************************************/

class subPixLabel : public widgetHolder
{
	Q_OBJECT

public:
	subPixLabel( int, int, widgetHolder * );	

protected:
	virtual void newProperties( QString props[], QString vals[] );

private:
	void drawPix();

	QString myPic;

	QPixmap pix;
	QPixmap pm;

};


/*********************************************************************************
	A widget looking like a QLineEdit:
*********************************************************************************/
class subEdit : public widgetHolder
{
	Q_OBJECT

public:
	subEdit( int, int, widgetHolder * );	

protected:
	virtual void newProperties( QString props[], QString vals[] );

private:
	void drawPix();

	QString myText;

	QPixmap pix;

};


/*********************************************************************************
	A widget looking like a QListBox:
*********************************************************************************/
class subList : public widgetHolder
{
	Q_OBJECT

public:
	subList( int, int, widgetHolder * );	

protected:
	virtual void newProperties( QString props[], QString vals[] );

private:
	void drawPix();

	QPixmap pix;

};


/*********************************************************************************
	A widget looking like a QCheckBox:
*********************************************************************************/
class subCheckBox : public widgetHolder
{
	Q_OBJECT

public:
	subCheckBox( int, int, widgetHolder * );	

protected:
	virtual void newProperties( QString props[], QString vals[] );

private:
	void drawPix();

	QString myText;
	bool isChecked;

	QPixmap pix;

};



/*********************************************************************************
	A widget looking like a QRadioButton:
*********************************************************************************/
class subOptionButton : public widgetHolder
{
	Q_OBJECT

public:
	subOptionButton( int, int, widgetHolder * );	

signals:
	void eCheck( QWidget *, QWidget * );

protected:
	virtual void newProperties( QString props[], QString vals[] );

private:
	void drawPix();

	QString myText;
	bool isChecked;

	QPixmap pix;

};



/*********************************************************************************
	A widget looking like a QSlieder:
*********************************************************************************/

class subSlider : public widgetHolder
{
	Q_OBJECT

public:
	subSlider( int, int, widgetHolder * );	

protected:
	virtual void newProperties( QString props[], QString vals[] );

private:
	void drawPix();

	QPixmap pix;
	int mySteps, myValue;

};


/*********************************************************************************
	A label that (regulary) shows the output of sub processes
*********************************************************************************/

class subProcCtrl : public widgetHolder
{
	Q_OBJECT

public:
	subProcCtrl( int, int, widgetHolder * );	

protected:
	virtual void newProperties( QString props[], QString vals[] );

private:
	void drawPix();

	int r, g, b;

	QString myText;

	QPixmap pix;

};


#endif
