/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#ifndef EWIDGETS_H
#define EWIDGETS_H

#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlabel.h>

/*****************************************************************************
* The following few classes are small extensions of Qt classes.
* They are used by other project classes.
******************************************************************************/

class eQLineEdit : public QLineEdit
{
	Q_OBJECT

public:
	eQLineEdit( QWidget *parent ) : QLineEdit(parent) {}

signals:
	void focusOut();

protected:
	virtual void focusOutEvent( QFocusEvent * ) { emit focusOut(); }

};


class eQPushButton : public QPushButton
{
	Q_OBJECT

public:
	eQPushButton( const char *txt, QWidget *parent );

signals:
	void focusOut();

protected:
	virtual void focusOutEvent( QFocusEvent * );

};


class eQLabel : public QLabel
{
	Q_OBJECT

public:
	eQLabel( const char *txt, QWidget *parent ) : QLabel(txt,parent) {}

signals:
	void clicked(); //Double click
	void sClick(); //Single click

protected:
	virtual void mouseDoubleClickEvent( QMouseEvent * ) { emit clicked(); }
	virtual void mousePressEvent( QMouseEvent * ) { emit sClick(); }

};


#endif
