/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "Dec.h"

char inCode[IN_LEN];
char className[VAR_LEN] = "";
char decl[LINE_LEN];
char outCode[MAX_LINES+1][LINE_LEN];
char vars[MAX_VARS][VAR_LEN];
int hVar[MAX_VARS] = {0};
char globals[MAX_VARS][VAR_LEN];
char glconst[MAX_VARS][2][VAR_LEN];
char userfs[MAX_FS][VAR_LEN];
int ufargs[MAX_FS] = {0};
int myIndex, lineIndex;
int finished;
int hasRet;
char parstring[32] = "\t";

int readFile( char *fileName )
{
FILE *fp;
int i = 0;

	fp = fopen( fileName, "r" );

	if ( fp == 0L )
	{
		printf ( "Can't open file: No such file or permission denied.\n" );
		return 0;
	}

	while ( inCode[i-1] != EOF )
	{

		inCode[i] = fgetc(fp);
		i++;

		if ( i == IN_LEN )
		{
			printf ( "Input file too long (> %d bytes).\n", IN_LEN );
			return 0;
		}
	}

	inCode[i-1] = 0L;

	fclose(fp);

	return 1;

} // ReadFile(...)


int readGlobals( char *fName )
{
FILE *fp;
int i, ii;
int part = 0;
char ch;

	fp = fopen( fName, "r" );

	if ( fp == 0L )
	{
		printf ( "Can't open file: No such file or permission denied.\n" );
		return 0;
	}

	// classname:
	i = 0;
	while ( (ch=fgetc(fp)) != '#' )
		if ( isalnum(ch) || ch == '_' )
		{
			if ( ch == EOF )
			{
				printf ( "Invalid declaration file.\n" );
				return 0;
			}

			className[i] = ch;
			i++;

			if ( i == VAR_LEN-1 )
			{
				printf ( "Class name from declaration file too long.\n" );
				return 0;
			}

		}

	className[i] = 0L;

	ch = fgetc(fp);

	// constants:
	i = 0; ii = 0;
	while ( (ch=fgetc(fp)) != '#' )
	{

		if ( ch == EOF )
		{
			printf ( "Invalid declaration file.\n" );
			return 0;
		}

		if ( ch == ' ' )
		{
			if ( part != 0 )
			{
				printf ( "Invalid const declaration.\n" );
				return 0;
			}

			glconst[i][0][ii] = 0L;
			ii = 0;
			part = 1;

			ch = fgetc(fp);
		}
		else if ( part == 0 )
		{
			glconst[i][0][ii] = ch;

			ii++;
		}

		if ( ch == 10 )
		{
			if ( part != 1 )
			{
				printf ( "Invalid const declaration.\n" );
				return 0;
			}

			glconst[i][1][ii] = 0L;
			ii = 0;
			i++;
			part = 0;

			if ( i == MAX_VARS-1 )
			{
				printf ( "Too many constants.\n" );
				return 0;
			}

		}
		else if ( part == 1 )
		{
			glconst[i][1][ii] = ch;
			ii++;
		}


		if ( ii == VAR_LEN )
		{
			printf ( "Global const or const value too long (> %d bytes).\n", VAR_LEN );
			return 0;
		}

	} // while


	ch = fgetc(fp);

	// variables:
	i = 0; ii = 0; part = 0;
	while ( (ch=fgetc(fp)) != '#' )
	{

		if ( ch == EOF )
		{
			printf ( "Invalid declaration file.\n" );
			return 0;
		}

		if ( ch == ' ' )
		{
			if ( part != 0 )
			{
				printf ( "Invalid variable declaration.\n" );
				return 0;
			}

			globals[i][ii] = 0L; /* Ignore value -> terminate */
			ii = 0;
			i++;
			part = 1;

			if ( i == MAX_VARS-1 )
			{
				printf ( "Too many global variables.\n" );
				return 0;
			}
		}

		if ( ch == 10 )
		{
			if ( part != 1 )
			{
				printf ( "Invalid variable declaration.\n" );
				return 0;
			}

			part = 0;

		}
		else if( part == 0 )
		{
			globals[i][ii] = ch;
			ii++;
		}


		if ( ii == VAR_LEN )
		{
			printf ( "Global const or const value too long (> %d bytes).\n", VAR_LEN );
			return 0;
		}

	} // while

	ch = fgetc(fp);


	// User functions:
	i = 0; ii = 0;

	while ( (ch=fgetc(fp)) != '#' )
	{

		if ( ch == EOF )
		{
			printf ( "Invalid declaration file.\n" );
			return 0;
		}

		if ( ch == ' ' )
		{

			userfs[i][ii] = 0L;
			ii = 0;

			if ( !isdigit(ch=fgetc(fp)) )
			{
				printf ( "Incorrect number of arguments for user defined function.\n" );
				return 0;
			}

			ufargs[i] = 10 * ((int)ch-48);

			if ( !isdigit(ch=fgetc(fp)) )
			{
				printf ( "Incorrect number of arguments for user defined function.\n" );
				return 0;
			}

			ufargs[i] = ufargs[i] + ((int)ch-48);

			i++;

			ch = fgetc(fp);

			if ( i == MAX_FS-1 )
			{
				printf ( "Too many user defined functions.\n" );
				return 0;
			}
		}
		else
		{
			userfs[i][ii] = ch;

			ii++;
		}


		if ( ii == VAR_LEN )
		{
			printf ( "Global const or const value too long (> %d bytes).\n", VAR_LEN );
			return 0;
		}

	} // while



	fclose(fp);

	return 1;

} // readGlobals(...)


void init( char **args )
{
int i, ii;

	for ( i = 0; i < IN_LEN; i++ )
		inCode[i] = 0;

	for ( i = 0; i < LINE_LEN; i++ )
		decl[i] = 0;

	for ( i = 0; i < MAX_LINES+1; i++ )
		for ( ii = 0; ii < LINE_LEN; ii++ )
			outCode[i][ii] = 0;

	for ( i = 0; i < MAX_VARS; i++ )
		for ( ii = 0; ii < VAR_LEN; ii++ )
			vars[i][ii] = 0;

	for ( i = 0; i < MAX_VARS; i++ )
		for ( ii = 0; ii < VAR_LEN; ii++ )
			globals[i][ii] = 0;

	for ( i = 0; i < MAX_VARS; i++ )
		for ( ii = 0; ii < VAR_LEN; ii++ )
		{
			glconst[i][0][ii] = 0;
			glconst[i][1][ii] = 0;
		}

	for ( i = 0; i < MAX_FS; i++ )
		for ( ii = 0; ii < VAR_LEN; ii++ )
			userfs[i][ii] = 0L;

	myIndex = 0; lineIndex = 0;
	finished = 0;

	i = 0;
	while (args[i] != 0L) i++;

	if ( i < 3 )
	{
		printf ( "Use: vkModuleTranslator infile.vkm outfile.cpp-code [globals.vkc]\n" );
		exit(1);
	}

	if ( i > 3 )
		if ( !readGlobals( args[3] ) )
		{
			printf ( "Can't read file within (global) user declarations.\n" );
			abort();
		}

	if ( !readFile( args[1] ) )
	{
		printf( "Input file not opened.\n" );
		abort();
	}

} // init(...)



int registerVar( char *newVar, int toWrite )
{
int i;

/*
	Is the variable (newVar) allready registered, either as global
	variable or const or in the local variable stack (vars[]).
	Local vars will be declared, so they must be saved.
*/

	for ( i = 0; i < MAX_VARS; i++ )
	{
		if ( strcmp( newVar, glconst[i][0] ) == 0 )
			if ( toWrite )
			{
				printf ( "You tried to change a constants value.\n" );
				abort();
			}
			else return -1;

		if ( strcmp( newVar, globals[i] ) == 0 )
			return -1;
	}


	for ( i = 0; i < MAX_VARS; i++ )
	{
		if ( strcmp( newVar, vars[i] ) == 0 ) return -1;

		if( vars[i][0] == 0L )
		{
			if( strlen(newVar) >= VAR_LEN )
			{
				printf ( "Varible name too long.\n" );
				abort();
			}

			strcat( vars[i], newVar );
			return i;
		}
	}

	printf ( "Error: Too much (local) variables.\n" );
	abort();

	return -1;

}


void regHVar( char *rhv )
{
int i;

	i = registerVar( rhv, 0 );

	if ( i != -1 )
		hVar[i] = 1;
	else
	{
		printf( "Event/function argument variable allready declared for other use.\n" );
		abort();
	}
}


int translateDec()
{
int i, ii = 0;
int isInName = 0;
char headVar[LINE_LEN] = "";

	if ( (strncmp( inCode, "event ", 6 ) != 0)
		&& (strncmp( inCode, "function ", 9 ) != 0) )
			return 0;


	if(strncmp( inCode, "function ", 9 ) == 0)
		hasRet = 1;

	// Event/Function:
	while( inCode[myIndex] != ' ' )
		myIndex++;


	// Function name:
	i = 2;

	if ( strncmp( inCode, "event ", 6 ) == 0 )
		strcpy( decl, "void " );
	else //Function
		strcpy( decl, "v " );

	myIndex++;

	if ( className[0] != 0L )
	{
		if( strlen(className)+5 > LINE_LEN )
		{
			printf ( "Class name too long.\n" );
			return 0;
		}

		strcat( decl, className );
		strcat( decl, "::" );

		i = strlen(decl);

	}

	while ( inCode[myIndex] != '(' )
	{

		decl[i] = inCode[myIndex];

		i++; myIndex++;

		if ( (i+3) >= LINE_LEN )
			return 0;

		if ( inCode[myIndex] == 0L || inCode[myIndex+3] == 0L )
			return 0;
	}

	decl[i] = '(';

	myIndex++;

	// Arguments:
	if ( inCode[myIndex] == ')' )
	{
		i++; decl[i] = ')';
		i++; decl[i] = 0L;
	}
	else
	{
		while( inCode[myIndex] != ')' )
		{

			if ( i + 3 == LINE_LEN )
				return 0;

			i++;

			if (!isInName)
			{
				isInName = 1;
				decl[i] = 'v';
				i++;
				decl[i] = ' ';
				i++;
				headVar[ii] = 0L;

				if( ii != 0 )
					regHVar(headVar);

				ii = 0;
			}

			decl[i] = inCode[myIndex];

			if ( inCode[myIndex] == ',' )
				isInName = 0;
			else
				headVar[ii] = inCode[myIndex];

			myIndex++;
			ii++;

			if ( inCode[myIndex] == 0L ) return 0;

		} // while

		if( ii != 0 )
			regHVar( headVar );


		decl[i+1] = ')'; decl[i+2] = 0L;

	} // else of: if ( inCode[myIndex] == ')' )

	myIndex += 2;
	if ( inCode[myIndex-1] != 10 || inCode[myIndex] != '{' )
		return 0;

	myIndex += 2;

	return 1;
}


int isForVar( char *testStr )
{
int i;
int parMode = 0, strMode = 0;

/*
	Does the function or expression return to a variable ?
	x = [expression];
*/

	for ( i = 0; testStr[i] != 0L; i++ )
	{
		if ( testStr[i] == '(' ) parMode++;
		if ( testStr[i] == ')' ) parMode--;
		if ( testStr[i] == '"' ) strMode = !strMode;

		if ( !strMode && testStr[i] == ' ' ) return 0;

		if ( !strMode && parMode == 0 && testStr[i] == '=' )
			return 1;

	}

	return 0;

} // isForVar()



void getPrObject( char *in, char *ret )
{
//get the object name from a property or method string
int i;

	for( i = 0; in[i] != ':'; i++ )
	{
		if( in[i] == 0L )
		{
			printf( "Internal error (This is no property/method).\n" );
			exit(1);
		}

		ret[i] = in[i];

	}

	ret[i] = 0L;

}


void getPrProp( char *in, char *ret )
{
//get the property/method name from a property or method string
int i;
int ii = 0;

	for( i = 0; in[i] != ':'; i++ )
		if( in[i] == 0L )
		{
			printf( "Internal error (This is no property/method).\n" );
			exit(1);
		}

	i++;

	while( isalnum( in[i] ) )
	{
		ret[ii] = in[i];
		i++; ii++;
	}

	ret[ii] = 0L;


}



int isProperty( char *testStr )
{
int strMode = 0, i;

	for( i = 0; testStr[i] != 0L; i++ )
	{
		if ( testStr[i] == '"' )
			strMode = !strMode;

		if( !strMode && testStr[i] == ':' )
			return 1;
	}

	return 0;
}


int isPure( char *testStr )
{
int i = 0, strMode = 0;
int canbe, p = 0;


	/*is this a variable or constant ?
	  (otherwise it's a function/method, property or operation)*/

	while ( testStr[i] != 0L )
	{
		if ( testStr[i] == '"' ) strMode = !strMode;

		if ( !strMode && i != 0 &&
			(  testStr[i] == '+' || testStr[i] == '-'
			|| testStr[i] == '*' || testStr[i] == '/'
			|| testStr[i] == '%' || testStr[i] == '^'
			|| testStr[i] == '&' || testStr[i] == ':'
			|| testStr[i] == '(' || testStr[i] == '<'
			|| testStr[i] == '>' || testStr[i] == '=' )
			)
			return 0;
		i++;
	}


	canbe = 1;
	for ( i = 0; testStr[i] !=  0L; i++ ) // Integer-const ?
		if ( !isdigit(testStr[i])
			&& !(i==0 && (testStr[i]=='-' || testStr[i]=='+')) )
			canbe = 0;

	if (canbe)
		return 1; // Integer-const

	canbe = 1;
	for ( i = 0; testStr[i] != 0L; i++ )
	{
		if ( !isdigit(testStr[i]) && ( testStr[i] != '.' || p )
			&& !(i==0 && (testStr[i]=='-' || testStr[i]=='+')) )
			canbe = 0;

		if ( testStr[i] == '.' ) p = 1;
	}

	if (canbe)
		return 1; // float-const


	canbe = 1;
	if ( testStr[0] == '"' && testStr[strlen(testStr)-1] == '"' )
	{
		for ( i = 1; i < strlen(testStr)-1; i++ )
		{
			if ( testStr[i] == '"' )
				canbe = 0;
		}
	}
	else canbe = 0;

	if (canbe)
		return 1; // String-const


	// OK, must be a variable (or err)
	if ( !islower(testStr[0]) && testStr[0] != '_' )
	{
		printf ( "Illegal argument %s.\n", testStr );
		abort();
	}

	for ( i = 0; testStr[i] != 0L; i++ )
		if ( !( islower(testStr[i]) || isdigit(testStr[i])
			|| testStr[i] == '_') )
		{
			printf ( "Illegal argument %s.\n", testStr );
			abort();
		}

	registerVar(testStr,0);

	return 1;

} // isPure(...)


int checkContext( char *check, int id )
{
int i;
int p = 0;

	/*Variable, string, int, long, float, double, bool
	    1          2     3     4     5        6    7   */

	/* Return values: Variable: Allways 1
	   context = id: 0
	   context != id: -1 */

	if ( check[0] != '"' && check[0] != '.'
		&& !isdigit(check[0]) && check[0] != '-' )
	{
		for ( i = 0; glconst[i][0][0] != 0L; i++ )
			if( strcmp (check, glconst[i][0]) == 0 )
				if ( checkContext(glconst[i][1], id) != 0 )
				{ // Exactly ONE level deep recursion

					/* The variable is registered as
					   constant and the const value
					   is not of id-type */

					printf ( "You tried to use a constant as wrong type.\n" );
					return -1;
				}

		return 1; // OK, it's a variable or correct constant
	}

	// Well, 'check' must be a string or digit const ...

	switch(id)
	{
		case 1: //Only variables wanted
			return -1;

		case 2: // String
			if ( check[0] != '"' || check[strlen(check)-1] != '"' )
				return -1;

			for ( i = 1; i < strlen(check)-1; i++ )
				if ( check[i] == '"' )
					return -1;

			break;

		case 3: // Integer
			for ( i = 0; check[i] !=  0L; i++ )
				if ( !isdigit(check[i])
					&& !(i==0 && (check[i]=='-' || check[i]=='+')) )
					return -1;

			//Check for correct size: (...)

			break;

		case 4: // Long integer
			for ( i = 0; check[i] !=  0L; i++ )
				if ( !isdigit(check[i])
					&& !(i==0 && (check[i]=='-' || check[i]=='+')) )
					return -1;

			//Check for correct size (should be no problem): (...)

			break;

		case 5: // Float
			for ( i = 0; check[i] != 0L; i++ )
			{
				if ( !isdigit(check[i]) && ( check[i] != '.' || p )
					&& !(i==0 && (check[i]=='-' || check[i]=='+')) )
					return -1;

				if ( check[i] == '.' ) p = 1;
			}

			//Check for correct size: (...)

			break;

		case 6: // Double
			for ( i = 0; check[i] != 0L; i++ )
			{
				if ( !isdigit(check[i]) && ( check[i] != '.' || p )
					&& !(i==0 && (check[i]=='-' || check[i]=='+')) )
					return -1;

				if ( check[i] == '.' ) p = 1;
			}

			//Check for correct size (should be no problem): (...)

			break;

		case 7: // Bool
			if ( strcmp( check, "0" ) != 0 && strcmp( check, "1" ) != 0 )
				return -1;
				
			break;

		default:
			printf ( "Internal error: No such variable context.\n" );
			abort();
			break;

	} // switch

	return 0;

} // checkContext(...)


void trMsgbox( char args[32][CONST_LEN], char *ret ) // ret: outCode[lineIndex]
{
int i, ii;

	i = 0;
	while( args[i][0] != 0L )
		i++;

	if ( i == 0 )
	{
		printf (  "'MsgBox' used without arguments.\n" );
		abort();
	}

	if ( i > 3 )
	{
		printf (  "Too many arguments on 'MsgBox'.\n" );
		abort();
	}

	strcpy( ret, parstring );
	strcat( ret, "msg = new vkBox(" );

	if ( strlen(args[0])+strlen(ret)+8 >= LINE_LEN )
	{
		printf ( "Sum of argument lengths on 'MsgBox' too long.\n" );
		abort();
	}

	strcat( ret, args[0] );

	if ( checkContext( args[0], 2 ) == 1 )
		strcat( ret, ".str()" );
	else if( checkContext( args[0], 2 ) != 0 )
	{
		printf ( "Wrong constant type as argument one of 'MsgBox'.\n" );
		abort();
	}
	

	if ( i > 1 )
	{
		strcat( ret, ", " );

		if ( strlen(args[1])+strlen(ret)+6 >= LINE_LEN )
		{
			printf ( "Sum of argument lengths on 'MsgBox' too long.\n" );
			abort();
		}

		strcat( ret, args[1] );

		if ( checkContext( args[1], 3 ) == 1 )
			strcat( ret, ".i()" );
		else if( checkContext( args[1], 3 ) != 0 )
		{
			printf ( "Wrong constant type as argument one of 'MsgBox'.\n" );
			abort();
		}
	}

	if ( i > 2 )
	{
		strcat( ret, ", " );

		if ( strlen(args[2])+strlen(ret)+7 >= LINE_LEN )
		{
			printf ( "Sum of argument lengths on 'MsgBox' too long.\n" );
			abort();
		}

		strcat( ret, args[2] );

		if ( checkContext( args[2], 2 ) == 1 )
			strcat( ret, ".str()" );
		else if( checkContext( args[2], 2 ) != 0 )
		{
			printf ( "Wrong constant type as argument one of 'MsgBox'.\n" );
			abort();
		}
	}

	if ( strlen(ret) + 34 >= LINE_LEN )
	{

		printf ( "Sum of argument lengths on 'MsgBox' too long.\n" );
		abort();

	}

	strcat( ret, ");\n" );

	strcat( ret, parstring );
	strcat( ret, "_h.s(msg->answer());\n" );

	strcat( ret, parstring );
	strcat( ret, "delete msg;\n" );


} // trMsgbox(...)


void trOpenFn( char args[32][CONST_LEN], char *ret )
{
int i, ii;

	i = 0;
	while( args[i][0] != 0L )
		i++;

	if ( i != 0 )
	{
		printf (  "'GetOpenFilename' used with too many arguments.\n" );
		abort();
	}

	strcpy( ret, parstring );
	strcat( ret, "_h.s( KFileDialog::getOpenFileName() );\n" );
	strcat( ret, parstring );
	strcat( ret, "_h.setFile(true);\n" );

} // trOpenFn(...)


void trSaveFn( char args[32][CONST_LEN], char *ret )
{
int i, ii;

	i = 0;
	while( args[i][0] != 0L )
		i++;

	if ( i != 0 )
	{
		printf (  "'GetSaveFilename' used with too many arguments.\n" );
		abort();
	}

	strcpy( ret, parstring );
	strcat( ret, "_h.s( KFileDialog::getSaveFileName() );\n" );
	strcat( ret, parstring );
	strcat( ret, "_h.setFile(true);\n" );

} // trSaveFn(...)


void trReadFile( char args[32][CONST_LEN], char *ret )
{
int i, ii;

	i = 0;
	while( args[i][0] != 0L )
		i++;

	if ( i == 0 )
	{
		printf (  "'ReadFile' used without arguments.\n" );
		abort();
	}

	if ( i > 1 )
	{
		printf (  "'ReadFile' used with too many arguments.\n" );
		abort();
	}

	strcpy( ret, parstring );
	strcat( ret, "if( ! " );
	strcat( ret, args[0] );

	if ( checkContext( args[0], 2 ) != 1 )
	{
		printf ( "Constant used as argument one of 'ReadFile'.\n" );
		abort();
	}

	strcat( ret, ".isFile() )\n" );
	strcat( ret, parstring );
	strcat( ret, "\temit ( parentCall( -1, \"\", \"Error\", 1,\n" );
	strcat( ret, parstring );
	strcat( ret, "\t\tQString (\"Can't read file: argument is\\n\")\n" );
	strcat( ret, parstring );
	strcat( ret, "\t\t+(\"not a correct VK file variable.\" ) )\n" );
	strcat( ret, parstring );
	strcat( ret, "\t);\n" );

	strcat( ret, parstring );
	strcat( ret, "_h.s( vkFunctions::readFile( " );

	strcat( ret, args[0] );
	strcat( ret, ".str()" );

	strcat( ret, " ) );\n" );


} // trReadFile(...)


void trWriteFile( char args[32][CONST_LEN], char *ret )
{
int i, ii;

	i = 0;
	while( args[i][0] != 0L )
		i++;

	if ( i == 0 )
	{
		printf (  "'WriteFile' used without arguments.\n" );
		abort();
	}

	if ( i == 1 )
	{
		printf (  "'WriteFile' used with too few arguments.\n" );
		abort();
	}

	if ( i > 2 )
	{
		printf (  "'WriteFile' used with too many arguments.\n" );
		abort();
	}

	strcpy( ret, parstring );
	strcat( ret, "if( ! " );
	strcat( ret, args[1] );

	if ( checkContext( args[1], 2 ) != 1 )
	{
		printf ( "Constant used as argument two of 'WriteFile'.\n" );
		abort();
	}

	strcat( ret, ".isFile() )\n" );
	strcat( ret, parstring );
	strcat( ret, "\temit ( parentCall( -1, \"\", \"Error\", 1,\n" );
	strcat( ret, parstring );
	strcat( ret, "\t\tQString (\"Can't write file: argument is\\n\")\n" );
	strcat( ret, parstring );
	strcat( ret, "\t\t+(\"not a correct VK file variable.\" ) )\n" );
	strcat( ret, parstring );
	strcat( ret, "\t);\n" );

	strcat( ret, parstring );
	strcat( ret, "_h.s( vkFunctions::writeFile( " );

	strcat( ret, args[0] );

	if ( checkContext( args[0], 2 ) == 1 )
		strcat( ret, ".str()" );
	else if( checkContext( args[0], 2 ) != 0 )
	{
		printf ( "Wrong constant type as argument one of 'WriteFile'.\n" );
		abort();
	}

	strcat( ret, ", " );
	strcat( ret, args[1] );
	strcat( ret, ".str()" );

	strcat( ret, " ) );\n" );


} // trWriteFile(...)


void trLen( char args[32][CONST_LEN], char *ret )
{
	if ( args[0][0] == 0L )
	{
		printf (  "'Len' used without arguments.\n" );
		abort();
	}

	if ( args[1][0] != 0 )
	{
		printf (  "Too many arguments on 'Len'.\n" );
		abort();
	}

	strcpy( outCode[lineIndex], parstring );
	strcat( ret, "_h.s( QString(" );

	if ( strlen(args[0])+strlen(ret)+22 >= LINE_LEN )
	{
		printf ( "Argument on 'Len' too long.\n" );
		abort();
	}

	strcat( ret, args[0] );

	if ( checkContext(args[0],2) == 1 )
		strcat( ret, ".str()" );
	else if ( checkContext(args[0],2) != 0 )
	{
		printf ( "Wrong constant type as argument one of 'Len'.\n" );
		abort();
	}

	strcat( ret, ").length() );\n" );

} // trLen(...)


void trReturn( char args[32][CONST_LEN], char *ret )
{
	printf( "WARNING: Return is not fully supportet; will return void.\n" );
	strcpy( outCode[lineIndex], parstring );
	strcat( ret, "return;\n" );

} // trReturn(...)

void trExit( char args[32][CONST_LEN], char *ret )
{
	if ( args[0][0] != 0L )
	{
		printf (  "Too many arguments on 'Exit'.\n" );
		abort();
	}

	strcpy( outCode[lineIndex], parstring );
	strcat( ret, "KApplication::getKApplication()->quit();\n" );

} // trExit(...)

void trElse( char args[32][CONST_LEN], char *ret )
// We use "else" like a function to ease things
{
	if ( args[0][0] != 0L )
	{
		printf (  "*.vkm file error:\n" );
		printf (  "Else is not a true function, it can't take arguments.\n" );
		abort();
	}

	strcpy( outCode[lineIndex], parstring );
	strcat( ret, "else" );

} // trExit(...)


int trUserfs( char *fname, char args[32][CONST_LEN], char *ret )
{
int i, success = 0;

	for( i = 0; i < MAX_FS; i++ )
		if( strcmp( userfs[i], fname ) == 0 )
		{
			success = 1;
			break;
		}

	if(success)
	{
		strcpy( ret, parstring );

		strcat( ret, fname );
		strcat( ret, "( " );

		for( i = 0; args[i][0] != 0L; i++ )
		{
			strcat( ret, args[i] );

			if(args[i+1][0] != 0L)
				strcat( ret, ", " );
		}

		strcat( ret, "); //User defined function\n" );

	}

	return success;
}

void trFunction( char *trString )
{
int i, ii;
char fName[128] = "";
char args[32][CONST_LEN] = {""};
int strM = 0;
int argi = 0;

	// 1) Read function name:

	for ( i = 0; trString[i] != '('; i++ )
	{
		if ( trString[i] == 0L || i == 127 )
		{
			printf ( "Invalid function call.\n" );
			abort();
		}

		fName[i] = trString[i];
	}

	fName[i] = 0L;

	i++; ii = 0;


	// 2) Read arguments:
	while( trString[i] != ')' || strM )
	{

		if ( trString[i]  == 0L )
		{
			printf ( "Invalid function call.\n" );
			abort();
		}


		if ( trString[i] == '"' )
			strM = !strM;

		if ( trString[i] == ',' && !strM )
		{

			args[argi][ii] = 0L;

			argi++; ii = -1;

			if ( argi == 31 )
			{
				printf ( "Too many function arguments.\n" );
				abort();
			}
		}
		else
			args[argi][ii] = trString[i];


		i++; ii++;

		if ( ii == CONST_LEN )
		{
			printf ( "Function argument too long.\n" );
			abort();
		}

	} // while

	args[argi][ii] = 0L;

	for ( i = 0; args[i][0] != 0L; i++ )
		if ( !isPure( args[i] ) )
		{
			printf ( "Invalid function argument.\n" );
			abort();
		}

	// 3) Translate function:

	if ( strcmp( fName, "msgbox" ) == 0 )
		trMsgbox( args, outCode[lineIndex] );
	else if ( strcmp( fName, "getopenfilename" ) == 0 )
		trOpenFn( args, outCode[lineIndex] );
	else if ( strcmp( fName, "getsavefilename" ) == 0 )
		trSaveFn( args, outCode[lineIndex] );
	else if ( strcmp( fName, "readfile" ) == 0 )
		trReadFile( args, outCode[lineIndex] );
	else if ( strcmp( fName, "writefile" ) == 0 )
		trWriteFile( args, outCode[lineIndex] );
	else if ( strcmp( fName, "len" ) == 0 )
		trLen( args, outCode[lineIndex] );
	else if ( strcmp( fName, "return" ) == 0 )
		trReturn( args, outCode[lineIndex] );
	else if ( strcmp( fName, "exit" ) == 0 )
		trExit( args, outCode[lineIndex] );
	else if ( strcmp( fName, "else" ) == 0 ) // else is "simulated" as a function
		trElse( args, outCode[lineIndex] );
	else if ( !trUserfs( fName, args, outCode[lineIndex] ) )
	{
		//No pre-defined function nor a user-defined one):

		printf ( "No such function: %s.\n", fName );
		abort();
	}

	// 4) Check for errors:

	lineIndex++;

	if ( lineIndex == MAX_LINES )
	{
		printf ( "Input file was too large: " );
		printf ( "I mustn't add important %d. line.\n", MAX_LINES );
		abort();
	}

} // trFunction(...)


void trOperation( char *trString )
{
char op1[CONST_LEN], op2[CONST_LEN];
char ot[3];
int i, ii;

	strcpy( outCode[lineIndex], parstring );
	strcat( outCode[lineIndex], "_h.s(" );

	if( trString[0] == '"' )
	{
		op1[0] = '"';

		for ( i = 1; trString[i] != '"'; i++ )
		{
			if ( i == CONST_LEN-1 )
			{
				printf ( "Operand too long.\n" );
				abort();
			}

			op1[i] = trString[i];
		}

		op1[i] = '"';

		i++;
	}
	else
		for ( i = 0; islower(trString[i]) || isdigit(trString[i])
			|| trString[i] == '_' || trString[i] == '.'; i++ )
		{
			if ( i == CONST_LEN-1 )
			{
				printf ( "Operand too long.\n" );
				abort();
			}

			op1[i] = trString[i];
		}

	op1[i] = 0L;

	
	ot[0] = trString[i];

	if ( !( islower(trString[i+1]) || isdigit(trString[i+1])
		|| trString[i+1] == '_' || trString[i+1] == '.' || trString[i+1] == '"' ) )
	{
		i++;
		ot[1] = trString[i];
		ot[2] = 0L;
	}
	else ot[1] = 0L;

	i++;
	ii = 0;

	if( trString[i] == '"' )
	{
		op2[0] = '"';

		while( trString[i] != 0L )
		{
			op2[ii] = trString[i];
			i++; ii++;

			if ( i == CONST_LEN-1 )
			{
				printf ( "Operand too long.\n" );
				abort();
			}

		}
	}
	else
	        while( trString[i] != 0L )
		{
			op2[ii] = trString[i];
			i++; ii++;

			if ( ii == CONST_LEN-1 )
			{
				printf ( "Operand too long.\n" );
				abort();
			}
		}

	op2[ii] = 0L;

	if( checkContext( op1, 1 ) == 1 )
		registerVar( op1, 0 );

	if( checkContext( op2, 1 ) == 1 )
		registerVar( op2, 0 );

	if ( strcmp( ot, "+" ) == 0 )
	{
		strcat( outCode[lineIndex], op1 );

		if ( checkContext( op1, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op1, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], "+" );

		strcat( outCode[lineIndex], op2 );

		if ( checkContext( op2, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op2, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], ");" );
	}
	else if ( strcmp( ot, "-" ) == 0 )
	{

		strcat( outCode[lineIndex], op1 );

		if ( checkContext( op1, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op1, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], "-" );

		strcat( outCode[lineIndex], op2 );

		if ( checkContext( op2, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op2, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], ");" );

	}
	else if ( strcmp( ot, "*" ) == 0 )
	{

		strcat( outCode[lineIndex], op1 );

		if ( checkContext( op1, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op1, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], "*" );

		strcat( outCode[lineIndex], op2 );

		if ( checkContext( op2, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op2, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], ");" );

	}
	else if ( strcmp( ot, "/" ) == 0 )
	{
		strcat( outCode[lineIndex], op1 );

		if ( checkContext( op1, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op1, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], "/" );

		strcat( outCode[lineIndex], op2 );

		if ( checkContext( op2, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op2, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], ");" );

	}
	else if ( strcmp( ot, "%" ) == 0 )
	{
		strcat( outCode[lineIndex], op1 );

		if ( checkContext( op1, 4 ) == 1 )
			strcat( outCode[lineIndex], ".l()" );
		else if ( checkContext( op1, 4 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], "%" );

		strcat( outCode[lineIndex], op2 );

		if ( checkContext( op2, 4 ) == 1 )
			strcat( outCode[lineIndex], ".l()" );
		else if ( checkContext( op2, 4 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], ");" );

	}
	else if ( strcmp( ot, "^" ) == 0 )
	{
		strcat( outCode[lineIndex], "pow( ");

		strcat( outCode[lineIndex], op1 );

		if ( checkContext( op1, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op1, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], ", " );

		strcat( outCode[lineIndex], op2 );

		if ( checkContext( op2, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op2, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], " ));" );

	}
	else if ( strcmp( ot, "&" ) == 0 )
	{
		strcat( outCode[lineIndex], "QString (");
		strcat( outCode[lineIndex], op1 );

		if ( checkContext( op1, 2 ) == 1 )
			strcat( outCode[lineIndex], ".str()" );
		else if ( checkContext( op1, 2 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], ") ");

		strcat( outCode[lineIndex], "+(" );

		strcat( outCode[lineIndex], op2 );

		if ( checkContext( op2, 2 ) == 1 )
			strcat( outCode[lineIndex], ".str()" );
		else if ( checkContext( op2, 2 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], ") );" );


	}
	else if ( strcmp( ot, "==" ) == 0 )
	{
		strcat( outCode[lineIndex], "QString(" );

		if ( checkContext( op1, 2 ) != 1 )
			strcat( outCode[lineIndex], "v(" );

		strcat( outCode[lineIndex], op1 );

		if ( checkContext( op1, 2 ) != 1 )
			strcat( outCode[lineIndex], ")" );

		strcat( outCode[lineIndex], ".str())" );

		strcat( outCode[lineIndex], " == " );

		strcat( outCode[lineIndex], "QString(" );

		if ( checkContext( op2, 2 ) != 1 )
			strcat( outCode[lineIndex], "v(" );

		strcat( outCode[lineIndex], op2 );

		if ( checkContext( op2, 2 ) != 1 )
			strcat( outCode[lineIndex], ")" );

		strcat( outCode[lineIndex], ".str()));" );

	}
	else if ( strcmp( ot, "!=" ) == 0 )
	{
		strcat( outCode[lineIndex], "QString(" );

		if ( checkContext( op1, 2 ) != 1 )
			strcat( outCode[lineIndex], "v(" );

		strcat( outCode[lineIndex], op1 );

		if ( checkContext( op1, 2 ) != 1 )
			strcat( outCode[lineIndex], ")" );

		strcat( outCode[lineIndex], ".str())" );

		strcat( outCode[lineIndex], " != " );

		strcat( outCode[lineIndex], "QString(" );

		if ( checkContext( op2, 2 ) != 1 )
			strcat( outCode[lineIndex], "v(" );

		strcat( outCode[lineIndex], op2 );

		if ( checkContext( op2, 2 ) != 1 )
			strcat( outCode[lineIndex], ")" );

		strcat( outCode[lineIndex], ".str()));" );
	}
	else if ( strcmp( ot, "<" ) == 0 )
	{
		strcat( outCode[lineIndex], op1 );

		if ( checkContext( op1, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op1, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], " < " );

		strcat( outCode[lineIndex], op2 );

		if ( checkContext( op2, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op2, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], ");" );

	}
	else if ( strcmp( ot, "<=" ) == 0 )
	{
		strcat( outCode[lineIndex], op1 );

		if ( checkContext( op1, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op1, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], " <= " );

		strcat( outCode[lineIndex], op2 );

		if ( checkContext( op2, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op2, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], ");" );

	}
	else if ( strcmp( ot, ">" ) == 0 )
	{
		strcat( outCode[lineIndex], op1 );

		if ( checkContext( op1, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op1, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], ">" );

		strcat( outCode[lineIndex], op2 );

		if ( checkContext( op2, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op2, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], ");" );

	}
	else if ( strcmp( ot, ">=" ) == 0 )
	{
		strcat( outCode[lineIndex], op1 );

		if ( checkContext( op1, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op1, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], " >= " );

		strcat( outCode[lineIndex], op2 );

		if ( checkContext( op2, 6 ) == 1 )
			strcat( outCode[lineIndex], ".d()" );
		else if ( checkContext( op2, 6 ) != 0 )
		{
			printf ( "Wrong constant type in operation.\n" );
		}

		strcat( outCode[lineIndex], ");" );

	}
	else
	{
		printf ( "Wrong operation (%s).\n", ot );
		abort();
	}
	

	lineIndex++;

	if ( lineIndex == MAX_LINES )
	{
		printf ( "Input file was too large: " );
		printf ( "I mustn't add important %d. line.\n", MAX_LINES );
		abort();
	}
}


void trFor( char *str )
{
int i, ii;
char forVar[128] = "";
char hStr[32] = "";

	strcpy( outCode[lineIndex], parstring );
	strcat( outCode[lineIndex], "for(" );

	// 1) Get for-variable
	for ( i = 4; str[i] != '='; i++ )
	{
		if ( str[i] == 0L || i == 127 )
		{
			printf ( "First 'For'-argument is not a correct variable.\n" );
			abort();
		}

		forVar[i-4] = str[i];
	}

	i++;

	forVar[i-4] = 0L;

	registerVar( forVar, 1 );

	strcat( outCode[lineIndex], forVar );
	strcat( outCode[lineIndex], ".s(" );

	// 2) Get init value
	ii = 0;
	while( str[i] != ' ' )
	{
		if ( str[i] == 0L )
		{
			printf ( "'for' syntax error (incomplete instruction after '=').\n" );
			abort();
		}

		if ( ii == 31 )
		{
			printf ( "For %s = x: Argument x is too long.\n", forVar );
			abort();
		}

		hStr[ii] = str[i];
		i++; ii++;
	}

	hStr[ii] = 0L;

	strcat( outCode[lineIndex], hStr );

	if ( checkContext( hStr, 3 ) == 0 ) // OK
		strcat( outCode[lineIndex], ");" );
	else if ( checkContext( hStr, 3 ) == 1 ) // Variable
		strcat( outCode[lineIndex], ".i());" );
	else
	{
		printf ( "Wrong constant type in 'for'.\n" );
		abort();
	}

	i+=3;

	if ( str[i-2] != 't' || str[i-1] != 'o' || str[i] != ' ' )
	{
		printf ( "'for' syntax error ('to' expected).\n" );
		abort();
	}

	i++;

	// 3) Get to-Value:
	ii = 0;
	while( str[i] != ' ' )
	{
		if ( str[i] == 0L )
		{
			printf ( "'for' syntax error (incomplete instruction after 'to').\n" );
			abort();
		}

		if ( ii == 31 )
		{
			printf ( "For ... To x: Argument x is too long.\n" );
			abort();
		}

		hStr[ii] = str[i];
		i++; ii++;
	}

	hStr[ii] = 0L;

	strcat( outCode[lineIndex], forVar );
	strcat( outCode[lineIndex], ".i() <= " );
	strcat( outCode[lineIndex], hStr );

	if ( checkContext( hStr, 3 ) == 0 ) // OK
		strcat( outCode[lineIndex], ";" );
	else if ( checkContext( hStr, 3 ) == 1 ) // Variable
	{
		strcat( outCode[lineIndex], ".i();" );
		registerVar( hStr, 0 );
	}
	else
	{
		printf ( "Wrong constant type in 'for'.\n" );
		abort();
	}

	i++;
	if ( str[i] != 'd' || str[i+1] != 'o' )
	{
		printf ( "'for' syntax error ('do' expected ).\n" );
		abort();
	}

	// 4) Third for-part:
	strcat( outCode[lineIndex], forVar );
	strcat( outCode[lineIndex], ".s(" );
	strcat( outCode[lineIndex], forVar );
	strcat( outCode[lineIndex], ".i()+1))" );

	// 5) Check for errors:

	lineIndex++;

	if ( lineIndex == MAX_LINES )
	{
		printf ( "Input file was too large: " );
		printf ( "I mustn't add important %d. line.\n", MAX_LINES );
		abort();
	}

}

void trWhile( char *str )
{
int i, ii;
char expr[128] = "", expr2[128] = "", expr3[128] = "_whv";

	strcpy( outCode[lineIndex], parstring );
	strcat( outCode[lineIndex], "while(1) //Sorry, baaaaad style :-(\n" );

	i = 6;
	while( str[i] != ' ' )
	{
		expr[i-6] = str[i];
		i++;
	}

	expr[i-6] = 0L;

	if ( checkContext( expr, 7 ) == 0 ) //Bool const
	{
		strcat( outCode[lineIndex], parstring );
		strcat ( outCode[lineIndex], "if( !(" );
		strcat ( outCode[lineIndex], expr );
		strcat ( outCode[lineIndex], ") ) break;\n" );
		strcat( outCode[lineIndex], parstring );
		strcat( outCode[lineIndex], "else if( " );
	}
	else if ( checkContext( expr, 7 ) == 1 ) //Variable
	{
		strcat( outCode[lineIndex], parstring );
		strcat ( outCode[lineIndex], "if( !(" );
		strcat ( outCode[lineIndex], expr );
		strcat ( outCode[lineIndex], ".b()) ) break;\n" );
		strcat( outCode[lineIndex], parstring );
		strcat( outCode[lineIndex], "else if( " );

		registerVar(expr,0);
	}
	else
	{
		printf ( "Wrong constant type in 'while'.\n" );
		abort();
	}

	i++;

	for( ii = 0; str[i] != 0L; i++ )
	{
		expr2[ii] = str[i];

		ii++;
	}

	expr2[ii-1] = 0L;

	strcat( expr3, expr2 );
	registerVar(expr3,1);

	strcat( outCode[lineIndex], expr3 );
	strcat( outCode[lineIndex], ".str() == \"SCAN\" ) { " );
	strcat( outCode[lineIndex], expr3 );
	strcat( outCode[lineIndex], ".s(\"\"); goto " );
	strcat( outCode[lineIndex], expr2 );
	strcat( outCode[lineIndex], "; }\n" );
	strcat( outCode[lineIndex], parstring );
	strcat( outCode[lineIndex], "else for( ; " );
	strcat( outCode[lineIndex], expr3 );
	strcat( outCode[lineIndex], ".str() != \"SCAN\"; " );
	strcat( outCode[lineIndex], expr3 );
	strcat( outCode[lineIndex], ".s(\"SCAN\") ) //Still ugly, but I don't know how to implement \"while\" otherwise." );

	lineIndex++;

	if ( lineIndex == MAX_LINES )
	{
		printf ( "Input file was too large: " );
		printf ( "I mustn't add important %d. line.\n", MAX_LINES );
		abort();
	}


}

void trIf( char *str )
{
int i;
char expr[128] = "";

	strcpy( outCode[lineIndex], parstring );
	strcat( outCode[lineIndex], "if( " );

	i = 3;
	while( str[i] != 0L )
	{
		expr[i-3] = str[i];
		i++;
	}

	expr[i-4] = 0L; // -4, since the last byte is ')'

	if ( checkContext( expr, 7 ) == 0 ) //Bool const
	{
		strcat ( outCode[lineIndex], expr );
		strcat ( outCode[lineIndex], ")" );
	}
	else if ( checkContext( expr, 7 ) == 1 ) //Variable
	{
		strcat ( outCode[lineIndex], expr );
		strcat ( outCode[lineIndex], ".b() )" );

		registerVar(expr,0);
	}
	else
	{
		printf ( "Wrong constant type in 'if'.\n" );
		abort();
	}

	lineIndex++;

	if ( lineIndex == MAX_LINES )
	{
		printf ( "Input file was too large: " );
		printf ( "I mustn't add important %d. line.\n", MAX_LINES );
		abort();
	}

}


int translateBase( char *bs )
{

	if ( strncmp( bs, "for ", 4 ) == 0 )
	{
		trFor( bs );
		return 1;
	}

	if ( strncmp( bs, "while(", 4 ) == 0 )
	{
		trWhile( bs );
		return 1;
	}

	if ( strncmp( bs, "if(", 3 ) == 0 )
	{
		trIf( bs );
		return 1;
	}

	return 0;
}


void translate( char *trString )
{
int i;
char objName[LINE_LEN] = "", prName[LINE_LEN] = ""; //Needed for properties only
	/*Could be:
		- operation (+ - * / % ^ & )
		- function
		- property
		- method
		- '{', '}xxx'
	*/

	if ( trString[0] == '{' )
	{
		strcpy ( outCode[lineIndex], parstring );
		strcat ( outCode[lineIndex], "{" );

		lineIndex++;

		parstring[strlen(parstring)] = '\t';
		parstring[strlen(parstring)+1] = 0L;

		if ( lineIndex == MAX_LINES )
		{
			printf ( "Input file was too large: " );
			printf ( "I mustn't add important %d. line.\n", MAX_LINES );
			abort();
		}

		return;
	}

	if ( trString[0] == '}' )
	{
		if( strlen(parstring) > 0 )
			parstring[strlen(parstring)-1] = 0L;

		strcpy ( outCode[lineIndex], parstring );

		if( parstring[0] == 0L && hasRet )
		{ /* "Final" '}' in FUNCTION */
			strcat( outCode[lineIndex], "\treturn v(\"\");\n" );
		}

		strcat ( outCode[lineIndex], "}" );

		lineIndex++;

		if ( lineIndex == MAX_LINES )
		{
			printf ( "Input file was too large: " );
			printf ( "I mustn't add important %d. line.\n", MAX_LINES );
			abort();
		}

		return;
	}

	if ( isProperty(trString) )
	{
		// Property READ access

		// 1) Split in a) object, b) property:
		getPrObject( trString, objName );
		getPrProp( trString, prName );

		//Property or method ?
		if( prName[ strlen(prName) -1 ] == ')' )
		{ //method
			printf( "Read access on methods not implemented, yet.\n" );
			abort();
		}
		else
		{ //property

			strcpy( outCode[lineIndex], parstring );
			strcat( outCode[lineIndex], "_h = sendPostCard( \"" );
			strcat( outCode[lineIndex], objName );
			strcat( outCode[lineIndex], "\", \"" );
			strcat( outCode[lineIndex], prName );
			strcat( outCode[lineIndex], "\", 1, \"\" );\n" );

			lineIndex++;
		}

		return;
	}

	i = 0;
	while ( trString[i] != 0 )
	{
		if (trString[i] == '(' ) //it's a function
		{
			trFunction(trString);
			return;
		}

		i++;
	}

	///No property/method and no function? Well, must be an operation:

	trOperation(trString);


} // translate(...)


void translateNext()
{
char thisLine[LINE_LEN] = "";
char varName[129] = "";
char helpStr[LINE_LEN] = "";
char objName[LINE_LEN] = "", prName[LINE_LEN] = ""; //For properties only
int i = 0, ii;

	while ( inCode[myIndex] != 0L && inCode[myIndex] != 10 )
	{
		thisLine[i] = inCode[myIndex];

		myIndex++; i++;
	}

	myIndex++;

	thisLine[i] = 0L;

	if ( inCode[myIndex] == 0L ) finished = 1;


	if( thisLine[0] == '' ) //goto line (special situation)
	{
		for( i = 1; thisLine[i] != ''; i++ )
		{
			outCode[lineIndex][i-1] = thisLine[i];

			if( i == LINE_LEN-2 )
			{
				printf( "Goto label too long (mistake of pre-translator).\n" );
				exit(1);
			}
		}

		outCode[lineIndex][i-1] = ':';
		outCode[lineIndex][i] = '\n';
		outCode[lineIndex][i+1] = 0L;

		lineIndex++;

	}
	else if( isForVar( thisLine ) ) // Is there a variable value to set (x = ...)
	{
		i = 0;

		while( thisLine[i] != '=' && i < 128 )
		{
			varName[i] = thisLine[i];
			i++;
		}

		varName[i] = 0L;

		if (isProperty(varName))
		{
			// Property

			// 1) Split in a) object, b) property:
			getPrObject( varName, objName );
			getPrProp( varName, prName );

			// 2) Get new value:
			i++;

			for ( ii = 0; thisLine[i] != 0L; ii++ )
			{
				helpStr[ii] = thisLine[i];
				i++;
			}

			helpStr[ii] = 0L;

			if( isPure(helpStr) )
			{
				outCode[lineIndex][0] = 0L;
				strcat( outCode[lineIndex], parstring );
				strcat( outCode[lineIndex], "_h.s(" );
				strcat( outCode[lineIndex], helpStr );

				if (checkContext(helpStr,2) == 1)
					strcat( outCode[lineIndex], ".str()" );

				strcat( outCode[lineIndex], ");" );

				lineIndex++;
			}
			else
			{
				translate( helpStr );

				outCode[lineIndex][i] = 0L;
			}

			// 3) Write output:
			strcat( outCode[lineIndex], parstring );
			strcat( outCode[lineIndex], "sendPostCard( \"" );
			strcat( outCode[lineIndex], objName );
			strcat( outCode[lineIndex], "\", \"" );
			strcat( outCode[lineIndex], prName );
			strcat( outCode[lineIndex], "\", 0, _h.str() );\n" );

			lineIndex++;

		}
		else
		{
			registerVar(varName,1);

			i++;

			for ( ii = 0; thisLine[i] != 0L; ii++ )
			{
				helpStr[ii] = thisLine[i];
				i++;
			}

			helpStr[ii] = 0L;

			if( isPure(helpStr) )
			{
				outCode[lineIndex][0] = 0L;
				strcat( outCode[lineIndex], parstring );
				strcat( outCode[lineIndex], varName );
				strcat( outCode[lineIndex], ".s(" );
				strcat( outCode[lineIndex], helpStr );

				if (checkContext(helpStr,2) == 1)
					strcat( outCode[lineIndex], ".str()" );

				strcat( outCode[lineIndex], ");" );
			}
			else
			{
				translate( helpStr );

				outCode[lineIndex][i] = 0L;
				strcat( outCode[lineIndex], parstring );
				strcat( outCode[lineIndex], varName );
				strcat( outCode[lineIndex], ".s(_h);" );
			}

			lineIndex++;

			if ( lineIndex == MAX_LINES )
			{
				printf ( "Input file was too large: " );
				printf ( "I mustn't add important %d. line.\n", MAX_LINES );
				abort();
			}

		} // else{} of: if (isProperty(varName))

	} // if( isForVar( thisLine ) )
	else
	{
		if ( !translateBase( thisLine ) )
			translate( thisLine );
	}

} //translateNext()


int writeTo ( char *fileName )
{
FILE *fp;
int i, ii;

	fp = fopen( fileName, "w" );

	if ( fp == 0L )
	{
		printf ( "Can't write file: Maybe permission denied.\n" );
		return 0;
	}

	// 1) Write own declaration:
	i = 0;
	while( decl[i] != 0 )
	{
		fputc( decl[i], fp );
		i++;
	}

	fputc( '\n', fp ); fputc( '{', fp ); fputc( '\n', fp );

	// 2) Write var's declaration:

	for ( i = 0; i < MAX_VARS; i++ )
	{
		if ( vars[i][0] == 0L ) break;

		if( !hVar[i] )
		{
			fputc( 'v', fp ); fputc( ' ', fp );

			for ( ii = 0; ii < VAR_LEN; ii++ )
			{
				if ( vars[i][ii] == 0L ) break;
				fputc( vars[i][ii], fp );
			}

			fputc( ';', fp ); fputc( '\n', fp );
		}
	}

	fputs( "v _h;\n\n", fp );

	// 3) Write code:

	for( i = 0; outCode[i][0] != 0L; i++ )
	{
		for ( ii = 0; outCode[i][ii] != 0L; ii++ )
			fputc( outCode[i][ii], fp );

		fputc( '\n', fp );
	}


	fclose(fp);

	return 1;

}



/****************************************************************************
				main program
*****************************************************************************/

main( char num, char **envp )
{
	init( envp );


	if (!translateDec())
	{
		printf ( "Invalid declaration.\n" );
		abort();
	}

	while ( !finished )
		translateNext();

	if ( !writeTo( envp[2] ) )
	{
		printf ( "File not written.\n" );
		abort();
	}

	printf ( "Translation complete.\n" );
	exit(0);
	
}