#!/bin/bash

len=$(expr length $0)
len=$(expr $len - 8 )
dir=$(expr substr $0 1 $len )
dir=$(echo "$dir")

cd $dir

ficha=$(expr substr $0 1 1)
if ( expr "$ficha" = "/" )
then
	kvt -e ./quick.sh
	exit 0
fi

cd ../../program

clear

wmsg="WARNING: Your sources WON'T be compiled,\nwe'll run the latest COMPILED version!"

kdialog --msgbox "$wmsg" || xmessage "$wmsg" || dialog --msgbox "$wmsg"

for tstfile in $(ls *)
do
	if (test -x $tstfile)
	then
		echo "Running $tstfile."
		./$tstfile  || (echo -e "\nPROGRAM EXITED ABNORMALLY!\t\t\t[  \033[31mError\033[0m  ]"; exit 1) \
		|| exit 1
		exit 0
	fi
done

emsg="No executable file. You must compile your program before you can run it!"

kdialog --msgbox "$emsg" || xmessage "$emsg" || dialog --msgbox "$emsg"

exit 2