/***************************************************************************
                          valueeditor.h  -  description                              
                             -------------------                                         
    begin                : Sat Mar 20 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef VALUEEDITOR_H
#define VALUEEDITOR_H

#include <qwidget.h>

class Value;

/**
	* A container inside which subclasses should place their editor widget.
	*
  * @author Richard Moore
  */
class ValueEditor : public QWidget {
	Q_OBJECT

public: 
	ValueEditor(QWidget *parent, const char *name= 0);
	virtual ~ValueEditor();

	void setValue(Value *);
	Value *value();

public slots:
	virtual void cancel();
	virtual void accept();

signals:
	void cancelled();
	void accepted();
	void accepted(Value *);
	void resized();

protected:
	void resizeEvent(QResizeEvent *);
	virtual void saveValue();

private:
	Value *val;
};

#endif













