/***************************************************************************
                          stringvalue.h  -  description                              
                             -------------------                                         
    begin                : Fri Mar 19 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef STRINGVALUE_H
#define STRINGVALUE_H

#include <qstring.h>
#include "value.h"

/**
	* Represents a string value.
	*
  * @author Richard Moore
  */
class StringValue : public Value  {
public: 
	StringValue();
	virtual ~StringValue();

	virtual ValueEditor *createEditor(QWidget *);

	/**
		* Convert the value to a string.
		*/
	virtual const char *toString();

	/**
		* Set the value from a string.
		*/
	virtual void fromString(const char *);
protected:
	QString text_;
};

#endif



