/***************************************************************************
                          kguidoc.h  -  description                              
                             -------------------                                         
    begin                : Mon Mar 15 23:42:04 GMT 1999
                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KGUIDOC_H
#define KGUIDOC_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qobject.h>
#include "instance.h"

/**
  * This class provides base functionality for your application document
  */
class KGUIDoc : public QObject
{
  Q_OBJECT

 public:
  /** Constructor for the fileclass of the application */
  KGUIDoc(QObject*, const char *filename=0L);
  /** Destructor for the fileclass of the application */
  ~KGUIDoc();

	/** Get the root Instance of this form */
	Instance *rootInstance();

	/** Signal all view to update */
	void refreshViews(Instance *root= 0);
	
	/** Remove the nth child of the Instance */
	void remove(Instance *, int n);
	
	/** Exchange the mth and nth children of the Instance */
	void swap(Instance *, int m, int n);

	/** Insert an instance of the specified component as the child of the selection */
	bool insert(Component *);
	
public slots:
	/** Select the specified instance */
	void select(Instance *);
		
signals:
	/**
		* Emitted whenever views of the document should be updated.
		*/
	void update();
	
	/**
		* Emitted whenever views of the document should be updated. This signal
		* specifies the instance at the root of the sub-tree to be updated.
		*/
	void update(Instance *);
	
 private:
	/** The top level widget of this form */
	Instance *toplevel;
	
	/** The selected instance or 0 */
	Instance *selection_;
};

#endif // KGUIDOC_H





















