/***************************************************************************
                          enumvalue.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Mar 19 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include <qlabel.h>
#include <qlayout.h>
#include "enumvalue.h"
#include "enumvalueeditor.h"

EnumValue::EnumValue()
	: valueNames_(),
		values_()
{
	selectedIndex= 0;
	valueNames_.setAutoDelete(true);
	values_.setAutoDelete(true);
}

EnumValue::~EnumValue()
{
}


ValueEditor *EnumValue::createEditor(QWidget *parent)
{
	ValueEditor *frame= new EnumValueEditor(parent, "Enum editor", this);
	CHECK_PTR(frame);

	return frame;
}


const char *EnumValue::toString()
{
	return valueNames_.at(selectedIndex);
}

void EnumValue::fromString(const char *str)
{
	ASSERT(str);


	warning("Enum value from string not implemented");
}

int EnumValue::toInt()
{
	int *i= values_.at(selectedIndex);
	return *i;
}

int EnumValue::index()
{
	return selectedIndex;
}

void EnumValue::setIndex(int selection)
{
	selectedIndex= selection;
}

void EnumValue::addValue(const char *name, int v)
{
	valueNames_.append(name);
	values_.append(new int(v));
}

const QStrList *EnumValue::valueNames()
{
	return &valueNames_;
}













