/***************************************************************************
                          componentmanager.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Mar 18 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "labelcomponent.h"
#include "formcomponent.h"
#include "package.h"
#include "componentmanager.h"
#include "pluginloader.h"

ComponentManager::ComponentManager()
	: packages()
{
	registerPackages();
}

ComponentManager::~ComponentManager()
{
}

void ComponentManager::addPackage(Package *c)
{
	ASSERT(c);

	packages.append(c);
}

uint ComponentManager::packageCount()
{
	return packages.count();
}

Package *ComponentManager::package(uint n)
{
	return packages.at(n);
}


QPopupMenu *ComponentManager::createInsertPopup(QPopupMenu *parent)
{
	// The top level menu
	QPopupMenu *m= new QPopupMenu();
	CHECK_PTR(m);

	// The package submenu
	QPopupMenu *p;

	// For each package
	for (uint i= 0; i < packageCount(); i++) {
		p= new QPopupMenu();
		CHECK_PTR(p);
		
		Package *pack= package(i);
		
		// Calculate the IDs
		int pkgId= (i + 1) << 16;
		
		// For each component
		for (uint j= 0; j < pack->componentCount(); j++) {
			warning("id for Comp %s is %d", pack->component(j)->name(), pkgId + j );
		
			// Put the first registered package into the top menu
			if (i == 0)
				m->insertItem(pack->component(j)->name(), pkgId + j + 1);
			else
				p->insertItem(pack->component(j)->name(), pkgId + j + 1);
		}
		
		if (i != 0) {
			// Insert the submenu
			m->insertItem(pack->name(), p, pkgId);
			
			// Cunningly foward the signals via the parent popup menu!
			connect( p, SIGNAL(activated(int)), m, SIGNAL(activated(int)) );
			connect( p, SIGNAL(highlighted(int)), m, SIGNAL(highlighted(int)) );
		}
		else
			m->insertSeparator();
	}
	
	if (parent != 0) {
		// Cunningly foward the signals via the parent popup menu!
		connect( m, SIGNAL(activated(int)), parent, SIGNAL(activated(int)) );
		connect( m, SIGNAL(highlighted(int)), parent, SIGNAL(highlighted(int)) );	
	}
	
	return m;
}

Component *ComponentManager::component(int id)
{
	// warning("ComponentManager::component(%d) called", id);

	Package *p;
	uint pkg= id >> 16;
	int comp= id % 65536;
	
	if (id > (1 << 16)) {
		pkg--;
		comp--;
	
		if ( (pkg < packageCount()) && (pkg >= 0) ){
			p= package(pkg);
		}
		else {
			p= 0;
		}
	}
	else {
		p= 0;
	}
	
	if (!p)
		return 0;
	else	
		return p->component(comp);
}

Package *ComponentManager::packageFromId(int id)
{
	Package *p;
	uint pkg= id >> 16;
	int comp= id % 65536;
	
	if (id > (1 << 16)) {
		pkg--;
		comp--;
	
		if ( (pkg < packageCount()) && (pkg >= 0) ) {
			p= package(pkg);
		}
		else
			p= 0;
	}
	else {
		p= 0;
	}
	return p;
}

void ComponentManager::registerPackages()
{
	Package *qt= new Package("Standard widgets", "Not just yet");
	CHECK_PTR(qt);
	
	qt->addComponent(new FormComponent());
	qt->addComponent(new LabelComponent());
	addPackage(qt);
	
	PluginLoader::install(this);
}




























