/***************************************************************************
                          component.h  -  description                              
                             -------------------                                         
    begin                : Tue Mar 16 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef COMPONENT_H
#define COMPONENT_H

#include <qobject.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qlist.h>

class Package;

/**
 * Represents a Component that is available for use in the GUI builder. These
 * are created by a Package.
 *
 * @author Richard Moore
 */
class Component : public QObject  {
public: 
	/**
		* Create a component named 'name' and with the specified short description.
		*/
	Component(const char *name, const char *description, Package *provider= 0);
	virtual ~Component();

	/**
		* User visible name for this component type.
		*/
	const char *name();
	
	/**
		* Pixmap to be used for instances of this component in the tree view (and
		* also elsewhere)
		*/
	virtual QPixmap pixmap();

	/**
		* User visible short description for this component type.
		*/
	const char *description();

	/**
		* The number of super-Components that contribute to this component.
		*/
	uint superCount();
	
	/**
		* Return the super-Component at index n.
		*/
	Component *super(uint n);
	
	/**
		* Adds a new Component to the list. Each super can provide properties
		*
		*/
	void addSuper(Component *c);

	/**
		* The Package that provided this Component.
		*/
	Package *package();
	
	/**
		* Set the Package that provides this component.
		*/
	void setPackage(Package *provider);
	
	/**
		* Create an Instance of this Component, with the specified Instance as parent.
		*/
  virtual class Instance *createInstance(Instance *parent);

  /**
  	* Create a view of the specified Instance with the specified widget as the parent
  	* view. The properties of the QWidget are updated from the Instance using
  	* updateView().
  	*/
	virtual QWidget *createView(Instance *props, QWidget *parent);
	
	/**
		* Update the specified view using the properties of the specified Instance.
		*/
	virtual void updateView(Instance *props, QWidget *view);

protected:
	QString name_;
	QString description_;
	QList <Component> supers;
	Package *provider;
};

#endif






















