#include <package.h>
#include "lampcomponent.h"

// The hook function MUST be defined as extern "C" otherwise the plugin
// will not work. This is to remove the problem of name mangling by the
// C++ compiler.
extern "C" {
  /**
   * The hook that is called when the plugin is loaded. This should return
   * a Package instance containing all of the Components provided by this
   * package.
   */
  Package *init_kgui_plugin()
  {
    // Create the Package specifying the name and description. You can also
    // specify the URL for help on the plugin, but this is optional. See the
    // Package class API docs for more details.
    Package *t= new Package("Demo plugin", "KLed plugin");
    CHECK_PTR(t);
  
    // Note that packages will normally contain several widgets, not
    // just one as in this example.

    // Add our LED component
    t->addComponent(new LampComponent());
    
    // Return the Package so it can be installed.
    return t;
  }
}
